/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.follow.command;

import com.els.base.common.AbstractFollowCommand;
import com.els.base.common.FollowInvorker;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.follow.entity.Follow;
import com.els.base.follow.entity.FollowExample;
import java.util.Date;
import java.util.List;

public class ConfirmCommand
extends AbstractFollowCommand<String> {
    private List<String> ids;

    public ConfirmCommand(List<String> ids) {
        Assert.isNotEmpty(ids, "ID\u4e0d\u80fd\u4e3a\u7a7a");
        this.ids = ids;
    }

    @Override
    public String execute(FollowInvorker followInvorker) {
        this.followInvorker = followInvorker;
        this.validData(this.ids);
        this.confirmData(this.ids);
        return null;
    }

    private void confirmData(List<String> followIds) {
        FollowExample example = new FollowExample();
        example.createCriteria().andIdIn((List)followIds);
        Follow follow = new Follow();
        follow.setConfirmStatus(Constant.YES_INT);
        follow.setConfirmTime(new Date());
        this.followInvorker.getFollowService().updateByExampleSelective(follow, example);
    }

    private void validData(List<String> followIds) {
        FollowExample example = new FollowExample();
        example.createCriteria().andSendStatusEqualTo(Constant.YES_INT).andConfirmStatusEqualTo(Constant.NO_INT).andIdIn((List)followIds);
        int count = this.followInvorker.getFollowService().countByExample(example);
        if (count != followIds.size()) {
            throw new CommonException("\u53ea\u6709\u5f53\u5904\u4e8e\u5df2\u53d1\u9001\uff0c\u672a\u786e\u8ba4\u72b6\u6001\u4e0b\u7684\u8bb0\u5f55\u624d\u80fd\u6267\u884c\u6b64\u64cd\u4f5c");
        }
    }
}

