/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.follow.command;

import com.els.base.common.AbstractFollowCommand;
import com.els.base.common.FollowInvorker;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.follow.entity.Follow;
import com.els.base.followitem.entity.FollowItem;
import com.els.base.followplan.entity.FollowPlan;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.transaction.annotation.Transactional;

public class CreateCommand
extends AbstractFollowCommand<String> {
    private Follow follow;

    public CreateCommand(Follow follow) {
        this.follow = follow;
    }

    @Override
    @Transactional
    public String execute(FollowInvorker followInvorker) {
        this.followInvorker = followInvorker;
        this.validate(this.follow);
        this.save(this.follow);
        return null;
    }

    private void save(Follow follow) {
        this.fill(follow);
        this.followInvorker.getFollowService().addObj(follow);
        List<FollowItem> followItems = follow.getFollowItemList();
        ArrayList<FollowPlan> followPlans = new ArrayList<FollowPlan>();
        for (FollowItem followItem : followItems) {
            followItem.setId(UUIDGenerator.generateUUID());
            followItem.setFollowId(follow.getId());
            followItem.setFollowNo(follow.getFollowNo());
            int sortNo = 1;
            Date now = new Date();
            for (FollowPlan followPlan : followItem.getFollowPlanList()) {
                followPlan.setId(UUIDGenerator.generateUUID());
                followPlan.setFollowId(follow.getId());
                followPlan.setFollowItemId(followItem.getId());
                followPlan.setSortNo(sortNo++);
                followPlan.setCreateTime(now);
            }
            followPlans.addAll(followItem.getFollowPlanList());
        }
        this.followInvorker.getFollowItemService().addAll(followItems);
        this.followInvorker.getFollowPlanService().addAll(followPlans);
    }

    private void fill(Follow follow) {
        follow.setId(UUIDGenerator.generateUUID());
        follow.setProjectId(this.getProject().getId());
        follow.setPurCompanyId(this.getPurCompany().getId());
        follow.setPurCompanyName(this.getPurCompany().getCompanyName());
        follow.setPurCompanyFullName(this.getPurCompany().getCompanyFullName());
        follow.setPurCompanySrmCode(this.getPurCompany().getCompanyCode());
        String supCompanySapCode = follow.getSupCompanySapCode();
        CompanyExample companyExample = new CompanyExample();
        companyExample.createCriteria().andCompanySapCodeEqualTo(supCompanySapCode);
        List companyList = this.followInvorker.getCompanyService().queryAllObjByExample(companyExample);
        Assert.isNotEmpty(companyList, "\u4f9b\u5e94\u5546\u4e0d\u5b58\u5728SRM\u7cfb\u7edf\uff0c\u8bf7\u68c0\u67e5\uff01");
        Company company = (Company)companyList.get(0);
        follow.setSupCompanySapCode(supCompanySapCode);
        follow.setSupCompanyId(company.getId());
        follow.setSupCompanyFullName(company.getCompanyFullName());
        follow.setSupCompanyName(company.getCompanyName());
        follow.setSupCompanySrmCode(company.getCompanyCode());
        follow.setFollowNo(this.followInvorker.getGenerateCodeService().getNextCode("FOLLOW_NO"));
        follow.setCreateBillUserId(this.getPurUser().getId());
        follow.setCreateBillUserName(this.getPurUser().getNickName());
        follow.setIsEnable(Constant.YES_INT);
        follow.setCreateTime(new Date());
        follow.setSendStatus(Constant.NO_INT);
        follow.setConfirmStatus(Constant.NO_INT);
    }

    private void validate(Follow follow) {
        Assert.isNotNull(follow, "\u8ba2\u5355\u8ddf\u8e2a\u8ba1\u5212\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isNotNull(follow.getSupCompanySapCode(), "\u4f9b\u5e94\u5546SAP\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        List<FollowItem> followItemList = follow.getFollowItemList();
        Assert.isNotEmpty(followItemList, "\u8ddf\u8e2a\u8ba1\u5212\u884c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        for (FollowItem followItem : followItemList) {
            List<FollowPlan> followPlanList = followItem.getFollowPlanList();
            Assert.isNotEmpty(followPlanList, "\u8ba2\u5355\u8ddf\u8e2a\u65f6\u95f4\u8ba1\u5212\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            for (FollowPlan followPlan : followPlanList) {
                Assert.isNotNull(followPlan, "\u8ba2\u5355\u8ddf\u8e2a\u65f6\u95f4\u8ba1\u5212\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }
}

