/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.follow.command;

import com.els.base.common.AbstractFollowCommand;
import com.els.base.common.FollowInvorker;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.follow.entity.FollowExample;
import com.els.base.followitem.entity.FollowItemExample;
import com.els.base.followplan.entity.FollowPlanExample;
import java.util.List;

public class DeleteCommand
extends AbstractFollowCommand<String> {
    private List<String> ids;

    public DeleteCommand(List<String> ids) {
        Assert.isNotEmpty(ids, "ID\u4e0d\u80fd\u4e3a\u7a7a");
        this.ids = ids;
    }

    @Override
    public String execute(FollowInvorker followInvorker) {
        this.followInvorker = followInvorker;
        this.validData(this.ids);
        this.deleteData(this.ids);
        return null;
    }

    private void deleteData(List<String> followIds) {
        this.deleteFollow(followIds);
        this.deleteFollowItems(followIds);
        this.deleteFollowPlans(followIds);
    }

    private void deleteFollowPlans(List<String> followIds) {
        FollowPlanExample example = new FollowPlanExample();
        example.createCriteria().andFollowIdIn((List)followIds);
        this.followInvorker.getFollowPlanService().deleteByExample(example);
    }

    private void deleteFollowItems(List<String> followIds) {
        FollowItemExample example = new FollowItemExample();
        example.createCriteria().andFollowIdIn((List)followIds);
        this.followInvorker.getFollowItemService().deleteByExample(example);
    }

    private void deleteFollow(List<String> followIds) {
        FollowExample example = new FollowExample();
        example.createCriteria().andIdIn((List)followIds);
        this.followInvorker.getFollowService().deleteByExample(example);
    }

    private void validData(List<String> followIds) {
        FollowExample example = new FollowExample();
        example.createCriteria().andSendStatusEqualTo(Constant.NO_INT).andConfirmStatusEqualTo(Constant.NO_INT).andIdIn((List)followIds);
        int count = this.followInvorker.getFollowService().countByExample(example);
        if (count != followIds.size()) {
            throw new CommonException("\u53ea\u6709\u5f53\u5904\u4e8e\u672a\u53d1\u9001\uff0c\u672a\u786e\u8ba4\u72b6\u6001\u4e0b\u7684\u8bb0\u5f55\u624d\u80fd\u6267\u884c\u6b64\u64cd\u4f5c");
        }
    }
}

