/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.follow.command;

import com.els.base.common.AbstractFollowCommand;
import com.els.base.common.FollowInvorker;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.follow.entity.Follow;
import com.els.base.followitem.entity.FollowItem;
import com.els.base.followitem.entity.FollowItemExample;
import com.els.base.followplan.entity.FollowPlan;
import com.els.base.followplan.entity.FollowPlanExample;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.transaction.annotation.Transactional;

public class UpdateCommand
extends AbstractFollowCommand<String> {
    private Follow follow;

    public UpdateCommand(Follow follow) {
        this.follow = follow;
    }

    @Override
    @Transactional
    public String execute(FollowInvorker followInvorker) {
        this.followInvorker = followInvorker;
        this.validate(this.follow);
        this.update(this.follow);
        return null;
    }

    private void update(Follow newFollow) {
        Follow oldFollow = (Follow)this.followInvorker.getFollowService().queryObjById(newFollow.getId());
        if (oldFollow == null) {
            throw new CommonException("\u8ddf\u8e2a\u8868ID\uff1a\u3010" + newFollow.getId() + "\u3011\u4e0d\u5b58\u5728\uff0c\u4e0d\u80fd\u8fdb\u884c\u7f16\u8f91\uff01");
        }
        if (Constant.YES_INT.equals(oldFollow.getSendStatus())) {
            throw new CommonException("\u53ea\u80fd\u5bf9\u672a\u53d1\u9001\u7684\u8ddf\u8e2a\u8868\u8fdb\u884c\u7f16\u8f91\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        oldFollow.setPurRemark(newFollow.getPurRemark());
        this.followInvorker.getFollowService().modifyObj(oldFollow);
        FollowItemExample followItemExample = new FollowItemExample();
        followItemExample.createCriteria().andFollowIdEqualTo(oldFollow.getId());
        this.followInvorker.getFollowItemService().deleteByExample(followItemExample);
        FollowPlanExample followPlanExample = new FollowPlanExample();
        followPlanExample.createCriteria().andFollowIdEqualTo(oldFollow.getId());
        this.followInvorker.getFollowPlanService().deleteByExample(followPlanExample);
        List<FollowItem> followItems = newFollow.getFollowItemList();
        ArrayList<FollowPlan> followPlans = new ArrayList<FollowPlan>();
        for (FollowItem followItem : followItems) {
            followItem.setId(UUIDGenerator.generateUUID());
            followItem.setFollowId(oldFollow.getId());
            followItem.setFollowNo(oldFollow.getFollowNo());
            int sortNo = 1;
            Date now = new Date();
            for (FollowPlan followPlan : followItem.getFollowPlanList()) {
                followPlan.setId(UUIDGenerator.generateUUID());
                followPlan.setFollowId(oldFollow.getId());
                followPlan.setFollowItemId(followItem.getId());
                followPlan.setSortNo(sortNo++);
                followPlan.setCreateTime(now);
            }
            followPlans.addAll(followItem.getFollowPlanList());
        }
        this.followInvorker.getFollowItemService().insertBatch(followItems);
        this.followInvorker.getFollowPlanService().insertBatch(followPlans);
    }

    private void validate(Follow follow) {
        Assert.isNotNull(follow, "\u8ba2\u5355\u8ddf\u8e2a\u8ba1\u5212\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isNotBlank(follow.getId(), "\u8ba2\u5355\u8ddf\u8e2aID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isNotBlank(follow.getSupCompanySapCode(), "\u4f9b\u5e94\u5546SAP\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        List<FollowItem> followItemList = follow.getFollowItemList();
        Assert.isNotEmpty(followItemList, "\u8ddf\u8e2a\u8ba1\u5212\u884c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        for (FollowItem followItem : followItemList) {
            List<FollowPlan> followPlanList = followItem.getFollowPlanList();
            Assert.isNotEmpty(followPlanList, "\u8ba2\u5355\u8ddf\u8e2a\u65f6\u95f4\u8ba1\u5212\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            for (FollowPlan followPlan : followPlanList) {
                Assert.isNotNull(followPlan, "\u8ba2\u5355\u8ddf\u8e2a\u65f6\u95f4\u8ba1\u5212\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
                Assert.isNotBlank(followPlan.getProductName(), "\u8ba2\u5355\u8ddf\u8e2a\u65f6\u95f4\u8ba1\u5212\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }
}

