/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.follow.command;

import com.els.base.common.AbstractFollowCommand;
import com.els.base.common.FollowInvorker;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.follow.entity.Follow;
import com.els.base.followitem.entity.FollowItem;
import com.els.base.followitem.entity.FollowItemExample;
import com.els.base.followplan.entity.FollowPlan;
import com.els.base.followplan.entity.FollowPlanExample;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class ViewDetailCommand
extends AbstractFollowCommand<Follow> {
    private String id;

    public ViewDetailCommand(String id) {
        Assert.isNotBlank(id, "ID\u4e0d\u80fd\u4e3a\u7a7a");
        this.id = id;
    }

    @Override
    public Follow execute(FollowInvorker followInvorker) {
        this.followInvorker = followInvorker;
        Follow follow = (Follow)followInvorker.getFollowService().queryObjById(this.id);
        if (follow == null) {
            throw new CommonException("\u6839\u636e\u4e3b\u952e\u65e0\u6cd5\u67e5\u8be2\u8ba2\u5355\u5934\u6570\u636e");
        }
        List<FollowItem> followItems = this.queryFollowItems(follow.getId());
        if (CollectionUtils.isEmpty(followItems)) {
            throw new CommonException("\u6839\u636e\u4e3b\u952e\u65e0\u6cd5\u67e5\u8be2\u8ba2\u5355\u884c\u6570\u636e");
        }
        follow.setFollowItemList(followItems);
        List<String> followItemIds = followItems.stream().map(FollowItem::getId).collect(Collectors.toList());
        List<FollowPlan> followPlans = this.queryFollowPlans(followItemIds);
        this.fillFollowItemData(followItems, followPlans);
        return follow;
    }

    private void fillFollowItemData(List<FollowItem> followItems, List<FollowPlan> followPlans) {
        ArrayListMultimap multimap = ArrayListMultimap.create();
        followPlans.forEach(arg_0 -> ViewDetailCommand.lambda$fillFollowItemData$0((Multimap)multimap, arg_0));
        followItems.forEach(arg_0 -> ViewDetailCommand.lambda$fillFollowItemData$1((Multimap)multimap, arg_0));
    }

    private List<FollowPlan> queryFollowPlans(List<String> followItemIds) {
        FollowPlanExample example = new FollowPlanExample();
        example.createCriteria().andFollowItemIdIn((List)followItemIds);
        return this.followInvorker.getFollowPlanService().queryAllObjByExample(example);
    }

    private List<FollowItem> queryFollowItems(String followId) {
        FollowItemExample example = new FollowItemExample();
        example.createCriteria().andFollowIdEqualTo(followId);
        return this.followInvorker.getFollowItemService().queryAllObjByExample(example);
    }

    private static /* synthetic */ void lambda$fillFollowItemData$1(Multimap multimap, FollowItem followItem) {
        followItem.setFollowPlanList(new ArrayList(multimap.get((Object)followItem.getId())).stream().sorted(Comparator.comparing(FollowPlan::getSortNo)).collect(Collectors.toList()));
    }

    private static /* synthetic */ void lambda$fillFollowItemData$0(Multimap multimap, FollowPlan followPlan) {
        multimap.put((Object)followPlan.getFollowItemId(), (Object)followPlan);
    }
}

