/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.follow.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.follow.dao.FollowMapper;
import com.els.base.follow.entity.Follow;
import com.els.base.follow.entity.FollowExample;
import com.els.base.follow.service.FollowService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultFollowService")
public class FollowServiceImpl
implements FollowService {
    @Resource
    protected FollowMapper followMapper;

    @Override
    @CacheEvict(value={"follow"}, allEntries=true)
    public void addObj(Follow t) {
        this.followMapper.insertSelective(t);
    }

    @Override
    @Transactional
    @CacheEvict(value={"follow"}, allEntries=true)
    public void addAll(List<Follow> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.followMapper.insertBatch(list);
    }

    @Override
    @CacheEvict(value={"follow"}, allEntries=true)
    public void deleteObjById(String id) {
        this.followMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"follow"}, allEntries=true)
    public void deleteByExample(FollowExample example) {
        Assert.isNotNull(example, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), "\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.followMapper.deleteByExample(example);
    }

    @Override
    @CacheEvict(value={"follow"}, allEntries=true)
    public void modifyObj(Follow t) {
        Assert.isNotBlank(t.getId(), "id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.followMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"follow"}, keyGenerator="redisKeyGenerator")
    public Follow queryObjById(String id) {
        return this.followMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"follow"}, keyGenerator="redisKeyGenerator")
    public List<Follow> queryAllObjByExample(FollowExample example) {
        return this.followMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"follow"}, keyGenerator="redisKeyGenerator")
    public PageView<Follow> queryObjByPage(FollowExample example) {
        PageView<Follow> pageView = example.getPageView();
        pageView.setQueryResult(this.followMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"follow"}, allEntries=true)
    public int updateByExampleSelective(Follow record, FollowExample example) {
        return this.followMapper.updateByExampleSelective(record, example);
    }

    @Override
    @Cacheable(value={"follow"}, keyGenerator="redisKeyGenerator")
    public int countByExample(FollowExample example) {
        return this.followMapper.countByExample(example);
    }
}

