/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.follow.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.common.FollowInvorker;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.user.User;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.follow.command.ConfirmCommand;
import com.els.base.follow.command.CreateCommand;
import com.els.base.follow.command.DeleteCommand;
import com.els.base.follow.command.FillDataCommand;
import com.els.base.follow.command.SendCommand;
import com.els.base.follow.command.UpdateCommand;
import com.els.base.follow.command.ViewDetailCommand;
import com.els.base.follow.entity.Follow;
import com.els.base.follow.entity.FollowExample;
import com.els.base.follow.service.FollowService;
import com.els.base.followplan.entity.FollowPlan;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u8ba2\u5355\u751f\u4ea7\u8ba1\u5212\u8ddf\u8e2a\u8868")
@Controller
@RequestMapping(value={"follow"})
public class FollowController {
    @Resource
    protected FollowService followService;
    @Resource
    private FollowInvorker invoker;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u8ba2\u5355\u751f\u4ea7\u8ba1\u5212\u8ddf\u8e2a\u8868")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody Follow follow) {
        this.followService.addObj(follow);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u65b9\u7f16\u8f91\u8ba2\u5355\u751f\u4ea7\u8ba1\u5212\u8ddf\u8e2a\u8868")
    @RequestMapping(value={"service/pur/edit"})
    @ResponseBody
    public ResponseResult<String> purEdit(@RequestBody Follow follow) {
        UpdateCommand cmd = new UpdateCommand(follow);
        cmd.setPurUser((User)SpringSecurityUtils.getLoginUser());
        cmd.setProject(ProjectUtils.getProject());
        cmd.setPurCompany(CompanyUtils.getPurCompanyOfCurrentCompany());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u8ba2\u5355\u751f\u4ea7\u8ba1\u5212\u8ddf\u8e2a\u8868")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, "\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        FollowExample example = new FollowExample();
        example.createCriteria().andIdIn((List)ids);
        this.followService.deleteByExample(example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6839\u636e\u8ba2\u5355\u751f\u4ea7\u8ba1\u5212\u8ddf\u8e2a\u8868ID\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"service/findById"})
    @ResponseBody
    public ResponseResult<Follow> findById(@RequestParam(required=true) String id) {
        Assert.isNotBlank(id, "\u67e5\u8be2\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        Follow follow = (Follow)this.followService.queryObjById(id);
        return ResponseResult.success(follow);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u8ba2\u5355\u751f\u4ea7\u8ba1\u5212\u8ddf\u8e2a\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Follow", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<Follow>> findByPage(@RequestParam(defaultValue="1") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        FollowExample example = new FollowExample();
        example.setPageView(new PageView<Follow>(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        FollowExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT).andPurCompanyIdEqualTo(ProjectUtils.getCompanyId()).andIsEnableEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        PageView pageData = this.followService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u8ba2\u5355\u751f\u4ea7\u8ba1\u5212\u8ddf\u8e2a\u8868")
    @RequestMapping(value={"service/createFollow"})
    @ResponseBody
    public ResponseResult<String> createFollow(@RequestBody Follow follow) {
        CreateCommand cmd = new CreateCommand(follow);
        cmd.setPurUser((User)SpringSecurityUtils.getLoginUser());
        cmd.setPurCompany(CompanyUtils.currentCompany());
        cmd.setProject(ProjectUtils.getProject());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u770b\u8be6\u60c5")
    @RequestMapping(value={"service/viewDetail"})
    @ResponseBody
    public ResponseResult<Follow> viewDetail(@RequestParam String id) {
        ViewDetailCommand cmd = new ViewDetailCommand(id);
        return ResponseResult.success(this.invoker.invoke(cmd));
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u5220\u9664\u8ba2\u5355\u751f\u4ea7\u8ba1\u5212\u8ddf\u8e2a\u8868")
    @RequestMapping(value={"service/batchDelete"})
    @ResponseBody
    public ResponseResult<String> batchDelete(@RequestBody List<String> ids) {
        DeleteCommand cmd = new DeleteCommand(ids);
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u53d1\u9001\u8ba2\u5355\u751f\u4ea7\u8ba1\u5212\u8ddf\u8e2a\u8868")
    @RequestMapping(value={"service/batchSend"})
    @ResponseBody
    public ResponseResult<String> batchSend(@RequestBody List<String> ids) {
        SendCommand cmd = new SendCommand(ids);
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u8ba2\u5355\u751f\u4ea7\u8ba1\u5212\u8ddf\u8e2a\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Follow", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/supplierFindByPage"})
    @ResponseBody
    public ResponseResult<PageView<Follow>> supplierFindByPage(@RequestParam(defaultValue="1") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        FollowExample example = new FollowExample();
        example.setPageView(new PageView<Follow>(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        FollowExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT).andSupCompanyIdEqualTo(CompanyUtils.currentCompanyId()).andSendStatusEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        PageView pageData = this.followService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u6279\u91cf\u786e\u8ba4\u8ba2\u5355\u751f\u4ea7\u8ba1\u5212\u8ddf\u8e2a\u8868")
    @RequestMapping(value={"service/supplierBatchConfirm"})
    @ResponseBody
    public ResponseResult<String> supplierBatchConfirm(@RequestBody List<String> ids) {
        ConfirmCommand cmd = new ConfirmCommand(ids);
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u586b\u5199\u8fdb\u5ea6\u548c\u8ba1\u5212")
    @RequestMapping(value={"service/supplierFillData"})
    @ResponseBody
    public ResponseResult<Follow> supplierFillData(@RequestBody FollowPlan followPlan) {
        FillDataCommand cmd = new FillDataCommand(followPlan);
        return ResponseResult.success(this.invoker.invoke(cmd));
    }
}

