/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.followitem.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.followitem.dao.FollowItemMapper;
import com.els.base.followitem.entity.FollowItem;
import com.els.base.followitem.entity.FollowItemExample;
import com.els.base.followitem.service.FollowItemService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultFollowItemService")
public class FollowItemServiceImpl
implements FollowItemService {
    @Resource
    protected FollowItemMapper followItemMapper;

    @Override
    @CacheEvict(value={"followItem"}, allEntries=true)
    public int insertBatch(List<FollowItem> list) {
        Assert.isNotEmpty(list, "\u8ddf\u8e2a\u8ba1\u5212\u8868\u884c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        return this.followItemMapper.insertBatch(list);
    }

    @Override
    @CacheEvict(value={"followItem"}, allEntries=true)
    public void addObj(FollowItem t) {
        this.followItemMapper.insertSelective(t);
    }

    @Override
    @Transactional
    @CacheEvict(value={"followItem"}, allEntries=true)
    public void addAll(List<FollowItem> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.followItemMapper.insertBatch(list);
    }

    @Override
    @CacheEvict(value={"followItem"}, allEntries=true)
    public void deleteObjById(String id) {
        this.followItemMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"followItem"}, allEntries=true)
    public void deleteByExample(FollowItemExample example) {
        Assert.isNotNull(example, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), "\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.followItemMapper.deleteByExample(example);
    }

    @Override
    @CacheEvict(value={"followItem"}, allEntries=true)
    public void modifyObj(FollowItem t) {
        Assert.isNotBlank(t.getId(), "id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.followItemMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"followItem"}, keyGenerator="redisKeyGenerator")
    public FollowItem queryObjById(String id) {
        return this.followItemMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"followItem"}, keyGenerator="redisKeyGenerator")
    public List<FollowItem> queryAllObjByExample(FollowItemExample example) {
        return this.followItemMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"followItem"}, keyGenerator="redisKeyGenerator")
    public PageView<FollowItem> queryObjByPage(FollowItemExample example) {
        PageView<FollowItem> pageView = example.getPageView();
        pageView.setQueryResult(this.followItemMapper.selectByExampleByPage(example));
        return pageView;
    }
}

