/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.followplan.command;

import com.els.base.common.AbstractFollowCommand;
import com.els.base.common.FollowInvorker;
import com.els.base.core.utils.Assert;
import com.els.base.followplan.entity.FollowPlanTemplate;
import java.math.BigDecimal;
import java.util.Date;

public class CreateCommand
extends AbstractFollowCommand<String> {
    private FollowPlanTemplate followPlanTemplate;

    public CreateCommand(FollowPlanTemplate followPlanTemplate) {
        this.followPlanTemplate = followPlanTemplate;
    }

    @Override
    public String execute(FollowInvorker followInvorker) {
        this.followInvorker = followInvorker;
        this.validate(this.followPlanTemplate);
        this.save(this.followPlanTemplate);
        return null;
    }

    private void save(FollowPlanTemplate followPlanTemplate) {
        followPlanTemplate.setId(null);
        followPlanTemplate.setCreateTime(new Date());
        followPlanTemplate.setUpdateTime(new Date());
        if (followPlanTemplate.getPlannEndTime() != null && followPlanTemplate.getActualEndTime() != null) {
            long spendTime = (followPlanTemplate.getActualEndTime().getTime() - followPlanTemplate.getPlannEndTime().getTime()) / 86400000L;
            followPlanTemplate.setSpendTime(new BigDecimal(spendTime));
        }
        this.followInvorker.getFollowPlanTemplateService().addObj(followPlanTemplate);
    }

    private void validate(FollowPlanTemplate followPlanTemplate) {
        Assert.isNotNull(followPlanTemplate, "\u8ddf\u8e2a\u8ba1\u5212\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isNotBlank(followPlanTemplate.getProductName(), "\u8ddf\u8e2a\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isNotBlank(followPlanTemplate.getProductType(), "\u8ddf\u8e2a\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
    }
}

