/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.followplan.command;

import com.els.base.common.AbstractFollowCommand;
import com.els.base.common.FollowInvorker;
import com.els.base.core.utils.Assert;
import com.els.base.followplan.entity.FollowPlan;
import java.math.BigDecimal;

public class CreatePlanCommand
extends AbstractFollowCommand<String> {
    private FollowPlan followPlan;

    public CreatePlanCommand(FollowPlan followPlan) {
        this.followPlan = followPlan;
    }

    @Override
    public String execute(FollowInvorker followInvorker) {
        this.followInvorker = followInvorker;
        this.validate(this.followPlan);
        this.save(this.followPlan);
        return null;
    }

    private void save(FollowPlan followPlan) {
        followPlan.setId(null);
        followPlan.setFollowId(null);
        followPlan.setFollowItemId(null);
        if (followPlan.getPlannEndTime() != null && followPlan.getActualEndTime() != null) {
            long spendTime = (followPlan.getActualEndTime().getTime() - followPlan.getPlannEndTime().getTime()) / 86400000L;
            followPlan.setSpendTime(new BigDecimal(spendTime));
        }
        this.followInvorker.getFollowPlanService().addObj(followPlan);
    }

    private void validate(FollowPlan followPlan) {
        Assert.isNotNull(followPlan, "\u8ddf\u8e2a\u8ba1\u5212\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isNotBlank(followPlan.getProductName(), "\u8ddf\u8e2a\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
    }
}

