/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.followplan.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.followplan.dao.FollowPlanMapper;
import com.els.base.followplan.entity.FollowPlan;
import com.els.base.followplan.entity.FollowPlanExample;
import com.els.base.followplan.service.FollowPlanService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultFollowPlanService")
public class FollowPlanServiceImpl
implements FollowPlanService {
    @Resource
    protected FollowPlanMapper followPlanMapper;

    @Override
    public int insertBatch(List<FollowPlan> list) {
        Assert.isNotEmpty(list, "\u8ba1\u5212\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        return this.followPlanMapper.insertBatch(list);
    }

    @Override
    @CacheEvict(value={"followPlan"}, allEntries=true)
    public void addObj(FollowPlan t) {
        this.followPlanMapper.insertSelective(t);
    }

    @Override
    @Transactional
    @CacheEvict(value={"followPlan"}, allEntries=true)
    public void addAll(List<FollowPlan> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.followPlanMapper.insertBatch(list);
    }

    @Override
    @CacheEvict(value={"followPlan"}, allEntries=true)
    public void deleteObjById(String id) {
        this.followPlanMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"followPlan"}, allEntries=true)
    public void deleteByExample(FollowPlanExample example) {
        Assert.isNotNull(example, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), "\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.followPlanMapper.deleteByExample(example);
    }

    @Override
    @CacheEvict(value={"followPlan"}, allEntries=true)
    public void modifyObj(FollowPlan t) {
        Assert.isNotBlank(t.getId(), "id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.followPlanMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"followPlan"}, keyGenerator="redisKeyGenerator")
    public FollowPlan queryObjById(String id) {
        return this.followPlanMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"followPlan"}, keyGenerator="redisKeyGenerator")
    public List<FollowPlan> queryAllObjByExample(FollowPlanExample example) {
        return this.followPlanMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"followPlan"}, keyGenerator="redisKeyGenerator")
    public PageView<FollowPlan> queryObjByPage(FollowPlanExample example) {
        PageView<FollowPlan> pageView = example.getPageView();
        pageView.setQueryResult(this.followPlanMapper.selectByExampleByPage(example));
        return pageView;
    }
}

