/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.followplan.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.followplan.dao.FollowPlanTemplateMapper;
import com.els.base.followplan.entity.FollowPlanTemplate;
import com.els.base.followplan.entity.FollowPlanTemplateExample;
import com.els.base.followplan.service.FollowPlanTemplateService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultFollowPlanTemplateService")
public class FollowPlanTemplateServiceImpl
implements FollowPlanTemplateService {
    @Resource
    protected FollowPlanTemplateMapper followPlanTemplateMapper;

    @Override
    @CacheEvict(value={"followPlanTemplate"}, allEntries=true)
    public void addObj(FollowPlanTemplate t) {
        this.followPlanTemplateMapper.insertSelective(t);
    }

    @Override
    @Transactional
    @CacheEvict(value={"followPlanTemplate"}, allEntries=true)
    public void addAll(List<FollowPlanTemplate> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.followPlanTemplateMapper.insertBatch(list);
    }

    @Override
    @CacheEvict(value={"followPlanTemplate"}, allEntries=true)
    public void deleteObjById(String id) {
        this.followPlanTemplateMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"followPlanTemplate"}, allEntries=true)
    public void deleteByExample(FollowPlanTemplateExample example) {
        Assert.isNotNull(example, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), "\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.followPlanTemplateMapper.deleteByExample(example);
    }

    @Override
    @CacheEvict(value={"followPlanTemplate"}, allEntries=true)
    public void modifyObj(FollowPlanTemplate t) {
        Assert.isNotBlank(t.getId(), "id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.followPlanTemplateMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"followPlanTemplate"}, keyGenerator="redisKeyGenerator")
    public FollowPlanTemplate queryObjById(String id) {
        return this.followPlanTemplateMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"followPlanTemplate"}, keyGenerator="redisKeyGenerator")
    public List<FollowPlanTemplate> queryAllObjByExample(FollowPlanTemplateExample example) {
        return this.followPlanTemplateMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"followPlanTemplate"}, keyGenerator="redisKeyGenerator")
    public PageView<FollowPlanTemplate> queryObjByPage(FollowPlanTemplateExample example) {
        PageView<FollowPlanTemplate> pageView = example.getPageView();
        pageView.setQueryResult(this.followPlanTemplateMapper.selectByExampleByPage(example));
        return pageView;
    }
}

