/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.followplan.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.common.FollowInvorker;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.user.User;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.followplan.command.CreatePlanCommand;
import com.els.base.followplan.entity.FollowPlan;
import com.els.base.followplan.entity.FollowPlanExample;
import com.els.base.followplan.service.FollowPlanService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u8ba2\u5355\u751f\u4ea7\u8ba1\u5212\u8ddf\u8e2a\u8868\u884c")
@Controller
@RequestMapping(value={"followPlan"})
public class FollowPlanController {
    @Resource
    protected FollowPlanService followPlanService;
    @Resource
    private FollowInvorker invoker;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u8ba2\u5355\u751f\u4ea7\u8ba1\u5212\u8ddf\u8e2a\u8868\u884c")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody FollowPlan followPlan) {
        this.followPlanService.addObj(followPlan);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u8ba2\u5355\u751f\u4ea7\u8ba1\u5212\u8ddf\u8e2a\u6a21\u677f")
    @RequestMapping(value={"service/createForTemplate"})
    @ResponseBody
    public ResponseResult<String> createForTemplate(@RequestBody FollowPlan followPlan) {
        CreatePlanCommand createCommand = new CreatePlanCommand(followPlan);
        createCommand.setProject(ProjectUtils.getProject());
        createCommand.setPurCompany(CompanyUtils.getPurCompanyOfCurrentCompany());
        createCommand.setPurUser((User)SpringSecurityUtils.getLoginUser());
        this.invoker.invoke(createCommand);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u8ba2\u5355\u751f\u4ea7\u8ba1\u5212\u8ddf\u8e2a\u8868\u884c")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody FollowPlan followPlan) {
        Assert.isNotBlank(followPlan.getId(), "id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.followPlanService.modifyObj(followPlan);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u8ba2\u5355\u751f\u4ea7\u8ba1\u5212\u8ddf\u8e2a\u8868\u884c")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, "\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        FollowPlanExample example = new FollowPlanExample();
        example.createCriteria().andIdIn((List)ids);
        this.followPlanService.deleteByExample(example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u8ba2\u5355\u751f\u4ea7\u8ba1\u5212\u8ddf\u8e2a\u8868\u884c")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 FollowPlan", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<FollowPlan>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        FollowPlanExample example = new FollowPlanExample();
        example.setPageView(new PageView<FollowPlan>(pageNo, pageSize));
        example.setOrderByClause("SORT_NO ASC,CREATE_TIME DESC");
        FollowPlanExample.Criteria criteria = example.createCriteria();
        criteria.andFollowItemIdIsNotNull().andFollowIdIsNotNull();
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        PageView pageData = this.followPlanService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u8ba2\u5355\u751f\u4ea7\u8ba1\u5212\u8ddf\u8e2a\u8868\u6a21\u677f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 FollowPlan", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findTemplateByPage"})
    @ResponseBody
    public ResponseResult<PageView<FollowPlan>> findTemplateByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        FollowPlanExample example = new FollowPlanExample();
        example.setPageView(new PageView<FollowPlan>(pageNo, pageSize));
        example.setOrderByClause("SORT_NO ASC,CREATE_TIME DESC");
        FollowPlanExample.Criteria criteria = example.createCriteria();
        criteria.andFollowIdIsNull().andFollowItemIdIsNull();
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        PageView pageData = this.followPlanService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u8ba2\u5355\u751f\u4ea7\u8ba1\u5212\u8ddf\u8e2a\u8868\u5168\u90e8\u7684\u6a21\u677f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 FollowPlan", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findAllTemplate"})
    @ResponseBody
    public ResponseResult<List<FollowPlan>> findAllTemplate(@RequestBody(required=false) QueryParamWapper wapper) {
        FollowPlanExample example = new FollowPlanExample();
        example.setOrderByClause("SORT_NO ASC,CREATE_TIME DESC");
        FollowPlanExample.Criteria criteria = example.createCriteria();
        criteria.andFollowIdIsNull().andFollowItemIdIsNull();
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        List pageData = this.followPlanService.queryAllObjByExample(example);
        return ResponseResult.success(pageData);
    }
}

