/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.command.pur;

import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.command.pur.PreviewTargeListCommand;
import com.els.base.inquiry.entity.InquiryWaitMaterial;
import com.els.base.inquiry.entity.PurOrder;
import com.els.base.inquiry.entity.TemplateConf;
import com.els.base.inquiry.enumclass.InquiryOrderStatus;
import com.els.base.inquiry.enumclass.InquiryQuoteStatus;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class PreviewCommand
extends AbstractInquiryCommand<PurOrder> {
    private static final String ORDER_NO_GENERATE_CODE = "INQUIRY_ORDER_CODE";
    private String templateId;
    private List<InquiryWaitMaterial> waitMaterialList;
    private String materialUsesCode;

    public PreviewCommand(String templateId, List<InquiryWaitMaterial> waitMaterialList) {
        Assert.isNotBlank(templateId, "\u6a21\u677f\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a");
        this.templateId = templateId;
        this.waitMaterialList = waitMaterialList;
    }

    public PreviewCommand(String templateId, List<InquiryWaitMaterial> waitMaterialList, String materialUsesCode) {
        Assert.isNotBlank(templateId, "\u6a21\u677f\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a");
        this.templateId = templateId;
        this.waitMaterialList = waitMaterialList;
        this.materialUsesCode = materialUsesCode;
    }

    @Override
    public PurOrder execute(InquiryCommandInvoker invoker) {
        TemplateConf templateConf = (TemplateConf)invoker.getTemplateConfService().queryObjById(this.templateId);
        this.vaild(templateConf);
        PurOrder order = this.generatePurOrder(templateConf);
        if (CollectionUtils.isEmpty(this.waitMaterialList)) {
            return order;
        }
        PreviewTargeListCommand poiCmd = new PreviewTargeListCommand(this.templateId, this.waitMaterialList);
        poiCmd.copyProperties(this);
        order.setTargetList(invoker.invoke(poiCmd));
        return order;
    }

    private void vaild(TemplateConf templateConf) {
        Assert.isNotNull(templateConf, "\u6a21\u677f\u914d\u7f6e\u4e0d\u5b58\u5728");
        if (Constant.YES_INT.equals(templateConf.getIsMouldEnable())) {
            Assert.isNotEmpty(templateConf.getMouldPropertyDefList(), "\u6a21\u677f\u914d\u7f6e\u5f02\u5e38\uff0c\u6a21\u5177\u6e05\u5355\u7684\u5b57\u6bb5\u914d\u7f6e\u4e3a\u7a7a");
        }
        if (Constant.YES_INT.equals(templateConf.getIsBusiCondEnable())) {
            Assert.isNotEmpty(templateConf.getBusiConditionPropertyDefList(), "\u6a21\u677f\u914d\u7f6e\u5f02\u5e38\uff0c\u5546\u52a1\u6761\u4ef6\u7684\u5b57\u6bb5\u914d\u7f6e\u4e3a\u7a7a");
        }
    }

    private PurOrder generatePurOrder(TemplateConf templateConf) {
        PurOrder purOrder = new PurOrder();
        purOrder.setTemplateConf(templateConf);
        purOrder.setTemplateId(templateConf.getId());
        String nextCode = this.invoker.getGenerateCodeService().getNextCode(ORDER_NO_GENERATE_CODE);
        if (StringUtils.isNotBlank((String)this.materialUsesCode)) {
            purOrder.setOrderNo(this.materialUsesCode + nextCode);
            purOrder.setMaterialUsed(this.materialUsesCode);
        } else {
            purOrder.setOrderNo(nextCode);
        }
        purOrder.setType(templateConf.getName());
        purOrder.setTargetName(templateConf.getName());
        purOrder.setInquiryOrderStatus(InquiryOrderStatus.UNPUBLISHED.getCode());
        purOrder.setQuoteStatus(InquiryQuoteStatus.UNQUOTED.getCode());
        purOrder.setIsContainSubItem(templateConf.getIsOrderItemDetailEnable());
        if (this.getPurUser() != null) {
            purOrder.setPurUserName(this.getPurUser().getNickName());
            purOrder.setPurUserId(this.getPurUser().getId());
        }
        return purOrder;
    }
}

