/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.command.pur;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.SyncPriceService;
import com.els.base.inquiry.command.pur.ViewPricingDetailCommand;
import com.els.base.inquiry.entity.OrderItemM001;
import com.els.base.inquiry.entity.PurOrder;
import com.els.base.inquiry.enumclass.OperationTypeEnum;
import com.els.base.utils.SpringContextHolder;

public class SyncPriceToSapCmd
extends AbstractInquiryCommand<String> {
    private String purOrderId;

    public SyncPriceToSapCmd(String purOrderId) {
        this.purOrderId = purOrderId;
    }

    @Override
    public String execute(InquiryCommandInvoker invoker) {
        PurOrder purOrder = invoker.invoke(new ViewPricingDetailCommand(this.purOrderId));
        Assert.isNotNull(purOrder, "\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank(purOrder.getId(), "\u4f20\u5165\u7684\u91c7\u8d2d\u5546\u8868\u5934ID\u4e3a\u7a7a");
        Assert.isNotEmpty(purOrder.getItemList(), "\u4f20\u5165\u7684\u6570\u636e\u4e3a\u7a7a\uff0c\u53cd\u5199sap\u5931\u8d25");
        purOrder.getItemList().stream().filter(orderItem -> OperationTypeEnum.ACCEPTED.getCode().equals(orderItem.getOperation())).forEach(orderItem -> {
            OrderItemM001 data = (OrderItemM001)orderItem;
            SyncPriceService syncPriceService = (SyncPriceService)SpringContextHolder.getOneBean(SyncPriceService.class);
            if (syncPriceService == null) {
                throw new CommonException("\u7cfb\u7edf\u8fd8\u6ca1\u6709\u542f\u52a8\u4ef7\u683c\u56de\u5199\u5230sap\u7684\u914d\u7f6e");
            }
            try {
                syncPriceService.sendData(data);
            }
            catch (Exception e) {
                this.logger.error("\u4f9b\u5e94\u5546\u62a5\u4ef7\u4fe1\u606f\u53cd\u5199SAP\u63a5\u53e3\u8c03\u7528\u5f02\u5e38:", (Throwable)e);
                throw new CommonException("\u4f9b\u5e94\u5546\u62a5\u4ef7\u4fe1\u606f\u53cd\u5199SAP\u63a5\u53e3\u8c03\u7528\u5f02\u5e38:" + e.getMessage());
            }
        });
        return null;
    }
}

