/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.command.sup;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.IMould;
import com.els.base.inquiry.IMouldDetail;
import com.els.base.inquiry.IOrderItem;
import com.els.base.inquiry.IOrderItemDetail;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.command.pur.FrozenOrderCommand;
import com.els.base.inquiry.command.strategy.LadderPriceStrategy;
import com.els.base.inquiry.entity.InquiryBusiCondition;
import com.els.base.inquiry.entity.InquiryQuoteLadder;
import com.els.base.inquiry.entity.InquiryQuoteLadderExample;
import com.els.base.inquiry.entity.InquirySupFile;
import com.els.base.inquiry.entity.InquirySupFileExample;
import com.els.base.inquiry.entity.InquirySupOrder;
import com.els.base.inquiry.entity.PurOrder;
import com.els.base.inquiry.entity.TemplateConf;
import com.els.base.inquiry.enumclass.InquiryFileType;
import com.els.base.inquiry.enumclass.InquiryLadderBelongType;
import com.els.base.inquiry.enumclass.InquiryOrderStatus;
import com.els.base.inquiry.enumclass.InquiryQuoteLadderType;
import com.els.base.inquiry.enumclass.InquiryQuoteStatus;
import com.els.base.inquiry.utils.LaddPriceValider;
import com.els.base.utils.uuid.UUIDGenerator;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class ModifyQuoteCommand
extends AbstractInquiryCommand<String> {
    private InquirySupOrder supOrder;
    private TemplateConf templateConf;

    public ModifyQuoteCommand(InquirySupOrder supOrder) {
        this.supOrder = supOrder;
    }

    @Override
    public String execute(InquiryCommandInvoker invoker) {
        this.valid(this.supOrder);
        this.init(this.supOrder);
        this.modifyOrderItemList(this.supOrder);
        this.modifyQuoteLadder(this.supOrder.getItemList());
        if (Constant.YES_INT.equals(this.templateConf.getIsOrderItemDetailEnable())) {
            this.modifyItemDetail(this.supOrder.getItemList());
        }
        if (Constant.YES_INT.equals(this.templateConf.getIsMouldEnable())) {
            this.modifyMould(this.supOrder);
            if (Constant.YES_INT.equals(this.templateConf.getIsMouldDetailEnable())) {
                this.modifyMouldDetail(this.supOrder.getMouldList());
            }
        }
        this.modifyInquirySupFiles(this.supOrder, this.supOrder.getSupFileList());
        this.modifyInquiryBusiCondition(this.supOrder.getBusiConditions());
        return null;
    }

    private void modifyOrderItemList(InquirySupOrder supOrder) {
        supOrder.getItemList().parallelStream().forEach(supOrderItem -> {
            supOrderItem.setSupOrderId(supOrder.getId());
            supOrderItem.setSupUserId(this.getSupUser().getId());
            supOrderItem.setSupUserName(this.getSupUser().getNickName());
            this.calculateUnTaxedPrice((IOrderItem)supOrderItem, this.supOrder);
        });
        this.templateConf.getOrderItemService().deleteBySupOrderId(supOrder.getId());
        this.templateConf.getOrderItemService().addAll(supOrder.getItemList());
    }

    private BigDecimal calculateUnTaxedPrice(IOrderItem supOrderItem, InquirySupOrder supOrder) {
        if (Constant.YES_INT.equals(this.templateConf.getIsOrderItemDetailEnable()) && supOrderItem.getOrderItemDetail() != null) {
            return supOrderItem.getOrderItemDetail().calculate();
        }
        if (Constant.YES_INT.equals(this.templateConf.getIsLadderPriceEnable()) && CollectionUtils.isNotEmpty(supOrderItem.getInquiryQuoteLadders())) {
            return new LadderPriceStrategy(supOrderItem.getInquiryQuoteLadders()).calculate();
        }
        return supOrderItem.getUntaxedUnitPrice();
    }

    protected void init(InquirySupOrder supOrder) {
        this.templateConf = (TemplateConf)this.invoker.getTemplateConfService().queryObjById(supOrder.getTemplateId());
        supOrder.setSupUserId(this.getSupUser().getId());
        supOrder.setSupUserName(this.getSupUser().getNickName());
    }

    protected void modifyMouldDetail(List<IMould> mouldList) {
        if (CollectionUtils.isEmpty(mouldList)) {
            return;
        }
        List<String> mouldIdList = mouldList.stream().map(IMould::getId).collect(Collectors.toList());
        this.templateConf.getTplMouLdDetail().getMouldDetailService().deleteByMouldIdList(mouldIdList);
        List detailList = mouldList.stream().filter(mould -> mould.getMouldDetail() != null).map(mould -> {
            IMouldDetail mouldDetail = mould.getMouldDetail();
            mouldDetail.setMouldId(mould.getId());
            mouldDetail.setPurOrderId(mould.getPurOrderId());
            mouldDetail.setSupOrderId(mould.getSupOrderId());
            mouldDetail.setSupCompanyId(mould.getSupCompanyId());
            mouldDetail.setSupCompanyName(mould.getSupCompanyName());
            mouldDetail.setSupCompanySapCode(mould.getSupCompanySapCode());
            mouldDetail.setSupCompanySrmCode(mould.getSupCompanySrmCode());
            mouldDetail.setTemplateId(this.templateConf.getTplMouLdDetail().getId());
            return mouldDetail;
        }).collect(Collectors.toList());
        this.templateConf.getTplMouLdDetail().getMouldDetailService().addAll(detailList);
    }

    protected void modifyMould(InquirySupOrder supOrder) {
        this.templateConf.getMouldService().deleteBySupOrder(supOrder.getId());
        supOrder.getMouldList().forEach(newMould -> {
            newMould.setPurOrderId(supOrder.getPurOrderId());
            newMould.setSupOrderId(supOrder.getId());
            newMould.setSupCompanyName(supOrder.getSupCompanyName());
            newMould.setSupCompanySrmCode(supOrder.getSupCompanySrmCode());
            newMould.setSupCompanySapCode(supOrder.getSupCompanySapCode());
        });
        this.templateConf.getMouldService().addAll(supOrder.getMouldList());
    }

    protected void modifyItemDetail(List<IOrderItem> itemList) {
        List detailList = itemList.stream().filter(item -> item.getOrderItemDetail() != null).map(item -> {
            IOrderItemDetail detail = item.getOrderItemDetail();
            detail.setOrderItemId(item.getId());
            detail.setTemplateId(this.templateConf.getTplOrderItemDetail().getId());
            detail.setMaterialCode(item.getMaterialCode());
            return detail;
        }).collect(Collectors.toList());
        List<String> orderItemIdList = itemList.stream().map(IOrderItem::getId).collect(Collectors.toList());
        this.templateConf.getTplOrderItemDetail().getOrderItemDetailService().deleteByOrderItemIds(orderItemIdList);
        this.templateConf.getTplOrderItemDetail().getOrderItemDetailService().addAll(detailList);
    }

    protected void modifyQuoteLadder(List<IOrderItem> itemList) {
        List<InquiryQuoteLadder> ladderList = itemList.stream().filter(item -> CollectionUtils.isNotEmpty(item.getInquiryQuoteLadders())).flatMap(item -> {
            item.getInquiryQuoteLadders().forEach(ladder -> {
                ladder.setItemId(item.getId());
                ladder.setBelongType(InquiryLadderBelongType.BELONG_TO_ITEM.getCode());
                ladder.setCreateCompanyType(StringUtils.defaultIfBlank((String)ladder.getCreateCompanyType(), (String)"SUP"));
            });
            return item.getInquiryQuoteLadders().stream();
        }).collect(Collectors.toList());
        List orderItemIdList = itemList.stream().map(IOrderItem::getId).collect(Collectors.toList());
        InquiryQuoteLadderExample ladderExample = new InquiryQuoteLadderExample();
        ladderExample.createCriteria().andBelongTypeEqualTo(InquiryLadderBelongType.BELONG_TO_ITEM.getCode()).andItemIdIn(orderItemIdList);
        this.invoker.getInquiryQuoteLadderService().deleteByExample(ladderExample);
        this.invoker.getInquiryQuoteLadderService().addAll(ladderList);
    }

    protected void valid(final InquirySupOrder supOrder) {
        Assert.isNotBlank(supOrder.getId(), "\u8be2\u4ef7\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank(supOrder.getPurOrderId(), "\u8be2\u4ef7\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(supOrder.getItemList(), "\u8be2\u4ef7\u5355\u884c\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank(supOrder.getTemplateId(), "\u6a21\u677fid\u4e0d\u80fd\u4e3a\u7a7a");
        if (!InquiryOrderStatus.PUBLISHED.getCode().equals(supOrder.getInquiryOrderStatus())) {
            throw new CommonException("\u8be2\u4ef7\u5355\u4e0d\u662f\u5df2\u53d1\u5e03\u72b6\u6001\uff0c\u4e0d\u80fd\u4fee\u6539");
        }
        if (!InquiryQuoteStatus.UNQUOTED.getCode().equals(supOrder.getQuoteStatus()) && !InquiryQuoteStatus.REQUOTE.getCode().equals(supOrder.getQuoteStatus())) {
            throw new CommonException("\u8be2\u4ef7\u5355\u5df2\u7ecf\u62a5\u4ef7\uff0c\u4e0d\u80fd\u4fee\u6539");
        }
        supOrder.getItemList().stream().filter(item -> StringUtils.isBlank((String)item.getId())).findAny().ifPresent(item -> {
            throw new CommonException("\u8be2\u4ef7\u5355\u884cId\u4e0d\u80fd\u4e3a\u7a7a");
        });
        supOrder.getItemList().stream().filter(item -> !Constant.YES_INT.equals(item.getUnableToQuote())).forEach(item -> {
            if (!InquiryQuoteLadderType.CONVENTIONAL_QUOTE.getCode().equals(item.getQuoteType()) && !InquiryQuoteLadderType.LADDER_QUOTE.getCode().equals(item.getQuoteType())) {
                throw new CommonException("\u62a5\u4ef7\u7c7b\u578b\u65e0\u6cd5\u8bc6\u522b");
            }
            LaddPriceValider.valid(item.getInquiryQuoteLadders());
        });
        PurOrder purOrder = (PurOrder)this.invoker.getPurOrderService().queryObjById(supOrder.getPurOrderId());
        if (purOrder.getQuoteEndDate() != null && System.currentTimeMillis() > purOrder.getQuoteEndDate().getTime()) {
            this.invoker.getThreadPoolTaskExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    ModifyQuoteCommand.this.invoker.invoke(new FrozenOrderCommand(supOrder.getPurOrderId()));
                }
            });
            throw new CommonException("\u8be5\u8be2\u4ef7\u5355\u5df2\u7ecf\u622a\u6b62\u62a5\u4ef7");
        }
    }

    protected void modifyInquiryBusiCondition(List<InquiryBusiCondition> busiConditions) {
        if (CollectionUtils.isEmpty(busiConditions)) {
            return;
        }
        if (busiConditions.size() != 1) {
            throw new CommonException("\u5546\u52a1\u6761\u4ef6\u5b58\u5728\u591a\u4e2a\u5546\u52a1\u6761\u4ef6");
        }
        InquiryBusiCondition busiCondition = busiConditions.get(0);
        busiCondition.setSupUserId(this.getSupUser().getId());
        busiCondition.setSupUserName(this.getSupUser().getLoginName());
        busiCondition.setSupCompanySrmCode(this.getSupCompany().getCompanyCode());
        busiCondition.setSupCompanySapCode(this.getSupCompany().getCompanySapCode());
        this.invoker.getInquiryBusiConditionService().modifyObj(busiCondition);
    }

    protected void modifyInquirySupFiles(InquirySupOrder supOrder, List<InquirySupFile> inquirySupFiles) {
        this.deleteSurFilesBySupOrderId(supOrder.getId());
        if (CollectionUtils.isEmpty(inquirySupFiles)) {
            return;
        }
        inquirySupFiles.forEach(inquirySupFile -> {
            inquirySupFile.setId(UUIDGenerator.generateUUID());
            inquirySupFile.setType(InquiryFileType.PUBLIC.getCode());
            inquirySupFile.setSupOrderId(supOrder.getId());
            inquirySupFile.setPurOrderId(supOrder.getPurOrderId());
            inquirySupFile.setSupCompanyId(this.getSupCompany().getId());
            inquirySupFile.setSupCompanyName(this.getSupCompany().getCompanyName());
            inquirySupFile.setSupUserId(this.getSupUser().getId());
            inquirySupFile.setSupUserName(this.getSupUser().getLoginName());
            this.invoker.getInquirySupFileService().addObj(inquirySupFile);
        });
    }

    private void deleteSurFilesBySupOrderId(String supOrderId) {
        InquirySupFileExample example = new InquirySupFileExample();
        InquirySupFileExample.Criteria criteria = example.createCriteria();
        criteria.andSupOrderIdEqualTo(supOrderId);
        this.invoker.getInquirySupFileService().deleteByExample(example);
    }
}

