/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.command.sup;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.IOrderItem;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.command.pur.FrozenOrderCommand;
import com.els.base.inquiry.entity.InquiryQuoteLadder;
import com.els.base.inquiry.entity.InquirySupOrder;
import com.els.base.inquiry.entity.PurOrder;
import com.els.base.inquiry.entity.TemplateConf;
import com.els.base.inquiry.enumclass.InquiryQuoteLadderType;
import com.els.base.inquiry.enumclass.InquiryQuoteStatus;
import com.els.base.inquiry.enumclass.MessageNotify;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class PublishQuoteCommand
extends AbstractInquiryCommand<String> {
    private InquirySupOrder preSupOrder;
    private InquirySupOrder supOrder;
    private TemplateConf templateConf;

    public PublishQuoteCommand(InquirySupOrder supOrder) {
        this.supOrder = supOrder;
    }

    @Override
    public String execute(InquiryCommandInvoker invoker) {
        this.valid(this.supOrder);
        this.publish(this.supOrder);
        this.sendMsg(this.supOrder);
        return null;
    }

    private void sendMsg(InquirySupOrder order) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("purOrderId", order.getPurOrderId());
        data.put("orderNo", order.getOrderNo());
        data.put("supCompanyName", order.getSupCompanyName());
        Message msg = Message.init(data).setCompanyCode(this.getSupCompany().getCompanyCode()).setBusinessTypeCode(MessageNotify.INQUIRY_ORDER_QUOTE.getCode()).setSenderId(this.getSupUser().getId()).addReceiverId(order.getPurUserId()).setMsgLevel(MessageLevelEnum.HIGH);
        MessageSendUtils.sendMessage((Message)msg);
    }

    private void publish(InquirySupOrder order) {
        this.transformItemQuoteStatus(order);
        this.transformSupOrderQuoteStatus(order);
        this.transformPurOrderQuoteStatus(order);
    }

    private void transformPurOrderQuoteStatus(InquirySupOrder order) {
        PurOrder temp = new PurOrder();
        temp.setId(order.getPurOrderId());
        temp.setQuoteStatus(this.getPurOrderQuoteStatus(order.getPurOrderId()));
        this.invoker.getPurOrderService().modifyObj(temp);
    }

    private Integer getPurOrderQuoteStatus(String purOrderId) {
        Long countByRequote;
        Long countByRequoted;
        List<IOrderItem> orderItemList = this.templateConf.getOrderItemService().queryByPurOrderId(purOrderId);
        if (CollectionUtils.isEmpty(orderItemList)) {
            throw new CommonException("\u8be2\u4ef7\u5355\u884c\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5");
        }
        Map<Integer, Long> statusCount = orderItemList.stream().filter(orderItem -> orderItem.getQuotationStatus() != null).collect(Collectors.groupingBy(IOrderItem::getQuotationStatus, Collectors.counting()));
        Long countByQuoted = statusCount.get(InquiryQuoteStatus.QUOTED.getCode());
        if (countByQuoted == null) {
            countByQuoted = 0L;
        }
        if ((countByRequoted = statusCount.get(InquiryQuoteStatus.REQUOTED.getCode())) == null) {
            countByRequoted = 0L;
        }
        if ((countByRequote = statusCount.get(InquiryQuoteStatus.REQUOTE.getCode())) == null) {
            countByRequote = 0L;
        }
        if (countByQuoted + countByRequoted == (long)orderItemList.size()) {
            return InquiryQuoteStatus.QUOTED.getCode();
        }
        if (countByRequote > 0L) {
            return InquiryQuoteStatus.REQUOTE.getCode();
        }
        return InquiryQuoteStatus.QUOTE_SECTION.getCode();
    }

    private void transformItemQuoteStatus(InquirySupOrder order) {
        List<IOrderItem> orderItems = order.getItemList();
        orderItems.stream().filter(orderItem -> InquiryQuoteStatus.UNQUOTED.getCode().equals(orderItem.getQuotationStatus()) || InquiryQuoteStatus.REQUOTE.getCode().equals(orderItem.getQuotationStatus())).forEach(orderItem -> {
            if (InquiryQuoteStatus.UNQUOTED.getCode().equals(orderItem.getQuotationStatus())) {
                orderItem.setQuotationStatus(InquiryQuoteStatus.QUOTED.getCode());
            }
            if (InquiryQuoteStatus.REQUOTE.getCode().equals(orderItem.getQuotationStatus())) {
                orderItem.setQuotationStatus(InquiryQuoteStatus.REQUOTED.getCode());
            }
            orderItem.setQuoteTime(new Date());
            this.templateConf.getOrderItemService().modifyStatus((IOrderItem)orderItem);
        });
    }

    private void transformSupOrderQuoteStatus(InquirySupOrder order) {
        InquirySupOrder temp = new InquirySupOrder();
        temp.setId(order.getId());
        if (InquiryQuoteStatus.UNQUOTED.getCode().equals(order.getQuoteStatus())) {
            temp.setQuoteStatus(InquiryQuoteStatus.QUOTED.getCode());
        }
        if (InquiryQuoteStatus.REQUOTE.getCode().equals(order.getQuoteStatus())) {
            boolean isExistRequote = order.getItemList().stream().anyMatch(item -> InquiryQuoteStatus.REQUOTE.getCode().equals(item.getQuotationStatus()));
            if (isExistRequote) {
                temp.setQuoteStatus(InquiryQuoteStatus.REQUOTE.getCode());
            } else {
                temp.setQuoteStatus(InquiryQuoteStatus.QUOTED.getCode());
            }
        }
        temp.setSupUserId(this.getSupUser().getId());
        temp.setSupUserName(this.getSupUser().getNickName());
        temp.setQuoteTime(new Date());
        this.invoker.getInquirySupOrderService().modifyObj(temp);
    }

    private void valid(InquirySupOrder order) {
        this.templateConf = (TemplateConf)this.invoker.getTemplateConfService().queryObjById(this.supOrder.getTemplateId());
        this.preSupOrder = (InquirySupOrder)this.invoker.getInquirySupOrderService().queryObjById(this.supOrder.getId());
        if (!InquiryQuoteStatus.UNQUOTED.getCode().equals(this.preSupOrder.getQuoteStatus()) && !InquiryQuoteStatus.REQUOTE.getCode().equals(this.preSupOrder.getQuoteStatus())) {
            throw new CommonException("\u53ea\u6709\u5904\u4e8e\u672a\u62a5\u4ef7\u6216\u91cd\u62a5\u4ef7\u72b6\u6001\u4e0b\u7684\u8be2\u4ef7\u5355\u624d\u5141\u8bb8\u53d1\u5e03\u62a5\u4ef7");
        }
        PurOrder purOrder = (PurOrder)this.invoker.getPurOrderService().queryObjById(this.supOrder.getPurOrderId());
        if (purOrder.getQuoteEndDate() != null && System.currentTimeMillis() > purOrder.getQuoteEndDate().getTime()) {
            this.invoker.getThreadPoolTaskExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    PublishQuoteCommand.this.invoker.invoke(new FrozenOrderCommand(PublishQuoteCommand.this.supOrder.getPurOrderId()));
                }
            });
            throw new CommonException("\u8be5\u8be2\u4ef7\u5355\u5df2\u7ecf\u622a\u6b62\u62a5\u4ef7");
        }
        List<IOrderItem> orderItems = order.getItemList();
        orderItems.stream().filter(orderItem -> {
            if (Constant.YES_INT.equals(orderItem.getUnableToQuote())) {
                return false;
            }
            return !InquiryQuoteStatus.QUOTED.getCode().equals(orderItem.getQuotationStatus()) && !InquiryQuoteStatus.REQUOTED.getCode().equals(orderItem.getQuotationStatus());
        }).forEach(orderItem -> {
            if (!InquiryQuoteLadderType.CONVENTIONAL_QUOTE.getCode().equals(orderItem.getQuoteType()) && !InquiryQuoteLadderType.LADDER_QUOTE.getCode().equals(orderItem.getQuoteType())) {
                throw new CommonException("\u62a5\u4ef7\u7c7b\u578b\u65e0\u6cd5\u8bc6\u522b");
            }
            if (orderItem.getPlanDeliveryDate() == null) {
                throw new CommonException("\u8ba1\u5212\u4ea4\u8d27\u65f6\u95f4\u5fc5\u586b");
            }
            if (InquiryQuoteLadderType.CONVENTIONAL_QUOTE.getCode().equals(orderItem.getQuoteType()) && (orderItem.getUntaxedUnitPrice() == null || BigDecimal.ZERO.compareTo(orderItem.getUntaxedUnitPrice()) == 0)) {
                throw new CommonException(String.format("\u8be2\u4ef7\u5355\u5c1a\u672a\u62a5\u4ef7\uff0c\u65e0\u6cd5\u53d1\u5e03\uff01\u8bf7\u68c0\u67e5\u7269\u6599\u7f16\u7801[%s]\u3002", orderItem.getMaterialCode()));
            }
            if (InquiryQuoteLadderType.LADDER_QUOTE.getCode().equals(orderItem.getQuoteType()) && CollectionUtils.isEmpty(orderItem.getInquiryQuoteLadders())) {
                throw new CommonException(String.format("\u8be2\u4ef7\u5355\u5c1a\u672a\u62a5\u4ef7\uff0c\u65e0\u6cd5\u53d1\u5e03\uff01\u8bf7\u68c0\u67e5\u7269\u6599\u7f16\u7801[%s]\u3002", orderItem.getMaterialCode()));
            }
            if (InquiryQuoteLadderType.LADDER_QUOTE.getCode().equals(orderItem.getQuoteType()) && !CollectionUtils.isEmpty(orderItem.getInquiryQuoteLadders())) {
                this.validLadderPrice((IOrderItem)orderItem);
            }
            orderItem.isVaildForQuote();
        });
        if (Constant.YES_INT.equals(this.templateConf.getIsBusiCondEnable())) {
            Assert.isNotEmpty(order.getBusiConditions(), "\u5546\u52a1\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
            order.getBusiConditions().forEach(busiCondition -> busiCondition.isVaildForQuote());
        }
        if (Constant.YES_INT.equals(this.templateConf.getIsMouldEnable()) && CollectionUtils.isNotEmpty(order.getMouldList())) {
            order.getMouldList().forEach(mould -> {
                Assert.isNotBlank(mould.getMouldName(), "\u6a21\u5177\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                if (Constant.YES_INT.equals(this.templateConf.getIsMouldDetailEnable())) {
                    Assert.isNotNull(mould.getMouldDetail(), String.format("\u6a21\u5177[%s]\u6210\u672c\u6e05\u5355\u4e0d\u80fd\u4e3a\u7a7a", mould.getMouldName()));
                }
            });
        }
    }

    private void validLadderPrice(IOrderItem orderItem) {
        for (InquiryQuoteLadder ladderPrice : orderItem.getInquiryQuoteLadders()) {
            Assert.isNotNull(ladderPrice.getUntaxedUnitPrice(), "\u9636\u68af\u62a5\u4ef7\uff0c\u4ef7\u683c\u4e0d\u80fd\u4e3a\u7a7a");
            if (ladderPrice.getUntaxedUnitPrice().compareTo(BigDecimal.ZERO) > 0) continue;
            throw new CommonException(String.format("\u8be2\u4ef7\u5355\u5c1a\u672a\u62a5\u4ef7\u5b8c\u6210\uff0c\u65e0\u6cd5\u53d1\u5e03\uff01\u8bf7\u68c0\u67e5\u7269\u6599\u7f16\u7801 [%s] \u7684\u9636\u68af\u4ef7", orderItem.getMaterialCode()));
        }
    }
}

