/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.inquiry.ITarget;
import com.els.base.inquiry.dao.InquiryWaitMaterialMapper;
import com.els.base.inquiry.entity.InquiryWaitMaterial;
import com.els.base.inquiry.entity.InquiryWaitMaterialExample;
import com.els.base.inquiry.entity.TemplateConf;
import com.els.base.inquiry.service.InquiryWaitMaterialService;
import com.els.base.inquiry.service.TemplateConfService;
import com.els.base.inquiry.web.vo.WaitMaterialTransformVo;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultInquiryWaitMaterialService")
public class InquiryWaitMaterialServiceImpl
implements InquiryWaitMaterialService {
    @Resource
    protected InquiryWaitMaterialMapper inquiryWaitMaterialMapper;
    @Resource
    private TemplateConfService templateConfService;

    @Override
    @CacheEvict(value={"inquiryWaitMaterial"}, allEntries=true)
    public void addObj(InquiryWaitMaterial t) {
        this.inquiryWaitMaterialMapper.insertSelective(t);
    }

    @Override
    @CacheEvict(value={"inquiryWaitMaterial"}, allEntries=true)
    public void deleteObjById(String id) {
        this.inquiryWaitMaterialMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"inquiryWaitMaterial"}, allEntries=true)
    public void modifyObj(InquiryWaitMaterial t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.inquiryWaitMaterialMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"inquiryWaitMaterial"}, keyGenerator="redisKeyGenerator")
    public InquiryWaitMaterial queryObjById(String id) {
        return this.inquiryWaitMaterialMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"inquiryWaitMaterial"}, keyGenerator="redisKeyGenerator")
    public List<InquiryWaitMaterial> queryAllObjByExample(InquiryWaitMaterialExample example) {
        return this.inquiryWaitMaterialMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"inquiryWaitMaterial"}, keyGenerator="redisKeyGenerator")
    public PageView<InquiryWaitMaterial> queryObjByPage(InquiryWaitMaterialExample example) {
        PageView<InquiryWaitMaterial> pageView = example.getPageView();
        pageView.setQueryResult(this.inquiryWaitMaterialMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    public List<ITarget> transformToPurOrderMaterial(WaitMaterialTransformVo waitMaterialTransformVo) {
        ArrayList<ITarget> targets = null;
        if (waitMaterialTransformVo != null && StringUtils.isNotBlank((String)waitMaterialTransformVo.getTemplateId()) && CollectionUtils.isNotEmpty(waitMaterialTransformVo.getInquiryWaitMaterials())) {
            TemplateConf templateConf = (TemplateConf)this.templateConfService.queryObjById(waitMaterialTransformVo.getTemplateId());
            String className = templateConf.getTargetClassName();
            targets = new ArrayList<ITarget>();
            try {
                Class<?> clazz = Class.forName(className);
                for (InquiryWaitMaterial inquiryWaitMaterial : waitMaterialTransformVo.getInquiryWaitMaterials()) {
                    ITarget target = (ITarget)clazz.newInstance();
                    target.buildFromWaitMaterial(waitMaterialTransformVo.getTemplateId(), inquiryWaitMaterial);
                    targets.add(target);
                }
            }
            catch (ClassNotFoundException e) {
                throw new CommonException(String.format("\u8f6c\u6210\u8be2\u4ef7\u5355\u7269\u6599\u51fa\u9519,\u4e0d\u5b58\u5728\u7c7b[%s]", className), e);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new CommonException("\u5f85\u8be2\u4ef7\u6e05\u5355\u8f6c\u6210\u8be2\u4ef7\u5355\u7269\u6599\u5931\u8d25");
            }
        }
        return targets;
    }

    @Override
    @CacheEvict(value={"inquiryWaitMaterial"}, allEntries=true)
    public void modifyByExample(InquiryWaitMaterial waitMaterial, InquiryWaitMaterialExample example) {
        this.inquiryWaitMaterialMapper.updateByExampleSelective(waitMaterial, example);
    }

    @Override
    @CacheEvict(value={"inquiryWaitMaterial"}, allEntries=true)
    @Transactional
    public void batchInsertWaitMaterial(List<InquiryWaitMaterial> waitMaterials) {
        if (CollectionUtils.isNotEmpty(waitMaterials)) {
            Date now = new Date();
            waitMaterials.forEach(waitMaterial -> {
                waitMaterial.setId(UUIDGenerator.generateUUID());
                waitMaterial.setIsCreateInquiryOrder(Constant.NO_INT);
                waitMaterial.setCreateTime(now);
            });
            this.inquiryWaitMaterialMapper.insertBatch(waitMaterials);
        }
    }
}

