/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.utils;

import com.els.base.core.exception.CommonException;
import com.els.base.inquiry.entity.InquiryQuoteLadder;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class LaddPriceValider {
    private LaddPriceValider() {
    }

    public static void valid(List<InquiryQuoteLadder> inquiryQuoteLadders) {
        if (CollectionUtils.isEmpty(inquiryQuoteLadders)) {
            return;
        }
        inquiryQuoteLadders.sort((l1, l2) -> l1.getNumberFrom().compareTo(l2.getNumberFrom()));
        inquiryQuoteLadders.stream().reduce((result, l1) -> {
            if (result == null) {
                return l1;
            }
            if (l1.getNumberFrom().compareTo(result.getNumberTo()) != 0) {
                throw new CommonException(String.format("\u9636\u68af\u8bbe\u7f6e\u5f02\u5e38\uff1a[%s] - [%s],  [%s] - [%s]", result.getNumberFrom(), result.getNumberTo(), l1.getNumberFrom(), l1.getNumberTo()));
            }
            if (l1.getNumberFrom().compareTo(result.getNumberTo()) != 0) {
                throw new CommonException(String.format("\u9636\u68af\u8bbe\u7f6e\u5f02\u5e38\uff1a[%s] - [%s],  [%s] - [%s]", result.getNumberFrom(), result.getNumberTo(), l1.getNumberFrom(), l1.getNumberTo()));
            }
            return l1;
        });
    }
}

