/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.utils;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.inquiry.IBusiCondition;
import com.els.base.inquiry.IMould;
import com.els.base.inquiry.IMouldDetail;
import com.els.base.inquiry.IOrderItem;
import com.els.base.inquiry.IOrderItemDetail;
import com.els.base.inquiry.entity.PropertyDef;
import com.els.base.inquiry.entity.TemplateConf;
import com.els.base.inquiry.entity.TplMouldDetail;
import com.els.base.inquiry.entity.TplOrderItemDetail;
import com.els.base.inquiry.enumclass.PropertyDefTplType;
import com.els.base.inquiry.enumclass.ReadWriteTypeEnum;
import com.els.base.inquiry.service.PropertyDefService;
import com.els.base.utils.SpringContextHolder;
import io.swagger.annotations.ApiModelProperty;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public abstract class PropertyDefUtils {
    private static Map<String, List<PropertyDef>> map = new HashMap<String, List<PropertyDef>>();

    /*
     * WARNING - void declaration
     */
    public static List<PropertyDef> getProperyDefByClass(Class clazz) {
        void var6_9;
        String name = clazz.getSimpleName();
        if (map.get(name) != null) {
            return map.get(name);
        }
        ArrayList<Field> fieldsList = new ArrayList<Field>();
        fieldsList.addAll(Arrays.asList(clazz.getDeclaredFields()));
        ArrayList<Field> supFieldList = new ArrayList<Field>();
        supFieldList.addAll(Arrays.asList(clazz.getSuperclass().getDeclaredFields()));
        ArrayList<Field> removedList = new ArrayList<Field>();
        for (Field field : supFieldList) {
            for (Field field2 : fieldsList) {
                if (!field2.getName().equals(field.getName()) || !field2.getType().equals(field.getType())) continue;
                removedList.add(field);
            }
        }
        supFieldList.removeAll(removedList);
        fieldsList.addAll(supFieldList);
        ArrayList<PropertyDef> itemPropertyDefs = new ArrayList<PropertyDef>();
        for (Field field : fieldsList) {
            ApiModelProperty annotation = field.getAnnotation(ApiModelProperty.class);
            if (annotation == null || annotation.hidden()) continue;
            PropertyDef propertyDef = new PropertyDef();
            propertyDef.setName(StringUtils.defaultIfBlank((String)annotation.value(), (String)annotation.name()));
            propertyDef.setCode(field.getName());
            propertyDef.setWriteType(ReadWriteTypeEnum.BOTH_TYPE.getCode());
            propertyDef.setReadType(ReadWriteTypeEnum.BOTH_TYPE.getCode());
            propertyDef.setIsPrimitive(Constant.YES_INT);
            propertyDef.setSortNo(annotation.position());
            if (StringUtils.isNotBlank((String)annotation.dataType())) {
                propertyDef.setType(annotation.dataType());
            } else {
                propertyDef.setType(PropertyDefUtils.getType(field.getType()));
            }
            if (StringUtils.isNotBlank((String)annotation.notes())) {
                propertyDef.setDicGroupCode(annotation.notes());
            }
            if (propertyDef.getName().contains("%") && "number".equals(propertyDef.getType())) {
                propertyDef.setLength(2);
            }
            itemPropertyDefs.add(propertyDef);
        }
        itemPropertyDefs.sort(Comparator.comparing(PropertyDef::getSortNo));
        boolean bl = false;
        while (var6_9 < itemPropertyDefs.size()) {
            ((PropertyDef)itemPropertyDefs.get((int)var6_9)).setSortNo((int)(var6_9 + true));
            ++var6_9;
        }
        map.put(name, itemPropertyDefs);
        return itemPropertyDefs;
    }

    public static String getType(Class<?> clazz) {
        String typeName;
        switch (typeName = clazz.getSimpleName().toLowerCase()) {
            case "integer": 
            case "long": 
            case "short": {
                return "int";
            }
            case "double": 
            case "float": 
            case "bigdecimal": {
                return "number";
            }
        }
        return typeName;
    }

    public static List<PropertyDef> merge(Class clazz, List<PropertyDef> propertyDefList) {
        List newPropertyDef = PropertyDefUtils.getProperyDefByClass(clazz).stream().filter(classPropertyDef -> propertyDefList.stream().noneMatch(propertyDef -> classPropertyDef.getCode().equals(propertyDef.getCode()))).collect(Collectors.toList());
        propertyDefList.addAll(newPropertyDef);
        return propertyDefList;
    }

    public static List<PropertyDef> queryOrderItemProDef(TemplateConf templateConf) {
        Assert.isNotBlank(templateConf.getId(), "templateConf id \u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull(templateConf.getOrderItemClass(), "getOrderItemClass \u4e0d\u80fd\u4e3a\u7a7a");
        PropertyDefService propertyDefService = (PropertyDefService)SpringContextHolder.getOneBean(PropertyDefService.class);
        List<PropertyDef> orderItemPropertyDefList = propertyDefService.queryPropertyDefList(templateConf.getId(), PropertyDefTplType.ORDER_ITEM.getCode());
        Class<? extends IOrderItem> orderItemClass = templateConf.getOrderItemClass();
        return PropertyDefUtils.merge(orderItemClass, orderItemPropertyDefList);
    }

    public static List<PropertyDef> queryMouldProDef(TemplateConf templateConf) {
        Assert.isNotBlank(templateConf.getId(), "templateConf id \u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull(templateConf.getMouldClass(), "getMouldClass \u4e0d\u80fd\u4e3a\u7a7a");
        PropertyDefService propertyDefService = (PropertyDefService)SpringContextHolder.getOneBean(PropertyDefService.class);
        List<PropertyDef> orderItemPropertyDefList = propertyDefService.queryPropertyDefList(templateConf.getId(), PropertyDefTplType.MOULD_TYPE.getCode());
        Class<? extends IMould> orderItemClass = templateConf.getMouldClass();
        return PropertyDefUtils.merge(orderItemClass, orderItemPropertyDefList);
    }

    public static List<PropertyDef> queryBusiConditionProDef(TemplateConf templateConf) {
        Assert.isNotBlank(templateConf.getId(), "templateConf id \u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull(templateConf.getBusiConditionClass(), "getBusiConditionClass \u4e0d\u80fd\u4e3a\u7a7a");
        PropertyDefService propertyDefService = (PropertyDefService)SpringContextHolder.getOneBean(PropertyDefService.class);
        List<PropertyDef> orderItemPropertyDefList = propertyDefService.queryPropertyDefList(templateConf.getId(), PropertyDefTplType.BUSI_TYPE.getCode());
        Class<? extends IBusiCondition> busiCoditionCls = templateConf.getBusiConditionClass();
        return PropertyDefUtils.merge(busiCoditionCls, orderItemPropertyDefList);
    }

    public static List<PropertyDef> queryOrderItemDetailProDef(TplOrderItemDetail tplOrderItemDetail) {
        Assert.isNotBlank(tplOrderItemDetail.getId(), "templateConf id \u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull(tplOrderItemDetail.getOrderItemDetailClass(), "getOrderItemDetailClass \u4e0d\u80fd\u4e3a\u7a7a");
        PropertyDefService propertyDefService = (PropertyDefService)SpringContextHolder.getOneBean(PropertyDefService.class);
        List<PropertyDef> orderItemPropertyDefList = propertyDefService.queryPropertyDefList(tplOrderItemDetail.getId(), PropertyDefTplType.ORDER_DETAIL_TYPE.getCode());
        Class<? extends IOrderItemDetail> orderItemClass = tplOrderItemDetail.getOrderItemDetailClass();
        return PropertyDefUtils.merge(orderItemClass, orderItemPropertyDefList);
    }

    public static List<PropertyDef> queryMouldDetailProDef(TplMouldDetail tplMouldDetail) {
        Assert.isNotBlank(tplMouldDetail.getId(), "templateConf id \u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull(tplMouldDetail.getMouldDetailClass(), " getMouldDetailClass \u4e0d\u80fd\u4e3a\u7a7a");
        PropertyDefService propertyDefService = (PropertyDefService)SpringContextHolder.getOneBean(PropertyDefService.class);
        List<PropertyDef> orderItemPropertyDefList = propertyDefService.queryPropertyDefList(tplMouldDetail.getId(), PropertyDefTplType.MOULD_DETAIL_TYPE.getCode());
        Class<? extends IMouldDetail> orderItemClass = tplMouldDetail.getMouldDetailClass();
        return PropertyDefUtils.merge(orderItemClass, orderItemPropertyDefList);
    }

    public static void valid(List<PropertyDef> propertyDefList) {
        if (CollectionUtils.isEmpty(propertyDefList)) {
            return;
        }
        propertyDefList.stream().forEach(t -> {
            Assert.isNotBlank(t.getCode(), "\u5b57\u6bb5\u7684\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotBlank(t.getName(), "\u5b57\u6bb5\u7684\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            if (!t.getCode().matches("[\\w_-]+")) {
                throw new CommonException("\u9879\u76ee\u4ee3\u7801\u53ea\u80fd\u4f7f\u7528\u82f1\u6587\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\u3001\u6a2a\u7ebf");
            }
            if (t.getCode().length() > 32) {
                throw new CommonException("\u9879\u76ee\u4ee3\u7801\u6700\u591a\u53ea\u652f\u630132\u4e2a\u5b57\u7b26");
            }
        });
        Map<String, Long> codeAndProDefList = propertyDefList.stream().collect(Collectors.groupingBy(PropertyDef::getCode, Collectors.counting()));
        codeAndProDefList.entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).findAny().ifPresent(entry -> {
            String errMsg = String.format("\u9879\u76ee\u4ee3\u7801[%s]\u91cd\u590d\u4e86", entry.getKey());
            throw new CommonException(errMsg);
        });
    }
}

