/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.utils.json;

import com.els.base.core.exception.CommonException;
import com.els.base.inquiry.IExtendable;
import com.els.base.inquiry.entity.PropertyValue;
import com.els.base.inquiry.utils.ClassReflectionUtils;
import com.els.base.inquiry.utils.PropertyValueUtils;
import com.els.base.utils.json.JsonUtils;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class DetailDeSerializer<T extends IExtendable> {
    private Class<T> instanceClass;

    public DetailDeSerializer(Class<T> instanceClass) {
        this.instanceClass = instanceClass;
    }

    public Class<T> getInstanceClass() {
        return this.instanceClass;
    }

    public T serializer(String itemDetailJson) throws JsonParseException, JsonMappingException, IOException, InstantiationException, IllegalAccessException {
        List propertyValueList = (List)JsonUtils.convertCollection((String)itemDetailJson, List.class, null, (Class[])new Class[]{PropertyValue.class});
        if (CollectionUtils.isEmpty((Collection)propertyValueList)) {
            return null;
        }
        return this.transform(propertyValueList);
    }

    public T transform(List<PropertyValue> propertyValueList) throws InstantiationException, IllegalAccessException {
        IExtendable instance = (IExtendable)this.getInstanceClass().newInstance();
        propertyValueList = propertyValueList.parallelStream().filter(propertyValue -> propertyValue != null && StringUtils.isNotBlank((String)propertyValue.getCode())).collect(Collectors.toList());
        this.setItemDetailPrimitiveField(instance, propertyValueList);
        this.setItemDetailPropertValue(instance, propertyValueList);
        return (T)instance;
    }

    private void setItemDetailPrimitiveField(T instance, List<PropertyValue> propertyValueList) {
        List<Field> primitiveField = ClassReflectionUtils.getPrimitiveField(this.getInstanceClass());
        primitiveField.stream().filter(tempField -> this.isExistInProValueList(propertyValueList, tempField.getName())).forEach(tempField -> {
            PropertyValue value = this.findProValueByCode(propertyValueList, tempField.getName());
            try {
                PropertyValueUtils.setValueToInstance(instance, tempField, value.getValueStr());
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new CommonException("\u53cd\u5e8f\u5217\u5316\u5f02\u5e38", e);
            }
        });
    }

    private void setItemDetailPropertValue(T instance, List<PropertyValue> propertyValueList) {
        List<Field> primitiveField = ClassReflectionUtils.getPrimitiveField(this.getInstanceClass());
        propertyValueList = propertyValueList.parallelStream().filter(propertValue -> primitiveField.stream().noneMatch(field -> field.getName().equals(propertValue.getCode()))).collect(Collectors.toList());
        propertyValueList.forEach(propertyValue -> {
            propertyValue.setId(null);
            PropertyValueUtils.validStr(propertyValue.getValueStr(), propertyValue.getType(), propertyValue.getCode());
        });
        instance.setPropertyValueList(propertyValueList);
    }

    private PropertyValue findProValueByCode(List<PropertyValue> propertyValueList, String code) {
        Optional<PropertyValue> propertyValueOpl = propertyValueList.parallelStream().filter(tempProValue -> code.equals(tempProValue.getCode())).findAny();
        if (propertyValueOpl.isPresent()) {
            return propertyValueOpl.get();
        }
        return null;
    }

    private boolean isExistInProValueList(List<PropertyValue> propertyValueList, String name) {
        return this.findProValueByCode(propertyValueList, name) != null;
    }
}

