/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.material.service.impl;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.project.Project;
import com.els.base.core.entity.user.User;
import com.els.base.core.entity.user.UserExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.user.UserService;
import com.els.base.core.utils.Constant;
import com.els.base.material.dao.MaterialCategoryManagerMapper;
import com.els.base.material.entity.Material;
import com.els.base.material.entity.MaterialCategory;
import com.els.base.material.entity.MaterialCategoryExample;
import com.els.base.material.entity.MaterialCategoryManager;
import com.els.base.material.entity.MaterialCategoryManagerExample;
import com.els.base.material.entity.MaterialExample;
import com.els.base.material.service.MaterialCategoryManagerService;
import com.els.base.material.service.MaterialCategoryService;
import com.els.base.material.service.MaterialService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="defaultMaterialCategoryManagerService")
public class MaterialCategoryManagerServiceImpl
implements MaterialCategoryManagerService {
    @Resource
    protected MaterialCategoryManagerMapper materialCategoryManagerMapper;
    @Resource
    protected MaterialCategoryService materialCategoryService;
    @Resource
    protected UserService userService;
    @Autowired
    private MaterialService materialService;

    @Override
    @CacheEvict(value={"materialCategoryManager"}, allEntries=true)
    public void addObj(MaterialCategoryManager t) {
        this.materialCategoryManagerMapper.insertSelective(t);
    }

    @Override
    @CacheEvict(value={"materialCategoryManager"}, allEntries=true)
    public void addObj(Project project, Company company, MaterialCategoryManager t) {
        System.out.println("materialCategoryExample");
        MaterialCategoryManagerExample example = new MaterialCategoryManagerExample();
        example.createCriteria().andUserIdEqualTo(t.getUserId()).andCategoryIdEqualTo(t.getCategoryId());
        List<MaterialCategoryManager> listMcM = this.materialCategoryManagerMapper.selectByExample(example);
        if (CollectionUtils.isNotEmpty(listMcM)) {
            throw new CommonException("\u5f53\u524d\u5206\u7c7b\u4e0b\u5df2\u7ecf\u5b58\u5728\u6b64\u7528\u6237\uff0c\u65e0\u6cd5\u91cd\u590d\u6dfb\u52a0");
        }
        MaterialCategoryExample materialCategoryExample = new MaterialCategoryExample();
        MaterialCategoryExample.Criteria criteria = materialCategoryExample.createCriteria();
        criteria.andIdEqualTo(t.getCategoryId());
        System.out.println("ExistMaterialCategory");
        MaterialCategory ExistMaterialCategory = (MaterialCategory)this.materialCategoryService.queryAllObjByExample(materialCategoryExample).get(0);
        t.setCategoryName(ExistMaterialCategory.getCategoryName());
        t.setCategoryCode(ExistMaterialCategory.getCategoryCode());
        System.out.println("userEx");
        UserExample userEx = new UserExample();
        userEx.createCriteria().andIdEqualTo(t.getUserId());
        System.out.println("UserArrayExist");
        List UserArrayExist = this.userService.queryAllObjByExample(userEx);
        User UserDefault = (User)UserArrayExist.get(0);
        t.setUserNickName(UserDefault.getNickName());
        t.setUserCode(UserDefault.getLoginName());
        t.setCompanyId(company.getId());
        t.setProjectId(project.getId());
        t.setIsEnable(Constant.YES_INT);
        t.setCreateTime(new Date());
        t.setCreateUserId(SpringSecurityUtils.getLoginUserId());
        t.setCreateUserName(SpringSecurityUtils.getLoginUserName());
        t.setUpdateTime(t.getCreateTime());
        t.setUpdateUserId(t.getCreateUserId());
        t.setUpdateUserName(t.getCreateUserName());
        System.out.println("insertSelective");
        this.materialCategoryManagerMapper.insertSelective(t);
    }

    @Override
    @CacheEvict(value={"materialCategoryManager"}, allEntries=true)
    public void deleteObjById(String id) {
        this.materialCategoryManagerMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"materialCategoryManager"}, allEntries=true)
    public void modifyObj(MaterialCategoryManager t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.materialCategoryManagerMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"materialCategoryManager"}, keyGenerator="redisKeyGenerator")
    public MaterialCategoryManager queryObjById(String id) {
        return this.materialCategoryManagerMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"materialCategoryManager"}, keyGenerator="redisKeyGenerator")
    public List<MaterialCategoryManager> queryAllObjByExample(MaterialCategoryManagerExample example) {
        return this.materialCategoryManagerMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"materialCategoryManager"}, keyGenerator="redisKeyGenerator")
    public PageView<MaterialCategoryManager> queryObjByPage(MaterialCategoryManagerExample example) {
        PageView<MaterialCategoryManager> pageView = example.getPageView();
        pageView.setQueryResult(this.materialCategoryManagerMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"materialCategoryManager"}, allEntries=true)
    public void importmaterialCategoryManager(Project project, Company company, List<MaterialCategoryManager> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        ArrayList<MaterialCategory> MaterialCategoryArray = new ArrayList<MaterialCategory>();
        Date nowDate = new Date();
        ArrayList MaterialCategoryManagerArray = new ArrayList();
        ArrayList<User> UserArray = new ArrayList<User>();
        MaterialCategory DefaultMaterialCategory = new MaterialCategory();
        User UserDefault = new User();
        for (MaterialCategoryManager entiy : list) {
            if (!this.materialCategoryService.isExists(entiy.getCategoryCode()).booleanValue()) {
                throw new CommonException("\u7269\u6599\u5206\u7c7b\u4ee3\u7801\u4e3a" + entiy.getCategoryCode() + "\u7684\u7269\u6599\u5206\u7c7b\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u5bfc\u5165!");
            }
            MaterialCategoryExample materialCategoryExample = new MaterialCategoryExample();
            MaterialCategoryExample.Criteria criteria = materialCategoryExample.createCriteria();
            criteria.andCategoryCodeEqualTo(entiy.getCategoryCode());
            if (MaterialCategoryArray.size() == 0) {
                MaterialCategory ExistMaterialCategory = (MaterialCategory)this.materialCategoryService.queryAllObjByExample(materialCategoryExample).get(0);
                MaterialCategoryArray.add(ExistMaterialCategory);
                DefaultMaterialCategory = ExistMaterialCategory;
            } else {
                boolean ishas = false;
                for (MaterialCategory materialCategory : MaterialCategoryArray) {
                    if (materialCategory.getCategoryCode() != entiy.getCategoryCode()) continue;
                    ishas = true;
                    DefaultMaterialCategory = materialCategory;
                    break;
                }
                if (!ishas) {
                    MaterialCategory DMaterialCategory = (MaterialCategory)this.materialCategoryService.queryAllObjByExample(materialCategoryExample).get(0);
                    MaterialCategoryArray.add(DMaterialCategory);
                    DefaultMaterialCategory = DMaterialCategory;
                }
            }
            UserExample userEx1 = new UserExample();
            userEx1.createCriteria().andLoginNameEqualTo(entiy.getUserCode());
            if (UserArray.size() == 0) {
                List UserArrayExist = this.userService.queryAllObjByExample(userEx1);
                if (CollectionUtils.isEmpty(UserArrayExist)) {
                    throw new CommonException("\u7528\u6237\u4ee3\u7801\u4e3a" + entiy.getUserCode() + "\u7684\u7528\u6237\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u5bfc\u5165!");
                }
                UserDefault = (User)UserArrayExist.get(0);
                UserArray.add(UserDefault);
            } else {
                boolean ishas = false;
                for (User user : UserArray) {
                    if (user.getLoginName() != entiy.getUserCode()) continue;
                    ishas = true;
                    UserDefault = user;
                    break;
                }
                if (!ishas) {
                    List list2 = this.userService.queryAllObjByExample(userEx1);
                    if (CollectionUtils.isEmpty(list2)) {
                        throw new CommonException("\u7528\u6237\u4ee3\u7801\u4e3a" + entiy.getCategoryCode() + "\u7684\u7528\u6237\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u5bfc\u5165!");
                    }
                    UserDefault = (User)list2.get(0);
                    UserArray.add(UserDefault);
                }
            }
            entiy.setCompanyId(company.getId());
            entiy.setProjectId(project.getId());
            entiy.setIsEnable(Constant.YES_INT);
            entiy.setUpdateTime(nowDate);
            entiy.setUpdateUserId(SpringSecurityUtils.getLoginUserId());
            entiy.setUpdateUserName(SpringSecurityUtils.getLoginUserName());
            entiy.setCategoryId(DefaultMaterialCategory.getId());
            entiy.setCategoryName(DefaultMaterialCategory.getCategoryName());
            entiy.setUserId(UserDefault.getId());
            entiy.setUserCode(UserDefault.getLoginName());
            entiy.setUserNickName(UserDefault.getNickName());
            if (!this.isExists(entiy.getCategoryCode(), entiy.getUserCode()).booleanValue()) {
                entiy.setCreateTime(nowDate);
                entiy.setCreateUserId(SpringSecurityUtils.getLoginUserId());
                entiy.setCreateUserName(SpringSecurityUtils.getLoginUserName());
                this.addObj(entiy);
                continue;
            }
            MaterialCategoryManagerExample example = new MaterialCategoryManagerExample();
            MaterialCategoryManagerExample.Criteria criteria2 = example.createCriteria();
            criteria2.andCategoryCodeEqualTo(entiy.getCategoryCode()).andUserCodeEqualTo(entiy.getUserCode());
            MaterialCategoryManager MaterialCategoryManagereExt = this.queryAllObjByExample(example).get(0);
            entiy.setId(MaterialCategoryManagereExt.getId());
            this.modifyObj(entiy);
        }
    }

    @Override
    public List<String> queryUserOfMaterialCategoryManager(String categoryId) {
        ArrayList<String> list = new ArrayList<String>();
        MaterialCategoryManagerExample example = new MaterialCategoryManagerExample();
        MaterialCategoryManagerExample.Criteria criteria = example.createCriteria();
        criteria.andCategoryCodeEqualTo(categoryId);
        List<MaterialCategoryManager> MaterialCategoryManagerArray = this.queryAllObjByExample(example);
        if (CollectionUtils.isEmpty(MaterialCategoryManagerArray)) {
            return null;
        }
        for (MaterialCategoryManager entity : MaterialCategoryManagerArray) {
            String userId = entity.getUserId();
            if (!StringUtils.isNotBlank((String)userId)) continue;
            list.add(userId);
        }
        return list;
    }

    @Override
    public PageView<MaterialCategoryManager> queryUserNoExistsByPage(MaterialCategoryManagerExample example) {
        PageView<MaterialCategoryManager> pageView = example.getPageView();
        pageView.setQueryResult(this.materialCategoryManagerMapper.selectUserNoExistsByPage(example));
        return pageView;
    }

    @Override
    public List<String> queryMaterialCodeByUserCode(String userCode) {
        MaterialCategoryManagerExample example = new MaterialCategoryManagerExample();
        MaterialCategoryManagerExample.Criteria criteria = example.createCriteria();
        criteria.andUserCodeEqualTo(userCode);
        List<MaterialCategoryManager> materialCategoryManagers = this.queryAllObjByExample(example);
        ArrayList<String> materialCodes = null;
        if (CollectionUtils.isNotEmpty(materialCategoryManagers)) {
            ArrayList<String> categoryIds = new ArrayList<String>(0);
            for (MaterialCategoryManager materialCategoryManager : materialCategoryManagers) {
                categoryIds.add(materialCategoryManager.getCategoryId());
            }
            if (CollectionUtils.isNotEmpty(categoryIds)) {
                MaterialExample materialExample = new MaterialExample();
                materialExample.createCriteria().andCategoryIdIn(categoryIds).andIsEnableEqualTo(Constant.YES_INT);
                List materials = this.materialService.queryAllObjByExample(materialExample);
                if (CollectionUtils.isNotEmpty(materials)) {
                    materialCodes = new ArrayList<String>(0);
                    for (Material material : materials) {
                        materialCodes.add(material.getMaterialCode());
                    }
                }
            }
        }
        return materialCodes;
    }

    public Boolean isExists(String materialCategoryCode, String Usercode) {
        if (StringUtils.isBlank((String)materialCategoryCode)) {
            throw new IllegalArgumentException("parameter materialCode is null");
        }
        MaterialCategoryManagerExample mterialCategoryManagerExample = new MaterialCategoryManagerExample();
        MaterialCategoryManagerExample.Criteria criteria = mterialCategoryManagerExample.createCriteria();
        criteria.andCategoryCodeEqualTo(materialCategoryCode).andUserCodeEqualTo(Usercode);
        int count = this.materialCategoryManagerMapper.countByExample(mterialCategoryManagerExample);
        if (count > 0) {
            return true;
        }
        return false;
    }
}

