/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.material.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.material.dao.MaterialCodeMapper;
import com.els.base.material.entity.MaterialCode;
import com.els.base.material.entity.MaterialCodeExample;
import com.els.base.material.service.MaterialCodeService;
import com.els.base.material.service.MaterialService;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="materialCodeService")
public class MaterialCodeServiceImpl
implements MaterialCodeService {
    @Resource
    protected MaterialCodeMapper materialCodeMapper;
    @Resource
    protected MaterialService materialService;

    @Override
    @CacheEvict(value={"materialCode"}, allEntries=true)
    public void addObj(MaterialCode t) {
        this.materialCodeMapper.insertSelective(t);
    }

    @Override
    @CacheEvict(value={"materialCode"}, allEntries=true)
    public void deleteObjById(String id) {
        this.materialCodeMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"materialCode"}, allEntries=true)
    public void modifyObj(MaterialCode t) {
        this.materialCodeMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"materialCode"}, keyGenerator="redisKeyGenerator")
    public MaterialCode queryObjById(String id) {
        return this.materialCodeMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"materialCode"}, keyGenerator="redisKeyGenerator")
    public List<MaterialCode> queryAllObjByExample(MaterialCodeExample example) {
        return this.materialCodeMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"materialCode"}, keyGenerator="redisKeyGenerator")
    public PageView<MaterialCode> queryObjByPage(MaterialCodeExample example) {
        PageView<MaterialCode> pageView = example.getPageView();
        pageView.setQueryResult(this.materialCodeMapper.selectByExampleByPage(example));
        return pageView;
    }
}

