/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.material.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.material.entity.FaiBorrow;
import com.els.base.material.entity.FaiBorrowExample;
import com.els.base.material.entity.MaterialSupplier;
import com.els.base.material.service.FaiBorrowService;
import com.els.base.material.service.MaterialSupplierService;
import com.els.base.material.utils.BorrowBillStatus;
import com.els.base.utils.SpringContextHolder;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="FAI\u501f\u7528")
@Controller
@RequestMapping(value={"faiBorrow"})
public class FaiBorrowController {
    @Resource
    protected FaiBorrowService faiBorrowService;
    @Resource
    protected MaterialSupplierService materialSupplierService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efaFAI\u501f\u7528")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody FaiBorrow faiBorrow) {
        Assert.isNotBlank(faiBorrow.getMaterialCode(), "\u7269\u6599\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a\u4fdd\u5b58\u5931\u8d25");
        Assert.isNotBlank(faiBorrow.getBorrowId(), "\u6ca1\u6709\u9009\u62e9\u501f\u7528FAI\uff0c\u4fdd\u5b58\u5931\u8d25");
        faiBorrow.setUpdateUserId(SpringSecurityUtils.getLoginUserId());
        faiBorrow.setUpdateUserName(SpringSecurityUtils.getLoginUser().getNickName());
        faiBorrow.setUpdateTime(new Date());
        faiBorrow.setCreateUserId(SpringSecurityUtils.getLoginUserId());
        faiBorrow.setCreateUserName(SpringSecurityUtils.getLoginUser().getNickName());
        faiBorrow.setCreateTime(new Date());
        MaterialSupplier materialSupplier = (MaterialSupplier)this.materialSupplierService.queryObjById(faiBorrow.getBorrowId());
        faiBorrow.setSourceAttachment(materialSupplier.getAttachment());
        faiBorrow.setSourceMaterialCode(materialSupplier.getMaterialCode());
        faiBorrow.setSourceMaterialName(materialSupplier.getMaterialName());
        faiBorrow.setSourceOrderNo(materialSupplier.getOrderNo());
        faiBorrow.setSourceOrderItemNo(materialSupplier.getOrderItemNo());
        GenerateCodeService generateCodeService = (GenerateCodeService)SpringContextHolder.getOneBean(GenerateCodeService.class);
        String billNo = generateCodeService.getNextCode("FAI_FROM_NO");
        faiBorrow.setBillStatus(BorrowBillStatus.NEW.getValue());
        faiBorrow.setBillNo(billNo);
        this.faiBorrowService.addObj(faiBorrow);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u521b\u5efaFAI\u501f\u7528")
    @RequestMapping(value={"service/save"})
    @ResponseBody
    public ResponseResult<String> save(@RequestBody FaiBorrow faiBorrow) {
        Assert.isNotBlank(faiBorrow.getMaterialCode(), "\u7269\u6599\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a\u4fdd\u5b58\u5931\u8d25");
        Assert.isNotBlank(faiBorrow.getBorrowId(), "\u6ca1\u6709\u9009\u62e9\u501f\u7528FAI\uff0c\u4fdd\u5b58\u5931\u8d25");
        faiBorrow.setUpdateUserId(SpringSecurityUtils.getLoginUserId());
        faiBorrow.setUpdateUserName(SpringSecurityUtils.getLoginUser().getNickName());
        faiBorrow.setUpdateTime(new Date());
        faiBorrow.setCreateUserId(SpringSecurityUtils.getLoginUserId());
        faiBorrow.setCreateUserName(SpringSecurityUtils.getLoginUser().getNickName());
        faiBorrow.setCreateTime(new Date());
        this.faiBorrowService.modifyObj(faiBorrow);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u83b7\u53d6FAI\u501f\u7528\u8be6\u7ec6\u4fe1\u606f")
    @RequestMapping(value={"service/findById"})
    @ResponseBody
    public ResponseResult<FaiBorrow> findById(@RequestParam(required=true) String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new CommonException("id \u4e3a\u7a7a\uff0c\u83b7\u53d6\u6570\u636e\u5931\u8d25");
        }
        return ResponseResult.success(this.faiBorrowService.queryObjById(id));
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91FAI\u501f\u7528")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody FaiBorrow faiBorrow) {
        Assert.isNotBlank(faiBorrow.getId(), "id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.faiBorrowService.modifyObj(faiBorrow);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664FAI\u501f\u7528")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, "\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        FaiBorrowExample example = new FaiBorrowExample();
        example.createCriteria().andIdIn((List)ids);
        this.faiBorrowService.deleteByExample(example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2FAI\u501f\u7528")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 FaiBorrow", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<FaiBorrow>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        FaiBorrowExample example = new FaiBorrowExample();
        example.setPageView(new PageView<FaiBorrow>(pageNo, pageSize));
        FaiBorrowExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        PageView pageData = this.faiBorrowService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u4e0a\u4f20\u9644\u4ef6")
    @RequestMapping(value={"service/attachment"})
    @ResponseBody
    public ResponseResult<String> attachment(@RequestBody FaiBorrow faiborrow) {
        if (StringUtils.isBlank((String)faiborrow.getId())) {
            throw new CommonException("id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        }
        FaiBorrow faiBorrow = (FaiBorrow)this.faiBorrowService.queryObjById(faiborrow.getId());
        faiBorrow.setAttachment(faiborrow.getAttachment());
        faiBorrow.setUpdateUserId(SpringSecurityUtils.getLoginUserId());
        faiBorrow.setUpdateUserName(SpringSecurityUtils.getLoginUser().getNickName());
        faiBorrow.setUpdateTime(new Date());
        this.faiBorrowService.modifyObj(faiBorrow);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u9001\u7b7e")
    @RequestMapping(value={"service/sendToSing"})
    @ResponseBody
    public ResponseResult<String> sendToSing(@RequestBody FaiBorrow faiborrow) {
        if (StringUtils.isBlank((String)faiborrow.getId())) {
            throw new CommonException("id \u4e3a\u7a7a\uff0c\u9001\u7b7e\u5931\u8d25");
        }
        this.faiBorrowService.sendToSing(faiborrow.getId());
        return ResponseResult.success();
    }
}

