/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.material.web.controller;

import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.project.Project;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.user.UserService;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.material.entity.MaterialCategoryManager;
import com.els.base.material.entity.MaterialCategoryManagerExample;
import com.els.base.material.service.MaterialCategoryManagerService;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.TitleAndModelKey;
import com.els.base.utils.txtImport.TxtImportResponse;
import com.els.base.utils.txtImport.TxtImportUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import jxl.write.WritableWorkbook;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

@Api(value="\u7269\u6599\u5206\u7c7b\u5f00\u53d1\u5458")
@Controller
@RequestMapping(value={"materialCategoryManager"})
public class MaterialCategoryManagerController {
    Logger logger = LoggerFactory.getLogger(MaterialCategoryManagerController.class);
    @Resource
    protected MaterialCategoryManagerService materialCategoryManagerService;
    @Resource
    protected CompanyUserRefService companyUserRefService;
    @Resource
    protected UserService userService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u7269\u6599\u5206\u7c7b\u5f00\u53d1\u5458")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody MaterialCategoryManager materialCategoryManager) {
        this.materialCategoryManagerService.addObj(materialCategoryManager);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u7269\u6599\u5206\u7c7b\u5f00\u53d1\u5458")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody MaterialCategoryManager materialCategoryManager) {
        Assert.isNotBlank(materialCategoryManager.getId(), "id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.materialCategoryManagerService.modifyObj(materialCategoryManager);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u7269\u6599\u5206\u7c7b\u5f00\u53d1\u5458")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        Assert.isNotBlank(id, "\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        this.materialCategoryManagerService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u7269\u6599\u5206\u7c7b\u5f00\u53d1\u5458")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 MaterialCategoryManager", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<MaterialCategoryManager>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        MaterialCategoryManagerExample example = new MaterialCategoryManagerExample();
        example.setPageView(new PageView<MaterialCategoryManager>(pageNo, pageSize));
        MaterialCategoryManagerExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        PageView pageData = this.materialCategoryManagerService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(value="\u5bfc\u5165\u7269\u6599\u5206\u7c7b\u7ba1\u7406\u5458", httpMethod="POST")
    @ResponseBody
    @RequestMapping(value={"service/importMaterialCategoryManagerFromTxt"})
    public ResponseResult<String> importMaterialCategoryManagerFromTxt(MultipartHttpServletRequest request) {
        Map fileMap = request.getFileMap();
        MultipartFile file = this.vaildTxtFile(fileMap);
        String[] keys = new String[]{"categoryCode", "categoryName", "userCode", "userNickName"};
        try {
            TxtImportResponse importTxt = TxtImportUtils.importTxt((MultipartFile)file, (String)"\t", MaterialCategoryManager.class, (String[])keys);
            List list = importTxt.getList();
            this.materialCategoryManagerService.importmaterialCategoryManager(ProjectUtils.getProject(), CompanyUtils.currentCompany(), list);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CommonException("\u5bfc\u5165\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return ResponseResult.success();
    }

    private MultipartFile vaildTxtFile(Map<String, MultipartFile> fileMap) {
        if (MapUtils.isEmpty(fileMap)) {
            throw new CommonException("\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a", "file_isNull");
        }
        if (fileMap.size() > 1) {
            throw new CommonException("\u53ea\u63a5\u53d7\u5355\u4e2a\u6587\u4ef6\u5bfc\u5165");
        }
        Set<String> fileKeySet = fileMap.keySet();
        Iterator<String> keyIterator = fileKeySet.iterator();
        MultipartFile file = null;
        while (keyIterator.hasNext()) {
            file = fileMap.get(keyIterator.next());
        }
        if (!file.getOriginalFilename().endsWith(".txt")) {
            throw new CommonException("\u5bfc\u5165\u6587\u4ef6\u7684\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u76ee\u524d\u53ea\u652f\u6301txt");
        }
        return file;
    }

    @ApiOperation(value="\u7269\u6599\u5206\u7c7b\u7ba1\u7406\u5458\u5bfc\u5165\u6a21\u677f(Excel)", httpMethod="GET")
    @RequestMapping(value={"service/downloadTemplateExcel"})
    @ResponseBody
    public ModelAndView downloadTemplateExcel(HttpServletResponse response) {
        try {
            response.reset();
            StringBuffer header = new StringBuffer("attachment;");
            header.append("filename=\"" + URLEncoder.encode("\u7269\u6599\u5206\u7c7b\u7ba1\u7406\u5458\u5bfc\u5165\u6a21\u677f.xls", "UTF-8") + "\";");
            response.setHeader("Content-Disposition", header.toString());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/vnd.ms-excel");
            ServletOutputStream outputStream = response.getOutputStream();
            List<TitleAndModelKey> titleAndModelKeys = this.createTitleAndModelKey();
            ArrayList list = new ArrayList();
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)outputStream, titleAndModelKeys, list, (String)"\u7269\u6599\u5206\u7c7b", null, (int)0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus(417);
        }
        return null;
    }

    private List<TitleAndModelKey> createTitleAndModelKey() {
        ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u5206\u7c7b\u4ee3\u7801", (String)"categoryCode", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u5206\u7c7b\u540d\u79f0", (String)"categoryName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7528\u6237\u4ee3\u7801", (String)"userCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7528\u6237\u6635\u79f0", (String)"userNickName"));
        return titleAndModelKeys;
    }

    @ApiOperation(value="\u67e5\u8be2\u4e0d\u5728\u7269\u6599\u5206\u7c7b\u7ba1\u7406\u5458\u4e0b\u9762\u7684\u7528\u6237", httpMethod="POST")
    @RequestMapping(value={"service/findUserByPage"})
    @ResponseBody
    public ResponseResult<PageView<MaterialCategoryManager>> findUserByPage(@ApiParam(value="\u6240\u5728\u9875", defaultValue="1") @RequestParam(defaultValue="1") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u7269\u6599\u5206\u7c7bID", defaultValue="10") @RequestParam String categoryId, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6") @RequestBody(required=false) QueryParamWapper wapper) {
        this.logger.info("categoryId{}", (Object)categoryId);
        ArrayList<String> selectUserIdList = new ArrayList<String>();
        List<String> userIdList = this.companyUserRefService.queryUserOfCompany(CompanyUtils.currentCompanyId());
        this.logger.info("userIdList{}", userIdList);
        List<String> noInUserIdList = this.materialCategoryManagerService.queryUserOfMaterialCategoryManager(categoryId);
        this.logger.info("noInUserIdList{}", noInUserIdList);
        MaterialCategoryManagerExample example = new MaterialCategoryManagerExample();
        example.setPageView(new PageView<MaterialCategoryManager>(pageNo, pageSize));
        MaterialCategoryManagerExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        if (!CollectionUtils.isEmpty(userIdList) && !CollectionUtils.isEmpty(noInUserIdList)) {
            for (String userid : userIdList) {
                boolean isadded = false;
                for (String muserid : userIdList) {
                    if (!userid.equals(muserid)) continue;
                    isadded = true;
                    break;
                }
                if (isadded) continue;
                selectUserIdList.add(userid);
            }
        }
        if (!CollectionUtils.isEmpty(selectUserIdList)) {
            criteria.andUserIdIn(selectUserIdList);
        }
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        PageView<MaterialCategoryManager> list = this.materialCategoryManagerService.queryUserNoExistsByPage(example);
        return ResponseResult.success(list);
    }

    @ApiOperation(httpMethod="POST", value="\u65b0\u589e\u7269\u6599\u5206\u7c7b\u5f00\u53d1\u5458")
    @RequestMapping(value={"service/addUser"})
    @ResponseBody
    public ResponseResult<String> addUser(@RequestBody MaterialCategoryManager materialCategoryManager) {
        if (materialCategoryManager.getCategoryId().isEmpty()) {
            throw new CommonException("\u7269\u6599\u5206\u7c7bID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (materialCategoryManager.getUserId().isEmpty()) {
            throw new CommonException("\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.materialCategoryManagerService.addObj(ProjectUtils.getProject(), CompanyUtils.currentCompany(), materialCategoryManager);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u65b0\u589e\u7269\u6599\u5206\u7c7b\u5f00\u53d1\u5458")
    @RequestMapping(value={"service/addUserArray"})
    @ResponseBody
    public ResponseResult<String> addUserArray(@RequestBody List<MaterialCategoryManager> materialCategoryManagerList) {
        if (CollectionUtils.isEmpty(materialCategoryManagerList)) {
            throw new CommonException("\u63d0\u4ea4\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", "not_query_to_data");
        }
        Project project = ProjectUtils.getProject();
        Company company = CompanyUtils.currentCompany();
        for (MaterialCategoryManager materialCategoryManager : materialCategoryManagerList) {
            if (materialCategoryManager.getCategoryId().isEmpty()) {
                throw new CommonException("\u7269\u6599\u5206\u7c7bID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (materialCategoryManager.getUserId().isEmpty()) {
                throw new CommonException("\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            this.materialCategoryManagerService.addObj(project, company, materialCategoryManager);
        }
        return ResponseResult.success();
    }
}

