/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.material.web.controller;

import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.material.entity.Material;
import com.els.base.material.entity.MaterialExample;
import com.els.base.material.entity.MaterialSupplier;
import com.els.base.material.entity.MaterialSupplierExample;
import com.els.base.material.service.MaterialService;
import com.els.base.material.service.MaterialSupplierService;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.TitleAndModelKey;
import com.els.base.utils.txtImport.TxtImportResponse;
import com.els.base.utils.txtImport.TxtImportUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import jxl.write.WritableWorkbook;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

@Api(value="\u8d27\u6e90\u6e05\u5355")
@Controller
@RequestMapping(value={"materialSupplier"})
public class MaterialSupplierController {
    @Resource
    protected MaterialSupplierService materialSupplierService;
    @Resource
    protected MaterialService materialService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u8d27\u6e90\u6e05\u5355")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody MaterialSupplier materialSupplier) {
        this.materialSupplierService.addObj(ProjectUtils.getProject(), CompanyUtils.currentCompany(), materialSupplier);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u8d27\u6e90\u6e05\u5355")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody MaterialSupplier materialSupplier) {
        Assert.isNotBlank(materialSupplier.getId(), "id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.materialSupplierService.modifyObj(materialSupplier);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u8d27\u6e90\u6e05\u5355")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        Assert.isNotBlank(id, "\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        this.materialSupplierService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u5220\u9664\u8d27\u6e90\u6e05\u5355")
    @RequestMapping(value={"service/deleteByIdArray"})
    @ResponseBody
    public ResponseResult<String> deleteByIdArray(@RequestBody(required=false) List<String> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            throw new CommonException("\u63d0\u4ea4\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", "not_query_to_data");
        }
        this.materialSupplierService.deleteObjByIdArray(idList);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u8d27\u6e90\u6e05\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 MaterialSupplier", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<MaterialSupplier>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        MaterialSupplierExample example = new MaterialSupplierExample();
        example.setPageView(new PageView<MaterialSupplier>(pageNo, pageSize));
        MaterialSupplierExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        PageView pageData = this.materialSupplierService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u8d27\u6e90\u6e05\u5355(\u501f\u7528\u67e5\u8be2)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="BorrowMaterialCode", required=false, value="\u7533\u8bf7\u7269\u6599\u4ee3\u7801", paramType="query", dataType="String"), @ApiImplicitParam(name="BorrowCompanySapCode", required=false, value="\u9009\u62e9\u4f9b\u5e94\u5546\u4ee3\u7801", paramType="query", dataType="String"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 MaterialSupplier", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findBorrowByPage"})
    @ResponseBody
    public ResponseResult<PageView<MaterialSupplier>> findBorrowByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=true) String BorrowMaterialCode, @RequestParam String BorrowCompanySapCode, @RequestBody(required=false) QueryParamWapper wapper) {
        MaterialSupplierExample example = new MaterialSupplierExample();
        example.setPageView(new PageView<MaterialSupplier>(pageNo, pageSize));
        MaterialSupplierExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        MaterialExample materialExample = new MaterialExample();
        materialExample.createCriteria().andMaterialCodeEqualTo(BorrowMaterialCode);
        criteria.andCategoryIdEqualTo(((Material)this.materialService.queryAllObjByExample(materialExample).get(0)).getCategoryId());
        if (StringUtils.isNotEmpty((String)BorrowCompanySapCode)) {
            criteria.andSupCompanySapCodeEqualTo(BorrowCompanySapCode);
        }
        PageView pageData = this.materialSupplierService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(value="\u5bfc\u5165\u8d27\u6e90\u6e05\u5355", httpMethod="POST")
    @ResponseBody
    @RequestMapping(value={"service/importMaterialSupplierFromTxt"})
    public ResponseResult<String> importMaterialSupplierFromTxt(MultipartHttpServletRequest request) {
        Map fileMap = request.getFileMap();
        MultipartFile file = this.vaildTxtFile(fileMap);
        String[] keys = new String[]{"materialCode", "materialName", "supCompanySapCode", "supCompanyName", "fai", "sample", "faitype"};
        try {
            TxtImportResponse importTxt = TxtImportUtils.importTxt((MultipartFile)file, (String)"\t", MaterialSupplier.class, (String[])keys);
            List list = importTxt.getList();
            this.materialSupplierService.importMaterialSupplier(ProjectUtils.getProject(), CompanyUtils.currentCompany(), list);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CommonException("\u5bfc\u5165\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return ResponseResult.success();
    }

    private MultipartFile vaildTxtFile(Map<String, MultipartFile> fileMap) {
        if (MapUtils.isEmpty(fileMap)) {
            throw new CommonException("\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a", "file_isNull");
        }
        if (fileMap.size() > 1) {
            throw new CommonException("\u53ea\u63a5\u53d7\u5355\u4e2a\u6587\u4ef6\u5bfc\u5165");
        }
        Set<String> fileKeySet = fileMap.keySet();
        Iterator<String> keyIterator = fileKeySet.iterator();
        MultipartFile file = null;
        while (keyIterator.hasNext()) {
            file = fileMap.get(keyIterator.next());
        }
        if (!file.getOriginalFilename().endsWith(".txt")) {
            throw new CommonException("\u5bfc\u5165\u6587\u4ef6\u7684\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u76ee\u524d\u53ea\u652f\u6301txt");
        }
        return file;
    }

    @ApiOperation(value="\u8d27\u6e90\u6e05\u5355\u5bfc\u5165\u6a21\u677f(Excel)", httpMethod="GET")
    @RequestMapping(value={"service/downloadTemplateExcel"})
    @ResponseBody
    public ModelAndView downloadTemplateExcel(HttpServletResponse response) {
        try {
            response.reset();
            StringBuffer header = new StringBuffer("attachment;");
            header.append("filename=\"" + URLEncoder.encode("\u8d27\u6e90\u6e05\u5355\u5bfc\u5165\u6a21\u677f.xls", "UTF-8") + "\";");
            response.setHeader("Content-Disposition", header.toString());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/vnd.ms-excel");
            ServletOutputStream outputStream = response.getOutputStream();
            List<TitleAndModelKey> titleAndModelKeys = this.createTitleAndModelKey();
            ArrayList list = new ArrayList();
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)outputStream, titleAndModelKeys, list, (String)"\u8d27\u6e90\u6e05\u5355", null, (int)0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus(417);
        }
        return null;
    }

    private List<TitleAndModelKey> createTitleAndModelKey() {
        ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u7f16\u7801", (String)"materialCode", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u540d\u79f0", (String)"materialName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u7f16\u7801", (String)"supCompanySapCode", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u540d\u79f0", (String)"supCompanyName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"FAI\u6807\u8bc6(Y/N)", (String)"fai"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6837\u54c1(Y/N)", (String)"sample"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"FAI\u7c7b\u522b(1\u9996\u4ef6\u786e\u8ba4/2\u9996\u4ef6\u9274\u5b9a)", (String)"faitype", (boolean)true));
        return titleAndModelKeys;
    }
}

