/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.mould.master.command;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.mould.common.AbstractMouldCommand;
import com.els.base.mould.common.MouldInvorker;
import com.els.base.mould.master.enumclass.MouldAuditStatus;
import com.els.base.mould.master.event.MouldApprovePassListener;
import com.els.base.mould.master.vo.MouldVO;
import com.els.base.workflow.common.entity.ProcessStartVO;
import java.util.List;
import org.activiti.engine.runtime.ProcessInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApproveSubmitCommand
extends AbstractMouldCommand<String> {
    private static final Logger logger = LoggerFactory.getLogger(ApproveSubmitCommand.class);
    private List<MouldVO> mouldVOList;

    public ApproveSubmitCommand(List<MouldVO> mouldVO) {
        this.mouldVOList = mouldVO;
    }

    @Override
    public String execute(MouldInvorker invoker) {
        this.vaild(this.mouldVOList);
        logger.info("\u63d0\u4ea4\u8be2\u4ef7\u5355\u5ba1\u6838\uff0c\u5f00\u542f\u5ba1\u6279\u6d41");
        for (MouldVO mouldVO : this.mouldVOList) {
            String displayPage = String.format("findDetailById?id=%s", mouldVO.getId());
            ProcessStartVO vo = ProcessStartVO.newInstance("mould", mouldVO.getMouldTemporaryCode(), mouldVO.getId(), displayPage);
            vo.setListenerClass(MouldApprovePassListener.class);
            ProcessInstance startProcess = invoker.getWorkFlowService().startProcess(vo);
            if (startProcess == null) {
                throw new CommonException("\u542f\u52a8\u5ba1\u6279\u6d41\u7a0b\u5931\u8d25");
            }
            logger.info("\u5c06\u6a21\u5177ID={},\u72b6\u6001\u6539\u6210\u201c\u5ba1\u6279\u4e2d\u201d\u72b6\u6001", (Object)mouldVO.getId());
            MouldVO mould = new MouldVO();
            mould.setId(mouldVO.getId());
            mould.setApproveStatus(MouldAuditStatus.AUDITING.getCode());
            invoker.getMouldService().modifyObj(mould);
        }
        return null;
    }

    private void vaild(List<MouldVO> mouldVOList) {
        Assert.isNotEmpty(mouldVOList, "ID\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u64cd\u4f5c\u5931\u8d25\uff01");
        for (MouldVO mouldVO : mouldVOList) {
            Assert.isNotBlank(mouldVO.getId(), "ID\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u64cd\u4f5c\u5931\u8d25\uff01");
        }
    }
}

