/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.mould.master.command;

import com.els.base.company.entity.Company;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.mould.common.AbstractMouldCommand;
import com.els.base.mould.common.MouldInvorker;
import com.els.base.mould.master.entity.MouldMaterial;
import com.els.base.mould.master.enumclass.MouldAuditStatus;
import com.els.base.mould.master.vo.MouldVO;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class CreateMouldCmd
extends AbstractMouldCommand<String> {
    private static final String MOULD_TEMP_CODE = "MOULD_TEMP_CODE";
    private MouldVO mouldVo;

    public CreateMouldCmd(MouldVO mouldVo) {
        this.mouldVo = mouldVo;
    }

    @Override
    public String execute(MouldInvorker mouldInvorker) {
        Assert.isNotNull(this.mouldVo, "\u4f20\u9012\u7684\u6a21\u5177\u6570\u636e\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58\u6a21\u5177!");
        if (CollectionUtils.isEmpty(this.mouldVo.getMouldMaterialList())) {
            throw new CommonException("\u4f20\u9012\u7684\u6a21\u5177\u7269\u6599\u6570\u636e\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58\u6a21\u5177!");
        }
        this.verificatData(this.mouldVo);
        this.completeMouldData(this.mouldVo);
        mouldInvorker.getMouldService().addObj(this.mouldVo);
        List<MouldMaterial> mouldMaterialList = this.mouldVo.getMouldMaterialList();
        for (MouldMaterial mouldMaterial : mouldMaterialList) {
            mouldInvorker.getMouldMaterialService().addObj(mouldMaterial);
        }
        return null;
    }

    private void completeMouldData(MouldVO mouldVo) {
        String id = UUIDGenerator.generateUUID();
        mouldVo.setId(id);
        mouldVo.setProjectId(ProjectUtils.getProjectId());
        Company purCompany = this.getPurCompany();
        mouldVo.setPurCompanyId(purCompany.getId());
        mouldVo.setPurCompanySrmCode(purCompany.getCompanyCode());
        mouldVo.setPurCompanyName(purCompany.getCompanyName());
        mouldVo.setPurCompanyFullName(purCompany.getCompanyFullName());
        mouldVo.setPurUserName(this.getPurUser().getNickName());
        mouldVo.setPurUserId(this.getPurUser().getId());
        String tempMouldCode = this.mouldInvorker.getGenerateCodeService().getNextCode(MOULD_TEMP_CODE);
        mouldVo.setMouldTemporaryCode(tempMouldCode);
        mouldVo.setMouldStatus(Constant.YES_INT);
        mouldVo.setIsEnable(Constant.YES_INT);
        mouldVo.setCreateTime(new Date());
        mouldVo.setApproveStatus(MouldAuditStatus.UNAUDITED.getCode());
        mouldVo.setSendStatus(Constant.NO_INT);
        for (MouldMaterial mouldMaterial : mouldVo.getMouldMaterialList()) {
            mouldMaterial.setMouldId(id);
            mouldMaterial.setProjectId(ProjectUtils.getProjectId());
            mouldMaterial.setCreateTime(new Date());
        }
    }

    private void verificatData(MouldVO mouldVo) {
        Assert.isNotBlank(mouldVo.getMouldDesc(), "\u6a21\u5177\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a!");
        List<MouldMaterial> mouldMaterialList = mouldVo.getMouldMaterialList();
        for (MouldMaterial mouldMaterial : mouldMaterialList) {
            Assert.isNotBlank(mouldMaterial.getMaterialCode(), "\u6a21\u5177\u7269\u6599\u660e\u7ec6\u4e2d\u7684\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
            Assert.isNotBlank(mouldMaterial.getMaterialDesc(), "\u6a21\u5177\u7269\u6599\u660e\u7ec6\u4e2d\u7684\u7269\u6599\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a!");
            Assert.isNotNull(mouldMaterial.getIsCalculated(), "\u6a21\u5177\u7269\u6599\u660e\u7ec6\u4e2d\u7684\u662f\u5426\u6838\u7b97\u4e0d\u80fd\u4e3a\u7a7a!");
        }
    }
}

