/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.mould.master.command;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.mould.common.AbstractMouldCommand;
import com.els.base.mould.common.MouldInvorker;
import com.els.base.mould.master.entity.Mould;
import com.els.base.mould.master.entity.MouldExample;
import com.els.base.mould.master.vo.MouldVO;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public class SendCommand
extends AbstractMouldCommand<String> {
    private static final Logger logger = LoggerFactory.getLogger(SendCommand.class);
    private List<MouldVO> mouldVOList;

    public SendCommand(List<MouldVO> mouldVOList) {
        this.mouldVOList = mouldVOList;
    }

    @Override
    @Transactional
    public String execute(MouldInvorker mouldInvorker) {
        this.valid(this.mouldVOList);
        List ids = this.mouldVOList.stream().map(Mould::getId).collect(Collectors.toList());
        MouldExample mouldExample = new MouldExample();
        mouldExample.createCriteria().andIdIn(ids);
        Mould mould = new Mould();
        mould.setSendStatus(Constant.YES_INT);
        mouldInvorker.getMouldService().updateByExampleSelective(mould, mouldExample);
        return null;
    }

    private void valid(List<MouldVO> mouldVOList) {
        Assert.isNotEmpty(mouldVOList, "ID\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u64cd\u4f5c\u5931\u8d25\uff01");
        for (MouldVO mouldVO : mouldVOList) {
            Assert.isNotBlank(mouldVO.getId(), "ID\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u64cd\u4f5c\u5931\u8d25\uff01");
        }
        List ids = mouldVOList.stream().map(Mould::getId).collect(Collectors.toList());
        MouldExample mouldExample = new MouldExample();
        mouldExample.createCriteria().andIdIn(ids);
        List moulds = this.mouldInvorker.getMouldService().queryAllObjByExample(mouldExample);
        Assert.isNotEmpty(moulds, "\u6a21\u5177\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u64cd\u4f5c\u5931\u8d25\uff01");
        ArrayList list = new ArrayList();
        for (Mould mould : moulds) {
            if (!Constant.YES_INT.equals(mould.getSendStatus())) continue;
            throw new CommonException("\u6a21\u5177\u7f16\u7801\u4e3a\uff1a" + mould.getMouldTemporaryCode() + "\u5df2\u7ecf\u53d1\u9001\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u53d1\u9001\uff0c\u8c22\u8c22\uff01");
        }
    }
}

