/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.mould.master.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.file.entity.FileData;
import com.els.base.file.service.FileManagerFactory;
import com.els.base.material.entity.Material;
import com.els.base.material.entity.MaterialExample;
import com.els.base.material.service.MaterialService;
import com.els.base.mould.common.MouldInvorker;
import com.els.base.mould.master.command.ApproveSubmitCommand;
import com.els.base.mould.master.command.CreateMouldCmd;
import com.els.base.mould.master.command.ModifyMouldCmd;
import com.els.base.mould.master.command.SendCommand;
import com.els.base.mould.master.entity.Mould;
import com.els.base.mould.master.entity.MouldExample;
import com.els.base.mould.master.entity.MouldMaterial;
import com.els.base.mould.master.entity.MouldMaterialExample;
import com.els.base.mould.master.service.MouldMaterialService;
import com.els.base.mould.master.service.MouldService;
import com.els.base.mould.master.vo.MouldMaterialExt;
import com.els.base.mould.master.vo.MouldVO;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.TitleAndModelKey;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import jxl.write.WritableWorkbook;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Api(value="\u8d44\u4ea7\u7ba1\u7406-\u6a21\u5177\u4e3b\u6570\u636e")
@Controller
@RequestMapping(value={"mould"})
public class MouldController {
    @Resource
    private MouldInvorker invoker;
    @Resource
    private MouldService mouldService;
    @Resource
    private MouldMaterialService mouldMaterialService;
    @Resource
    private MaterialService materialService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u8d44\u4ea7\u7ba1\u7406-\u6a21\u5177\u4e3b\u6570\u636e")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody MouldVO mouldVo) {
        CreateMouldCmd cmd = new CreateMouldCmd(mouldVo);
        cmd.setPurCompany(CompanyUtils.currentCompany());
        cmd.setPurUser((User)SpringSecurityUtils.getLoginUser());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u8d44\u4ea7\u7ba1\u7406-\u6a21\u5177\u4e3b\u6570\u636e")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody MouldVO mouldVo) {
        Assert.isNotBlank(mouldVo.getId(), "id\u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        ModifyMouldCmd cmd = new ModifyMouldCmd(mouldVo);
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u83b7\u53d6\u6a21\u5177\u8ba1\u7b97\u7684\u4e0a\u6b21\u622a\u6b62\u65e5\u671f")
    @RequestMapping(value={"service/getMouldLastCalculateTime"})
    @ResponseBody
    public ResponseResult<Date> getMouldLastCalculateTime() {
        Date time = this.mouldService.getMouldLastCalculateTime();
        return ResponseResult.success(time);
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u5220\u9664\u8d44\u4ea7\u7ba1\u7406-\u6a21\u5177\u4e3b\u6570\u636e")
    @RequestMapping(value={"service/deleteMoulds"})
    @ResponseBody
    public ResponseResult<String> deleteMoulds(@RequestBody List<String> ids) {
        this.mouldService.deleteMoulds(ids);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u63d0\u4ea4\u5ba1\u6838\u8d44\u4ea7\u7ba1\u7406-\u6a21\u5177\u4e3b\u6570\u636e")
    @RequestMapping(value={"service/approve"})
    @ResponseBody
    public ResponseResult<String> approve(@RequestBody List<MouldVO> mouldVoList) {
        ApproveSubmitCommand cmd = new ApproveSubmitCommand(mouldVoList);
        cmd.setPurCompany(CompanyUtils.currentCompany());
        cmd.setPurUser((User)SpringSecurityUtils.getLoginUser());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u53d1\u9001\u6a21\u5177\u6570\u636e\u8fdb\u884c\u8be2\u4ef7")
    @RequestMapping(value={"service/send"})
    @ResponseBody
    public ResponseResult<String> send(@RequestBody List<MouldVO> mouldVoList) {
        SendCommand cmd = new SendCommand(mouldVoList);
        cmd.setPurCompany(CompanyUtils.currentCompany());
        cmd.setPurUser((User)SpringSecurityUtils.getLoginUser());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u62a5\u5e9f\u8d44\u4ea7\u7ba1\u7406-\u6a21\u5177\u4e3b\u6570\u636e")
    @RequestMapping(value={"service/scrapMoulds"})
    @ResponseBody
    public ResponseResult<String> scrapMoulds(@RequestBody List<String> ids) {
        this.mouldService.scrapMoulds(ids);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u770b\u5355\u636e\u660e\u7ec6")
    @RequestMapping(value={"service/findDetailById"})
    @ResponseBody
    public ResponseResult<MouldVO> findDetailById(@RequestParam(required=true) String id) {
        Assert.isNotBlank(id, "\u67e5\u770b\u8be6\u60c5,id\u4e0d\u80fd\u4e3a\u7a7a");
        Mould data = (Mould)this.mouldService.queryObjById(id);
        if (null == data) {
            throw new CommonException("\u67e5\u5230\u7684\u6a21\u5177\u6570\u636e\u4e3a\u7a7a!");
        }
        MouldMaterialExample example = new MouldMaterialExample();
        example.createCriteria().andMouldIdEqualTo(id);
        List<MouldMaterial> moudlMaterialList = this.mouldMaterialService.queryAllObjByExample(example);
        MouldVO vo = new MouldVO();
        BeanUtils.copyProperties((Object)data, (Object)vo);
        vo.setMouldMaterialList(moudlMaterialList);
        return ResponseResult.success(vo);
    }

    @ApiOperation(httpMethod="POST", value="\u901a\u8fc7\u7269\u6599\u7f16\u7801\u67e5\u8be2\u6a21\u5177\u4fe1\u606f")
    @RequestMapping(value={"service/findMouldsByMaterialCode"})
    @ResponseBody
    public ResponseResult<List<Mould>> findMouldsByMaterialCode(@RequestParam(required=true) String materialCode) {
        Assert.isNotBlank(materialCode, "\u4f20\u9012\u7684\u7269\u6599\u7f16\u7801\u4e3a\u7a7a!");
        MouldMaterialExample materialExample = new MouldMaterialExample();
        materialExample.createCriteria().andMaterialCodeEqualTo(materialCode);
        List mouldMaterials = this.mouldMaterialService.queryAllObjByExample(materialExample);
        if (CollectionUtils.isEmpty(mouldMaterials)) {
            return ResponseResult.success(null);
        }
        ArrayList<String> mouldIds = new ArrayList<String>();
        for (MouldMaterial mm : mouldMaterials) {
            mouldIds.add(mm.getMouldId());
        }
        MouldExample example = new MouldExample();
        example.createCriteria().andIdIn(mouldIds).andIsEnableEqualTo(Constant.YES_INT).andMouldStatusEqualTo(Constant.YES_INT);
        List list = this.mouldService.queryAllObjByExample(example);
        return ResponseResult.success(list);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u8d44\u4ea7\u7ba1\u7406-\u6a21\u5177\u4e3b\u6570\u636e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Mould", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPageForPur"})
    @ResponseBody
    public ResponseResult<PageView<Mould>> findByPageForPur(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        MouldExample example = new MouldExample();
        example.setPageView(new PageView<Mould>(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        MouldExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        PageView pageData = this.mouldService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u8d44\u4ea7\u7ba1\u7406-\u6a21\u5177\u4e3b\u6570\u636e(\u4f9b\u8c03\u6574\u5355\u4f7f\u7528)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Mould", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPageForAdjust"})
    @ResponseBody
    public ResponseResult<PageView<MouldVO>> findByPageForAdjust(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        MouldExample example = new MouldExample();
        example.setPageView(new PageView<Mould>(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        MouldExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        PageView pageData = this.mouldService.queryObjByPage(example);
        ArrayList<MouldVO> voList = new ArrayList<MouldVO>();
        if (CollectionUtils.isNotEmpty(pageData.getQueryResult())) {
            List result = pageData.getQueryResult();
            for (Mould mould : result) {
                MouldMaterialExample materialExample = new MouldMaterialExample();
                materialExample.createCriteria().andMouldIdEqualTo(mould.getId());
                List<MouldMaterial> materialList = this.mouldMaterialService.queryAllObjByExample(materialExample);
                MouldVO vo = new MouldVO();
                BeanUtils.copyProperties((Object)mould, (Object)vo);
                vo.setMouldMaterialList(materialList);
                voList.add(vo);
            }
        } else {
            PageView<MouldVO> data = new PageView<MouldVO>(pageNo, pageSize);
            data.setQueryResult(voList);
            data.setRowCount(0);
            return ResponseResult.success(data);
        }
        PageView<MouldVO> voPageData = new PageView<MouldVO>(pageNo, pageSize);
        voPageData.setQueryResult(voList);
        voPageData.setRowCount(pageData.getRowCount());
        return ResponseResult.success(voPageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u8d44\u4ea7\u7ba1\u7406-\u6a21\u5177\u4e3b\u6570\u636e(\u4f9b\u5e94\u5546)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Mould", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPageForSup"})
    @ResponseBody
    public ResponseResult<PageView<Mould>> findByPageForSup(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        MouldExample example = new MouldExample();
        example.setPageView(new PageView<Mould>(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        MouldExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT).andSupCompanyIdEqualTo(CompanyUtils.currentCompanyId());
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        PageView pageData = this.mouldService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u8d44\u4ea7\u7ba1\u7406-\u6a21\u5177\u4e3b\u6570\u636e(\u5206\u53d1\u63a5\u53e3)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Mould", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<Mould>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        if (CompanyUtils.isPurCompany()) {
            return this.findByPageForPur(pageNo, pageSize, wapper);
        }
        return this.findByPageForSup(pageNo, pageSize, wapper);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u7269\u6599")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Material", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findExtMaterialByPage"})
    @ResponseBody
    public ResponseResult<PageView<MouldMaterialExt>> findExtMaterialByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper queryParamWapper) {
        MaterialExample example = new MaterialExample();
        example.setPageView(new PageView<Material>(pageNo, pageSize));
        example.setOrderByClause("MATERIAL_CODE ASC");
        MaterialExample.Criteria criteria = example.createCriteria();
        if (queryParamWapper != null) {
            CriteriaUtils.addCriterion(criteria, queryParamWapper);
        }
        criteria.andIsEnableEqualTo(Constant.YES_INT);
        PageView pageData = this.materialService.queryObjByPage(example);
        List materialList = pageData.getQueryResult();
        ArrayList<MouldMaterialExt> extMaterialList = null;
        if (CollectionUtils.isNotEmpty(materialList)) {
            extMaterialList = new ArrayList<MouldMaterialExt>();
            for (Material material : materialList) {
                MouldMaterialExt mouldMaters = new MouldMaterialExt();
                BeanUtils.copyProperties((Object)material, (Object)mouldMaters);
                MouldMaterialExample materialExample = new MouldMaterialExample();
                materialExample.createCriteria().andMaterialCodeEqualTo(mouldMaters.getMaterialCode());
                List mouldMaterials = this.mouldMaterialService.queryAllObjByExample(materialExample);
                if (CollectionUtils.isEmpty(mouldMaterials)) {
                    mouldMaters.setExistence(Constant.NO_INT);
                } else {
                    ArrayList<String> mouldIds = new ArrayList<String>();
                    for (MouldMaterial mouldMaterial : mouldMaterials) {
                        mouldIds.add(mouldMaterial.getMouldId());
                    }
                    MouldExample examples = new MouldExample();
                    example.createCriteria().andIdIn(mouldIds).andIsEnableEqualTo(Constant.YES_INT);
                    List list = this.mouldService.queryAllObjByExample(examples);
                    if (CollectionUtils.isNotEmpty(list)) {
                        mouldMaters.setExistence(Constant.YES_INT);
                    } else {
                        mouldMaters.setExistence(Constant.NO_INT);
                    }
                }
                extMaterialList.add(mouldMaters);
            }
        }
        PageView<MouldMaterialExt> pageView = new PageView<MouldMaterialExt>(pageNo, pageSize);
        pageView.setQueryResult(extMaterialList);
        pageView.setRowCount(pageData.getRowCount());
        return ResponseResult.success(pageView);
    }

    @ApiOperation(value="excel\u521b\u5efa\u6a21\u5177\u4fe1\u606f", httpMethod="POST")
    @RequestMapping(value={"service/uploadExcelForCreateMould"})
    @ResponseBody
    public ResponseResult<String> uploadExcelForCreateMould(MultipartHttpServletRequest request) {
        Map fileMap = request.getFileMap();
        MultipartFile file = this.vaildFile(fileMap);
        List<TitleAndModelKey> titleAndModelKeys = this.createExcelHeader();
        try {
            List list = ExcelUtils.importExcelDataToMap((InputStream)file.getInputStream(), (int)0, (int)1, (int)0, titleAndModelKeys, Mould.class);
            if (CollectionUtils.isEmpty((Collection)list)) {
                throw new CommonException("\u6ca1\u6709\u6570\u636e,\u65e0\u9700\u5bfc\u5165!");
            }
            this.mouldService.uploadExcelForCreateMould(list, ProjectUtils.getProject(), CompanyUtils.currentCompany());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CommonException("\u5bfc\u5165\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return ResponseResult.success();
    }

    @ApiOperation(value="\u6279\u91cf\u62a5\u5e9f\u6a21\u5177", httpMethod="POST")
    @RequestMapping(value={"service/uploadExcelForScrapMould"})
    @ResponseBody
    public ResponseResult<String> uploadExcelForScrapMould(MultipartHttpServletRequest request) {
        Map fileMap = request.getFileMap();
        MultipartFile file = this.vaildFile(fileMap);
        List<TitleAndModelKey> titleAndModelKeys = this.scrapExcelHeaders();
        try {
            List list = ExcelUtils.importExcelDataToMap((InputStream)file.getInputStream(), (int)0, (int)1, (int)0, titleAndModelKeys, Mould.class);
            if (CollectionUtils.isEmpty((Collection)list)) {
                throw new CommonException("\u6ca1\u6709\u6570\u636e,\u65e0\u9700\u5bfc\u5165!");
            }
            this.mouldService.scrapExcelMoulds(list);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CommonException("\u5bfc\u5165\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return ResponseResult.success();
    }

    private MultipartFile vaildFile(Map<String, MultipartFile> fileMap) {
        if (MapUtils.isEmpty(fileMap)) {
            throw new CommonException("\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a", "file_isNull");
        }
        if (fileMap.size() > 1) {
            throw new CommonException("\u53ea\u63a5\u53d7\u5355\u4e2a\u6587\u4ef6\u5bfc\u5165");
        }
        Set<String> fileKeySet = fileMap.keySet();
        Iterator<String> keyIterator = fileKeySet.iterator();
        MultipartFile file = null;
        while (keyIterator.hasNext()) {
            file = fileMap.get(keyIterator.next());
        }
        return file;
    }

    @ApiOperation(value="\u5bfc\u51fa\u6a21\u5177\u6a21\u677f", httpMethod="POST")
    @RequestMapping(value={"service/downloadMouldTemplet"})
    @ResponseBody
    public ResponseResult<FileData> downloadMouldTemplet(HttpServletResponse response) {
        List<TitleAndModelKey> titleAndModelKeys = this.createExcelHeader();
        FileData excelFile = new FileData();
        try {
            excelFile.setProjectId(ProjectUtils.getProjectId());
            excelFile.setCompanyId(CompanyUtils.currentCompanyId());
            excelFile.setFileName("\u6a21\u5177\u4e3b\u6570\u636e\u6a21\u677f.xls");
            excelFile.setFileSuffix("xls");
            excelFile.setIsEncrypt(String.valueOf(Constant.NO_INT));
            excelFile = FileManagerFactory.getFileManager().write((InputStream)new ByteArrayInputStream("".getBytes("UTF-8")), excelFile);
            FileOutputStream out = new FileOutputStream(excelFile.toFile());
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)out, titleAndModelKeys, null, (String)"\u6a21\u5177\u4e3b\u6570\u636e\u6a21\u677f", (String)"", (int)0);
            writableWorkbook.write();
            out.flush();
            writableWorkbook.close();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CommonException(e.getMessage());
        }
        return ResponseResult.success(excelFile);
    }

    private List<TitleAndModelKey> createExcelHeader() {
        ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6a21\u5177\u4e34\u65f6\u7f16\u7801", (String)"mouldTemporaryCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6a21\u5177\u7f16\u53f7", (String)"mouldCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6a21\u5177\u63cf\u8ff0", (String)"mouldDesc"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6a21\u5177\u72b6\u6001", (String)"itemUnit"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u673a\u578b", (String)"mouldModel"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u9879\u76ee\u7f16\u53f7", (String)"projectNumber"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546SAP\u7f16\u7801", (String)"supCompanySapCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8d44\u4ea7/\u5408\u540c\u7f16\u53f7", (String)"assetContractNumber"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6240\u5c5e\u5e74\u4efd", (String)"belongedYear"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6a21\u5177\u5e8f\u53f7", (String)"mouldSerialNumber"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6a21\u5177\u6750\u6599", (String)"mouldMaterial"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6a21\u5177\u51c0\u4ef7", (String)"mouldNetPrice"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7a0e\u7801", (String)"taxCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6a21\u5177\u7a0e\u4ef7\u5408\u8ba1", (String)"mouldPriceTaxSum"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u9996\u671f\u5360\u6bd4", (String)"firstTermPaymentPercent"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u9996\u671f\u4ed8\u6b3e", (String)"firstTermPaymentAmount"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4e2d\u671f\u5360\u6bd4", (String)"midTermPaymentPercent"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4e2d\u671f\u4ed8\u6b3e", (String)"midTermPaymentAmount"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5c3e\u671f\u5360\u6bd4", (String)"endTermPaymentPercent"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5c3e\u671f\u4ed8\u6b3e", (String)"endTermPaymentAmount"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6a21\u7a74\u5e03\u5c40", (String)"mouldCavernLayout"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6a21\u5177\u5bff\u547d", (String)"mouldLifetime"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6a21\u5177\u5df2\u8017\u5bff\u547d\u6b21\u6570", (String)"mouldConsumedLifetime"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6a21\u5177\u5f53\u524d\u5269\u4f59\u5bff\u547d", (String)"mouldRemainderLifetime"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6a21\u5177\u4ea7\u6743\u72b6\u51b5", (String)"mouldPropertyRightState"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5f00\u6a21\u5f52\u5c5e", (String)"mouldAscription"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5b58\u653e\u5904", (String)"storage"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8d23\u4efb\u4eba", (String)"leadingOfficial"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5236\u9020\u5546", (String)"manufacturer"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5907\u6ce8", (String)"remark"));
        return titleAndModelKeys;
    }

    private List<TitleAndModelKey> scrapExcelHeaders() {
        ArrayList<TitleAndModelKey> scrapModelKey = new ArrayList<TitleAndModelKey>();
        scrapModelKey.add(ExcelUtils.createTitleAndModelKey((String)"\u6a21\u5177\u4e34\u65f6\u7f16\u7801", (String)"mouldTemporaryCode"));
        scrapModelKey.add(ExcelUtils.createTitleAndModelKey((String)"\u6a21\u5177\u7f16\u53f7", (String)"mouldCode"));
        scrapModelKey.add(ExcelUtils.createTitleAndModelKey((String)"\u6a21\u5177\u63cf\u8ff0", (String)"mouldDesc"));
        return scrapModelKey;
    }
}

