CREATE TABLE T_BASE_COMPANY_EXTEND
(
   ID                   VARCHAR(32) NOT null COMMENT '主键ID',
   COMPANY_ID           VARCHAR(32) NOT null COMMENT '企业信息company表ID',
   COMPANY_SAP_CODE		VARCHAR(32) COMMENT '供应商sap编码',
   PURCHASE_ORGANIZATION VARCHAR(10) COMMENT '采购组织',
   PURCHASING_TELEPHONE VARCHAR(13) COMMENT '采购电话',
   INTERNATIONAL_TRADE_CONDITION2 VARCHAR(20) COMMENT '国际贸易条件2',
   DISABLE_SIGN VARCHAR(10) COMMENT '停用标识',
   ABC_IDENTIFICATION VARCHAR(10) COMMENT 'ABC标识',

   SORT_CODE VARCHAR(11) COMMENT '排序码',
   FROZEN_IDENTIFIER VARCHAR(10) COMMENT '冻结标识符',

   DISTANCE_TO_KANGNI VARCHAR(20) COMMENT '距康尼距离',
   BANK_OPEN_ACCCOUT_LICENCE VARCHAR(30) COMMENT '银行开户许可证',
   YEAR_OUT_PUT3 VARCHAR(20) COMMENT '近三年年产量或者产值',
   FINANCIAL_STATEMENTS3 VARCHAR(200) COMMENT '近三年财务报表',
   QUALITY_LEVEL VARCHAR(10) COMMENT '质量水平',
   ACCOUNT_TYPE VARCHAR(20) COMMENT '账户类别（基本账户）',
   BUSI_LICENSE_CHECK_TIME DATE COMMENT '营业执照最新年检时间',
   CONTACTS_FIXED_TEL VARCHAR(15) '联系人固定电话',
   CONTACTS_MOBILE VARCHAR(15) '联系人手机号码',
   CONTACTS_ELEC_MAIL VARCHAR(255) '联系人邮箱',
   ORG_CODE_NEWEST_CHECK_TIME DATE COMMENT '组织机构代码证最新年检时间',
   ORGANIZATION_CODE VARCHAR(10) COMMENT '组织机构代码',
   TAX_REGI_NEWEST_CHECK_TIME DATE COMMENT '税务登记证最新年检时间',
   TAX_REGISTRATION_NO VARCHAR(30) COMMENT '税务登记证号码',
   PRODUCT_LICENCE VARCHAR(100) COMMENT '生产许可证',
   SPECIAL_POST_CERTIFICE VARCHAR(150) COMMENT '特殊岗位人员资质证书',
   REGISTER_ADDRESS VARCHAR(100) COMMENT '注册地址',

   OPEN_ACCOUNT_DATE DATE COMMENT '开户日期',
   OUT_SUPPLIER_INFO VARCHAR(200) COMMENT '外包供方资料',
   MANUFACTURER VARCHAR(30) COMMENT '制造厂家或授权代理',
   COMPANY_RESPONSIBLER_PHONE VARCHAR(13) COMMENT '公司负责人手机号码',
   COMPANY_RESPONSIBLER_NAME VARCHAR(10) COMMENT '公司负责人姓名',
   COMPANY_RESPONSIBLER_NO VARCHAR(10) COMMENT '公司负责人固定电话',
   SUPPLIER_ADDRESS VARCHAR(40) COMMENT '供方地址',
   SUPPLIER_NAME VARCHAR(40) COMMENT '供方名称',
   COMPANY_AUTH_INFO VARCHAR(200) COMMENT '企业认证资料',
   COMPANY_AUTH_SITUATION VARCHAR(100) COMMENT '企业认证情况',
   COMPANY_WIN_INFO VARCHAR(100) COMMENT '企业获奖资料',
   PRODUCT_AUTH_SITUATION VARCHAR(100) COMMENT '产品认证情况',
   MAJOR_PRODUCT_EQUIPMENT_BILL VARCHAR(200) COMMENT '主要生产设备清单',
   MAJOR_CHECKER_BILL VARCHAR(200) COMMENT '主要检验器具和仪器清单',
   MAJOR_CUSTOMER VARCHAR(200) COMMENT '主要客户及业绩',
   BANK_CODE VARCHAR(20) COMMENT '银行码',
   BANK_ACCOUNT_NAME VARCHAR(20) COMMENT '银行户主',
   OLD_COMPANY_SAP_CODE VARCHAR(15) COMMENT '旧供应商编码（金思维ERP老编码）',
   POST_CODE VARCHAR(12) COMMENT '邮编',
   TRADE_PARTNER VARCHAR(20) COMMENT '贸易伙伴',
   LANGUAGE VARCHAR(10) COMMENT '语言',
   RATEPAYER_NO VARCHAR(20) COMMENT '纳税人登记号',
   TELEPHONE_EXTEN VARCHAR(12) COMMENT '电话分机号',
   SEARCH_CONDITION VARCHAR(20) COMMENT '搜索条件',
   FAX_EXTEN_NO VARCHAR(20) COMMENT '传真分机号',
   PURCHASE_GROUP2000 VARCHAR(10) COMMENT '2000采购组织',
   COMPANY2000 VARCHAR(20) COMMENT '2000公司',
   BASE_VIEW_PROPOSER VARCHAR(10) COMMENT '供应商维护申请人(基本视图申请人工号)',
   BANK_COUNTRY VARCHAR(50) COMMENT '银行所在国家',
   
   UPDATE_TIME DATE COMMENT '更新时间',
   CREATE_TIME DATE COMMENT '创建时间',
  
   PRIMARY KEY (ID)
);

ALTER TABLE T_BASE_COMPANY_EXTEND COMMENT '企业信息扩展表';