ALTER TABLE `T_BASE_MOULD`
ADD COLUMN `MOULD_QUANTITY` decimal(20, 2) NULL COMMENT '模具数量' ,
ADD COLUMN `STORAGE_LOCATION_CODE` varchar(255) NULL COMMENT '存储地点，库存地点编码' ,
ADD COLUMN `STORAGE_LOCATION_DESC` varchar(255) NULL COMMENT '存储地点，库存地点描述' ,
ADD COLUMN `STORAGE_DATE` datetime(0) NULL COMMENT '入库时间' ,
ADD COLUMN `RECEIVING_DATE` datetime(0) NULL COMMENT '领用日期' ,
ADD COLUMN `PRODUCED_DATE` datetime(0) NULL COMMENT '生产日期' ,
ADD COLUMN `RECIPIENTS_DEPARTMENT` varchar(255) NULL COMMENT '领用部门' ,
ADD COLUMN `RECEIVING_COMPANY` varchar(255) NULL COMMENT '领用供应商（单位 )' ,
ADD COLUMN `PRODUCTION_QUANTITY` varchar(255) NULL COMMENT '投入生产数量' ,
ADD COLUMN `PRODUCTION_DRAWING_NUMBER` varchar(255) NULL COMMENT '投入生产图号' ,
ADD COLUMN `MOULD_WORTH` varchar(255) NULL COMMENT '模具价值' ,
ADD COLUMN `MOULD_SAP_STATUS` varchar(255) NULL COMMENT '模具sap状态',
ADD COLUMN `MOULD_MATERIAL_CODE` varchar(255) NULL COMMENT '模具物料编码';



INSERT INTO `T_BASE_GENERATE_CODE`(`ID`, `NAME`, `TARGET_CODE`, `STRATEGY`, `PREFIX`, `SUFFIX`, `CURRENT_CODE`, `START_CODE`, `MAX_CODE`, `CREATE_TIME`, `UPDATE_TIME`) VALUES ('20180129113026-followno', '资产管理开模/变更通知单号', 'FOLLOW_NO', 'com.els.base.codegenerator.service.impl.DateIncrementStrategy', 'FO', NULL, '201808140000002', '1', NULL, '2018-01-29 10:15:05.000000', '2018-01-29 10:15:05.000000');


ALTER TABLE `T_BASE_FOLLOW_PLAN`
ADD COLUMN `PRODUCT_TYPE` varchar(255) NULL COMMENT '产品类型（订单=0，模具=1）' ,
ADD COLUMN `PRODUCT_TYPE_DESC` varchar(255) NULL COMMENT '产品类型描述',
ADD COLUMN `UPDATE_TIME` datetime(0) NULL COMMENT '更新时间';


DROP TABLE IF EXISTS `T_BASE_FOLLOW_PLAN_TEMPLATE`;
CREATE TABLE `T_BASE_FOLLOW_PLAN_TEMPLATE`  (
  `ID` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '主键',
  `PRODUCT_NAME` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '产品名称',
  `PRODUCT_DESC` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '产品描述',
  `PRODUCT_ATTACHMENT` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '产品附件',
  `PLANN_START_TIME` datetime(0) NULL DEFAULT NULL COMMENT '计划开始时间',
  `PLANN_END_TIME` datetime(0) NULL DEFAULT NULL COMMENT '计划结束时间',
  `ACTUAL_START_TIME` datetime(0) NULL DEFAULT NULL COMMENT '实际开始时间',
  `ACTUAL_END_TIME` datetime(0) NULL DEFAULT NULL COMMENT '实际结束时间',
  `SPEND_TIME` decimal(20, 2) NULL DEFAULT NULL COMMENT '花费时间',
  `SORT_NO` int(11) NULL DEFAULT NULL COMMENT '排序',
  `CREATE_TIME` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `PRODUCT_TYPE` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '产品类型（订单=0，模具=1）',
  `PRODUCT_TYPE_DESC` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '产品类型描述',
  `UPDATE_TIME` datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '计划跟踪表模板';