package com.els.base.bidding.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.els.base.bidding.utils.BiddingContentDeSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

@JsonDeserialize(using=BiddingContentDeSerializer.class)
@ApiModel(value = "招标内容")
public class BiddingContent implements Serializable {
    @ApiModelProperty("id")
    private String id;

    @ApiModelProperty("项目id")
    private String projectId;

    @ApiModelProperty("企业id")
    private String purCompanyId;

    @ApiModelProperty("企业名称")
    private String purCompanyName;

    @ApiModelProperty("公司srm代码")
    private String purCompanySrmCode;

    @ApiModelProperty("公司sap代码")
    private String purCompanySapCode;

    @ApiModelProperty("采购员id")
    private String purUserId;

    @ApiModelProperty("采购员名称")
    private String purUserName;

    @ApiModelProperty("供应商companyid")
    private String supCompanyId;

    @ApiModelProperty("供应商公司名称")
    private String supCompanyName;

    @ApiModelProperty("供应商srm代码")
    private String supCompanySrmCode;

    @ApiModelProperty("供应商sap代码")
    private String supCompanySapCode;

    @ApiModelProperty("供应商用户id")
    private String supUserId;

    @ApiModelProperty("供应商用户名称")
    private String supUserName;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("最后更新时间")
    private Date lastUpdateTime;

    @ApiModelProperty("最后修改人")
    private String lastUpdateUser;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("招标编号")
    private String biddingNo;

    @ApiModelProperty("招标内容概述")
    private String summary;

    @ApiModelProperty("交付起始日期")
    private Date deliveryStartTime;

    @ApiModelProperty("交付结束日期")
    private Date deliveryEndTime;

    @ApiModelProperty("交付地点")
    private String deliveryAddress;

    @ApiModelProperty("质量要求")
    private String quality;

    @ApiModelProperty("0：必须全部投标、1：可以部分投标")
    private String allBidding;

    @ApiModelProperty("每轮报价有效次数")
    private Integer effectiveNumber;

	@ApiModelProperty("评标说明(针对一个招标单一个)")
    private String bidExplain;
	
    public Integer getEffectiveNumber() {
        return effectiveNumber;
    }

    public void setEffectiveNumber(Integer effectiveNumber) {
        this.effectiveNumber = effectiveNumber;
    }

    private List<BiddingContentMatter> biddingContentMatterList = new ArrayList<BiddingContentMatter>();

    private List<BiddingContentModel> biddingContentModelList = new ArrayList<BiddingContentModel>();

    private List<BiddingContentOther> biddingContentOtherList = new ArrayList<BiddingContentOther>();

    // 物料
    private List<BiddingOffer> biddingOfferMatterList = new ArrayList<BiddingOffer>();

    private BiddingOffer biddingOfferMatter = new BiddingOffer();

    // 模具
    private List<BiddingOffer> biddingOfferModelList = new ArrayList<BiddingOffer>();

    private BiddingOffer biddingOfferMode = new BiddingOffer();

    // 其他
    private List<BiddingOffer> biddingOfferOtherList = new ArrayList<BiddingOffer>();

    private BiddingOffer biddingOfferOther = new BiddingOffer();

    public BiddingOffer getBiddingOfferMatter() {
        return biddingOfferMatter;
    }

    public void setBiddingOfferMatter(BiddingOffer biddingOfferMatter) {
        this.biddingOfferMatter = biddingOfferMatter;
    }

    public BiddingOffer getBiddingOfferMode() {
        return biddingOfferMode;
    }

    public void setBiddingOfferMode(BiddingOffer biddingOfferMode) {
        this.biddingOfferMode = biddingOfferMode;
    }

    public BiddingOffer getBiddingOfferOther() {
        return biddingOfferOther;
    }

    public void setBiddingOfferOther(BiddingOffer biddingOfferOther) {
        this.biddingOfferOther = biddingOfferOther;
    }

    public List<BiddingContentMatter> getBiddingContentMatterList() {
        return biddingContentMatterList;
    }

    public void setBiddingContentMatterList(List<BiddingContentMatter> biddingContentMatterList) {
        this.biddingContentMatterList = biddingContentMatterList;
    }

    public List<BiddingContentModel> getBiddingContentModelList() {
        return biddingContentModelList;
    }

    public void setBiddingContentModelList(List<BiddingContentModel> biddingContentModelList) {
        this.biddingContentModelList = biddingContentModelList;
    }

    public List<BiddingContentOther> getBiddingContentOtherList() {
        return biddingContentOtherList;
    }

    public void setBiddingContentOtherList(List<BiddingContentOther> biddingContentOtherList) {
        this.biddingContentOtherList = biddingContentOtherList;
    }

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId == null ? null : projectId.trim();
    }

    public String getPurCompanyId() {
        return purCompanyId;
    }

    public void setPurCompanyId(String purCompanyId) {
        this.purCompanyId = purCompanyId == null ? null : purCompanyId.trim();
    }

    public String getPurCompanyName() {
        return purCompanyName;
    }

    public void setPurCompanyName(String purCompanyName) {
        this.purCompanyName = purCompanyName == null ? null : purCompanyName.trim();
    }

    public String getPurCompanySrmCode() {
        return purCompanySrmCode;
    }

    public void setPurCompanySrmCode(String purCompanySrmCode) {
        this.purCompanySrmCode = purCompanySrmCode == null ? null : purCompanySrmCode.trim();
    }

    public String getPurCompanySapCode() {
        return purCompanySapCode;
    }

    public void setPurCompanySapCode(String purCompanySapCode) {
        this.purCompanySapCode = purCompanySapCode == null ? null : purCompanySapCode.trim();
    }

    public String getPurUserId() {
        return purUserId;
    }

    public void setPurUserId(String purUserId) {
        this.purUserId = purUserId == null ? null : purUserId.trim();
    }

    public String getPurUserName() {
        return purUserName;
    }

    public void setPurUserName(String purUserName) {
        this.purUserName = purUserName == null ? null : purUserName.trim();
    }

    public String getSupCompanyId() {
        return supCompanyId;
    }

    public void setSupCompanyId(String supCompanyId) {
        this.supCompanyId = supCompanyId == null ? null : supCompanyId.trim();
    }

    public String getSupCompanyName() {
        return supCompanyName;
    }

    public void setSupCompanyName(String supCompanyName) {
        this.supCompanyName = supCompanyName == null ? null : supCompanyName.trim();
    }

    public String getSupCompanySrmCode() {
        return supCompanySrmCode;
    }

    public void setSupCompanySrmCode(String supCompanySrmCode) {
        this.supCompanySrmCode = supCompanySrmCode == null ? null : supCompanySrmCode.trim();
    }

    public String getSupCompanySapCode() {
        return supCompanySapCode;
    }

    public void setSupCompanySapCode(String supCompanySapCode) {
        this.supCompanySapCode = supCompanySapCode == null ? null : supCompanySapCode.trim();
    }

    public String getSupUserId() {
        return supUserId;
    }

    public void setSupUserId(String supUserId) {
        this.supUserId = supUserId == null ? null : supUserId.trim();
    }

    public String getSupUserName() {
        return supUserName;
    }

    public void setSupUserName(String supUserName) {
        this.supUserName = supUserName == null ? null : supUserName.trim();
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getLastUpdateTime() {
        return lastUpdateTime;
    }

    public void setLastUpdateTime(Date lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public String getLastUpdateUser() {
        return lastUpdateUser;
    }

    public void setLastUpdateUser(String lastUpdateUser) {
        this.lastUpdateUser = lastUpdateUser == null ? null : lastUpdateUser.trim();
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark == null ? null : remark.trim();
    }

    public String getBiddingNo() {
        return biddingNo;
    }

    public void setBiddingNo(String biddingNo) {
        this.biddingNo = biddingNo == null ? null : biddingNo.trim();
    }

    public String getSummary() {
        return summary;
    }

    public void setSummary(String summary) {
        this.summary = summary == null ? null : summary.trim();
    }

    public Date getDeliveryStartTime() {
        return deliveryStartTime;
    }

    public void setDeliveryStartTime(Date deliveryStartTime) {
        this.deliveryStartTime = deliveryStartTime;
    }

    public Date getDeliveryEndTime() {
        return deliveryEndTime;
    }

    public void setDeliveryEndTime(Date deliveryEndTime) {
        this.deliveryEndTime = deliveryEndTime;
    }

    public String getDeliveryAddress() {
        return deliveryAddress;
    }

    public void setDeliveryAddress(String deliveryAddress) {
        this.deliveryAddress = deliveryAddress == null ? null : deliveryAddress.trim();
    }

    public String getQuality() {
        return quality;
    }

    public void setQuality(String quality) {
        this.quality = quality == null ? null : quality.trim();
    }

    public String getAllBidding() {
        return allBidding;
    }

    public void setAllBidding(String allBidding) {
        this.allBidding = allBidding == null ? null : allBidding.trim();
    }

    public List<BiddingOffer> getBiddingOfferMatterList() {
        return biddingOfferMatterList;
    }

    public void setBiddingOfferMatterList(List<BiddingOffer> biddingOfferMatterList) {
        this.biddingOfferMatterList = biddingOfferMatterList;
    }

    public List<BiddingOffer> getBiddingOfferModelList() {
        return biddingOfferModelList;
    }

    public void setBiddingOfferModelList(List<BiddingOffer> biddingOfferModelList) {
        this.biddingOfferModelList = biddingOfferModelList;
    }

    public List<BiddingOffer> getBiddingOfferOtherList() {
        return biddingOfferOtherList;
    }

    public void setBiddingOfferOtherList(List<BiddingOffer> biddingOfferOtherList) {
        this.biddingOfferOtherList = biddingOfferOtherList;
    }

    public String getBidExplain() {
        return bidExplain;
    }
	
	public void setBidExplain(String bidExplain) {
        this.bidExplain = bidExplain == null ? null : bidExplain.trim();
    }
}