package com.els.base.bidding.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import com.els.base.file.utils.UploadSupportJsonDeserializer;
import com.els.base.file.utils.UploadSupportJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

@ApiModel(value = "物料类招标")
public class BiddingContentMatter implements Serializable {
    @ApiModelProperty("id")
    private String id;

    @ApiModelProperty("项目id")
    private String projectId;

    @ApiModelProperty("企业id")
    private String purCompanyId;

    @ApiModelProperty("企业名称")
    private String purCompanyName;

    @ApiModelProperty("公司srm代码")
    private String purCompanySrmCode;

    @ApiModelProperty("公司sap代码")
    private String purCompanySapCode;

    @ApiModelProperty("采购员id")
    private String purUserId;

    @ApiModelProperty("采购员名称")
    private String purUserName;

    @ApiModelProperty("供应商companyid")
    private String supCompanyId;

    @ApiModelProperty("供应商公司名称")
    private String supCompanyName;

    @ApiModelProperty("供应商srm代码")
    private String supCompanySrmCode;

    @ApiModelProperty("供应商sap代码")
    private String supCompanySapCode;

    @ApiModelProperty("供应商用户id")
    private String supUserId;

    @ApiModelProperty("供应商用户名称")
    private String supUserName;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("最后更新时间")
    private Date lastUpdateTime;

    @ApiModelProperty("最后修改人")
    private String lastUpdateUser;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("招标编号")
    private String biddingNo;

    @ApiModelProperty("招标单ID")
    private String biddingHeaderId;
    
    @ApiModelProperty("价格单位")
    private Integer priceUnit;

    @JsonSerialize(using = UploadSupportJsonSerializer.class)
    @JsonDeserialize(using = UploadSupportJsonDeserializer.class)
    @ApiModelProperty("图片附件")
    private String pictureAttachment;

    @JsonSerialize(using = UploadSupportJsonSerializer.class)
    @JsonDeserialize(using = UploadSupportJsonDeserializer.class)
    @ApiModelProperty("方案、设计图纸")
    private String designPicAttachment;

    @ApiModelProperty("物料编号")
    private String materialNo;

    @ApiModelProperty("名称描述")
    private String materialDesc;

    @ApiModelProperty("物料名称")
    private String materialName;

    @ApiModelProperty("物料品牌")
    private String materialFeatures;

    @ApiModelProperty("规格")
    private String materialSpec;

    @ApiModelProperty("型号")
    private String materialModel;

    @ApiModelProperty("单位")
    private String unit;

    @ApiModelProperty("招标数量")
    private Long biddingQuantity;

    @ApiModelProperty("币种")
    private String currency;

    @ApiModelProperty("用量")
    private Long dosage;

    @ApiModelProperty("目标单价（不含税单价）")
    private BigDecimal unitPrice;

    @ApiModelProperty("目标套价(不含税套价)")
    private BigDecimal setThePrice;

    @ApiModelProperty("必须全部投标 0:否 1:是")
    private String mostAllBidding;

    @ApiModelProperty("招标内容主表ID")
    private String biddingContentId;

    @ApiModelProperty("上一轮报价")
    private BigDecimal lastQuote;

    private String biddingContentItemNo;

    @ApiModelProperty("报价方式 2:阶梯报价,1:常规报价")
    private String quotationMethod;

    @ApiModelProperty("是否阶梯报价")
    private String isStep;

    @ApiModelProperty("0：必须全部投标、1：可以部分投标")
    private String allBidding;

    private String isHidePrice;// 是否隐藏价格 0:否 1:是



    @ApiModelProperty("临时物料编号：招标单号+序号")
	private String tempMaterialNo;
	
	@ApiModelProperty("物料成本分析清单ID")
	private String costAnalysisId;
		
	public String getTempMaterialNo() {
        return tempMaterialNo;
    }

    public void setTempMaterialNo(String tempMaterialNo) {
        this.tempMaterialNo = tempMaterialNo == null ? null : tempMaterialNo.trim();
    }
	
		
    public String getIsHidePrice() {
        return isHidePrice;
    }

    public void setIsHidePrice(String isHidePrice) {
        this.isHidePrice = isHidePrice;
    }

    public String getAllBidding() {
        return allBidding;
    }

    public void setAllBidding(String allBidding) {
        this.allBidding = allBidding;
    }

    private List<BiddingMatterStep> biddingMatterStepList;

    public List<BiddingMatterStep> getBiddingMatterStepList() {
        return biddingMatterStepList;
    }

    public void setBiddingMatterStepList(List<BiddingMatterStep> biddingMatterStepList) {
        this.biddingMatterStepList = biddingMatterStepList;
    }

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId == null ? null : projectId.trim();
    }

    public String getPurCompanyId() {
        return purCompanyId;
    }

    public void setPurCompanyId(String purCompanyId) {
        this.purCompanyId = purCompanyId == null ? null : purCompanyId.trim();
    }

    public String getPurCompanyName() {
        return purCompanyName;
    }

    public void setPurCompanyName(String purCompanyName) {
        this.purCompanyName = purCompanyName == null ? null : purCompanyName.trim();
    }

    public String getPurCompanySrmCode() {
        return purCompanySrmCode;
    }

    public void setPurCompanySrmCode(String purCompanySrmCode) {
        this.purCompanySrmCode = purCompanySrmCode == null ? null : purCompanySrmCode.trim();
    }

    public String getPurCompanySapCode() {
        return purCompanySapCode;
    }

    public void setPurCompanySapCode(String purCompanySapCode) {
        this.purCompanySapCode = purCompanySapCode == null ? null : purCompanySapCode.trim();
    }

    public String getPurUserId() {
        return purUserId;
    }

    public void setPurUserId(String purUserId) {
        this.purUserId = purUserId == null ? null : purUserId.trim();
    }

    public String getPurUserName() {
        return purUserName;
    }

    public void setPurUserName(String purUserName) {
        this.purUserName = purUserName == null ? null : purUserName.trim();
    }

    public String getSupCompanyId() {
        return supCompanyId;
    }

    public void setSupCompanyId(String supCompanyId) {
        this.supCompanyId = supCompanyId == null ? null : supCompanyId.trim();
    }

    public String getSupCompanyName() {
        return supCompanyName;
    }

    public void setSupCompanyName(String supCompanyName) {
        this.supCompanyName = supCompanyName == null ? null : supCompanyName.trim();
    }

    public String getSupCompanySrmCode() {
        return supCompanySrmCode;
    }

    public void setSupCompanySrmCode(String supCompanySrmCode) {
        this.supCompanySrmCode = supCompanySrmCode == null ? null : supCompanySrmCode.trim();
    }

    public String getSupCompanySapCode() {
        return supCompanySapCode;
    }

    public void setSupCompanySapCode(String supCompanySapCode) {
        this.supCompanySapCode = supCompanySapCode == null ? null : supCompanySapCode.trim();
    }

    public String getSupUserId() {
        return supUserId;
    }

    public void setSupUserId(String supUserId) {
        this.supUserId = supUserId == null ? null : supUserId.trim();
    }

    public String getSupUserName() {
        return supUserName;
    }

    public void setSupUserName(String supUserName) {
        this.supUserName = supUserName == null ? null : supUserName.trim();
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getLastUpdateTime() {
        return lastUpdateTime;
    }

    public void setLastUpdateTime(Date lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public String getLastUpdateUser() {
        return lastUpdateUser;
    }

    public void setLastUpdateUser(String lastUpdateUser) {
        this.lastUpdateUser = lastUpdateUser == null ? null : lastUpdateUser.trim();
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark == null ? null : remark.trim();
    }

    public String getBiddingNo() {
        return biddingNo;
    }

    public void setBiddingNo(String biddingNo) {
        this.biddingNo = biddingNo == null ? null : biddingNo.trim();
    }

    public String getBiddingHeaderId() {
        return biddingHeaderId;
    }

    public void setBiddingHeaderId(String biddingHeaderId) {
        this.biddingHeaderId = biddingHeaderId == null ? null : biddingHeaderId.trim();
    }

    public String getPictureAttachment() {
        return pictureAttachment;
    }

    public void setPictureAttachment(String pictureAttachment) {
        this.pictureAttachment = pictureAttachment == null ? null : pictureAttachment.trim();
    }

    public String getDesignPicAttachment() {
        return designPicAttachment;
    }

    public void setDesignPicAttachment(String designPicAttachment) {
        this.designPicAttachment = designPicAttachment == null ? null : designPicAttachment.trim();
    }

    public String getMaterialNo() {
        return materialNo;
    }

    public void setMaterialNo(String materialNo) {
        this.materialNo = materialNo == null ? null : materialNo.trim();
    }

    public String getMaterialDesc() {
        return materialDesc;
    }

    public void setMaterialDesc(String materialDesc) {
        this.materialDesc = materialDesc == null ? null : materialDesc.trim();
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName == null ? null : materialName.trim();
    }

    public String getMaterialFeatures() {
        return materialFeatures;
    }

    public void setMaterialFeatures(String materialFeatures) {
        this.materialFeatures = materialFeatures == null ? null : materialFeatures.trim();
    }

    public String getMaterialSpec() {
        return materialSpec;
    }

    public void setMaterialSpec(String materialSpec) {
        this.materialSpec = materialSpec == null ? null : materialSpec.trim();
    }

    public String getMaterialModel() {
        return materialModel;
    }

    public void setMaterialModel(String materialModel) {
        this.materialModel = materialModel == null ? null : materialModel.trim();
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit == null ? null : unit.trim();
    }

    public Long getBiddingQuantity() {
        return biddingQuantity;
    }

    public void setBiddingQuantity(Long biddingQuantity) {
        this.biddingQuantity = biddingQuantity;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency == null ? null : currency.trim();
    }

    public Long getDosage() {
        return dosage;
    }

    public void setDosage(Long dosage) {
        this.dosage = dosage;
    }

    public BigDecimal getUnitPrice() {
        return unitPrice;
    }

    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
    }

    public BigDecimal getSetThePrice() {
        return setThePrice;
    }

    public void setSetThePrice(BigDecimal setThePrice) {
        this.setThePrice = setThePrice;
    }

    public String getMostAllBidding() {
        return mostAllBidding;
    }

    public void setMostAllBidding(String mostAllBidding) {
        this.mostAllBidding = mostAllBidding == null ? null : mostAllBidding.trim();
    }

    public String getBiddingContentId() {
        return biddingContentId;
    }

    public void setBiddingContentId(String biddingContentId) {
        this.biddingContentId = biddingContentId == null ? null : biddingContentId.trim();
    }

    public BigDecimal getLastQuote() {
        return lastQuote;
    }

    public void setLastQuote(BigDecimal lastQuote) {
        this.lastQuote = lastQuote;
    }

    public String getBiddingContentItemNo() {
        return biddingContentItemNo;
    }

    public void setBiddingContentItemNo(String biddingContentItemNo) {
        this.biddingContentItemNo = biddingContentItemNo == null ? null : biddingContentItemNo.trim();
    }

    public String getQuotationMethod() {
        return quotationMethod;
    }

    public void setQuotationMethod(String quotationMethod) {
        this.quotationMethod = quotationMethod == null ? null : quotationMethod.trim();
    }

    public String getIsStep() {
        return isStep;
    }

    public void setIsStep(String isStep) {
        this.isStep = isStep == null ? null : isStep.trim();
    }
    public String getCostAnalysisId() {
        return costAnalysisId;
    }

    public void setCostAnalysisId(String costAnalysisId) {
        this.costAnalysisId = costAnalysisId == null ? null : costAnalysisId.trim();
    }

	public Integer getPriceUnit() {
		return priceUnit;
	}

	public void setPriceUnit(Integer priceUnit) {
		this.priceUnit = priceUnit;
	}
    
}