package com.els.base.bidding.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;

@ApiModel(value="招投标-基本信息")
public class BiddingHeader implements Serializable {
    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("采购员公司ID")
    private String purCompanyId;

    @ApiModelProperty("客户编号")
    private String purCompanyCode;

    @ApiModelProperty("客户名称")
    private String purCompanyName;

    @ApiModelProperty("采购员ID")
    private String purUserId;

    @ApiModelProperty("采购负责人")
    private String purUserName;

    @ApiModelProperty("招标编号")
    private String biddingNo;

    @ApiModelProperty("招标名称")
    private String biddingName;

    @ApiModelProperty("项目编号")
    private String biddingProjectNumber;

    @ApiModelProperty("招标类型： 0：邀请招标，1：公开招标，2：在线竞价")
    private String biddingType;

    @ApiModelProperty("招标状态")
    private String biddingStatus;

    @ApiModelProperty("预算金额")
    private String biddingAmount;

    @ApiModelProperty("结算货币")
    private String biddingCurrency;

    @ApiModelProperty("资金来源")
    private String biddingFundsource;

    @ApiModelProperty("概况与范围")
    private String biddingSummary;

    @ApiModelProperty("当前轮数")
    private String biddingCurrentRound;

    @ApiModelProperty("招标总轮数")
    private String biddingTotalRound;

    @ApiModelProperty("负责人")
    private String biddingPrincipal;

    @ApiModelProperty("开始日期")
    private Date biddingBegindate;

    @ApiModelProperty("结束日期")
    private Date biddingEnddate;

    //0-尚未审批，1-正在审批，2-审批通过，3-已驳回
    @ApiModelProperty("定标审批状态,2-审批通过，0-未审批，1-审批中，3-审批拒绝")
    private String biddingAuditstatus;

    @ApiModelProperty("发送前审批状态,2-审批通过，0-未审批，1-审批中，3-审批拒绝")
    private String biddingPreAuditstatus;

    @ApiModelProperty("备注")
    private String biddingRemark;

    @ApiModelProperty("定标(目标价)发送投标方:0、不发送  1、只发送中标方")
    private String biddingSendBidder;

    @ApiModelProperty("附件")
    private String biddingFile;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("最后更新时间")
    private Date lastUpdateTime;

    @ApiModelProperty("最后修改人")
    private String lastUpdateUser;

    @ApiModelProperty("发布日期")
    private Date publishDate;

    @ApiModelProperty("应标截止时间")
    private Date biddingDeadline;

    @ApiModelProperty("开标日期")
    private Date biddingOpenDate;
    
    @ApiModelProperty("评标提交时间")
    private Date bidSubmitDate;
    
    @ApiModelProperty("信息类别")
    private String informationCategory;

    @ApiModelProperty("采购组")
    private String purchasingGroup;

    @ApiModelProperty("采购组织")
    private String purchaseOrganization;
    
    private BiddingPower biddingPower;

    public Date getBidSubmitDate() {
        return bidSubmitDate;
    }

    public void setBidSubmitDate(Date bidSubmitDate) {
        this.bidSubmitDate = bidSubmitDate;
    }

    public BiddingPower getBiddingPower() {
        return biddingPower;
    }

    public void setBiddingPower(BiddingPower biddingPower) {
        this.biddingPower = biddingPower;
    }

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getPurCompanyId() {
        return purCompanyId;
    }

    public void setPurCompanyId(String purCompanyId) {
        this.purCompanyId = purCompanyId == null ? null : purCompanyId.trim();
    }

    public String getPurCompanyCode() {
        return purCompanyCode;
    }

    public void setPurCompanyCode(String purCompanyCode) {
        this.purCompanyCode = purCompanyCode == null ? null : purCompanyCode.trim();
    }

    public String getPurCompanyName() {
        return purCompanyName;
    }

    public void setPurCompanyName(String purCompanyName) {
        this.purCompanyName = purCompanyName == null ? null : purCompanyName.trim();
    }

    public String getPurUserId() {
        return purUserId;
    }

    public void setPurUserId(String purUserId) {
        this.purUserId = purUserId == null ? null : purUserId.trim();
    }

    public String getPurUserName() {
        return purUserName;
    }

    public void setPurUserName(String purUserName) {
        this.purUserName = purUserName == null ? null : purUserName.trim();
    }

    public String getBiddingNo() {
        return biddingNo;
    }

    public void setBiddingNo(String biddingNo) {
        this.biddingNo = biddingNo == null ? null : biddingNo.trim();
    }

    public String getBiddingName() {
        return biddingName;
    }

    public void setBiddingName(String biddingName) {
        this.biddingName = biddingName == null ? null : biddingName.trim();
    }

    public String getBiddingProjectNumber() {
        return biddingProjectNumber;
    }

    public void setBiddingProjectNumber(String biddingProjectNumber) {
        this.biddingProjectNumber = biddingProjectNumber == null ? null : biddingProjectNumber.trim();
    }

    public String getBiddingType() {
        return biddingType;
    }

    public void setBiddingType(String biddingType) {
        this.biddingType = biddingType == null ? null : biddingType.trim();
    }

    public String getBiddingStatus() {
        return biddingStatus;
    }

    public void setBiddingStatus(String biddingStatus) {
        this.biddingStatus = biddingStatus == null ? null : biddingStatus.trim();
    }

    public String getBiddingAmount() {
        return biddingAmount;
    }

    public void setBiddingAmount(String biddingAmount) {
        this.biddingAmount = biddingAmount == null ? null : biddingAmount.trim();
    }

    public String getBiddingCurrency() {
        return biddingCurrency;
    }

    public void setBiddingCurrency(String biddingCurrency) {
        this.biddingCurrency = biddingCurrency == null ? null : biddingCurrency.trim();
    }

    public String getBiddingFundsource() {
        return biddingFundsource;
    }

    public void setBiddingFundsource(String biddingFundsource) {
        this.biddingFundsource = biddingFundsource == null ? null : biddingFundsource.trim();
    }

    public String getBiddingSummary() {
        return biddingSummary;
    }

    public void setBiddingSummary(String biddingSummary) {
        this.biddingSummary = biddingSummary == null ? null : biddingSummary.trim();
    }

    public String getBiddingCurrentRound() {
        return biddingCurrentRound;
    }

    public void setBiddingCurrentRound(String biddingCurrentRound) {
        this.biddingCurrentRound = biddingCurrentRound == null ? null : biddingCurrentRound.trim();
    }

    public String getBiddingTotalRound() {
        return biddingTotalRound;
    }

    public void setBiddingTotalRound(String biddingTotalRound) {
        this.biddingTotalRound = biddingTotalRound == null ? null : biddingTotalRound.trim();
    }

    public String getBiddingPrincipal() {
        return biddingPrincipal;
    }

    public void setBiddingPrincipal(String biddingPrincipal) {
        this.biddingPrincipal = biddingPrincipal == null ? null : biddingPrincipal.trim();
    }

    public Date getBiddingBegindate() {
        return biddingBegindate;
    }

    public void setBiddingBegindate(Date biddingBegindate) {
        this.biddingBegindate = biddingBegindate;
    }

    public Date getBiddingEnddate() {
        return biddingEnddate;
    }

    public void setBiddingEnddate(Date biddingEnddate) {
        this.biddingEnddate = biddingEnddate;
    }

    public String getBiddingAuditstatus() {
        return biddingAuditstatus;
    }

    public void setBiddingAuditstatus(String biddingAuditstatus) {
        this.biddingAuditstatus = biddingAuditstatus == null ? null : biddingAuditstatus.trim();
    }

    public String getBiddingPreAuditstatus() {
        return biddingPreAuditstatus;
    }

    public void setBiddingPreAuditstatus(String biddingPreAuditstatus) {
        this.biddingPreAuditstatus = biddingPreAuditstatus == null ? null : biddingPreAuditstatus.trim();
    }

    public String getBiddingRemark() {
        return biddingRemark;
    }

    public void setBiddingRemark(String biddingRemark) {
        this.biddingRemark = biddingRemark == null ? null : biddingRemark.trim();
    }

    public String getBiddingSendBidder() {
        return biddingSendBidder;
    }

    public void setBiddingSendBidder(String biddingSendBidder) {
        this.biddingSendBidder = biddingSendBidder == null ? null : biddingSendBidder.trim();
    }

    public String getBiddingFile() {
        return biddingFile;
    }

    public void setBiddingFile(String biddingFile) {
        this.biddingFile = biddingFile == null ? null : biddingFile.trim();
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getLastUpdateTime() {
        return lastUpdateTime;
    }

    public void setLastUpdateTime(Date lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public String getLastUpdateUser() {
        return lastUpdateUser;
    }

    public void setLastUpdateUser(String lastUpdateUser) {
        this.lastUpdateUser = lastUpdateUser == null ? null : lastUpdateUser.trim();
    }

    public Date getPublishDate() {
        return publishDate;
    }

    public void setPublishDate(Date publishDate) {
        this.publishDate = publishDate;
    }

    public Date getBiddingDeadline() {
        return biddingDeadline;
    }

    public void setBiddingDeadline(Date biddingDeadline) {
        this.biddingDeadline = biddingDeadline;
    }

    public Date getBiddingOpenDate() {
        return biddingOpenDate;
    }

    public void setBiddingOpenDate(Date biddingOpenDate) {
        this.biddingOpenDate = biddingOpenDate;
    }
    
    public String getInformationCategory() {
        return informationCategory;
    }

    public void setInformationCategory(String informationCategory) {
        this.informationCategory = informationCategory == null ? null : informationCategory.trim();
    }

    public String getPurchasingGroup() {
        return purchasingGroup;
    }

    public void setPurchasingGroup(String purchasingGroup) {
        this.purchasingGroup = purchasingGroup == null ? null : purchasingGroup.trim();
    }

    public String getPurchaseOrganization() {
        return purchaseOrganization;
    }

    public void setPurchaseOrganization(String purchaseOrganization) {
        this.purchaseOrganization = purchaseOrganization == null ? null : purchaseOrganization.trim();
    }
}