package com.els.base.bidding.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import com.els.base.file.utils.UploadSupportJsonDeserializer;
import com.els.base.file.utils.UploadSupportJsonSerializer;
import com.els.base.inquiry.IMouldDetail;
import com.els.base.inquiry.IOrderItemDetail;
import com.els.base.inquiry.entity.InquirySupOrder;
import com.els.base.inquiry.utils.json.DetailSerialzer;
import com.els.base.inquiry.utils.json.OrderItemJsonDeSerialzer;
import com.els.base.inquiry.utils.json.SupOrderJsonDeserialzer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

@ApiModel(value = "供应商报价")
public class BiddingOffer implements Serializable {
    @ApiModelProperty("id")
    private String id;

    @ApiModelProperty("企业id")
    private String purCompanyId;

    @ApiModelProperty("企业名称")
    private String purCompanyName;

    @ApiModelProperty("公司srm代码")
    private String purCompanySrmCode;

    @ApiModelProperty("公司sap代码")
    private String purCompanySapCode;

    @ApiModelProperty("采购员id")
    private String purUserId;

    @ApiModelProperty("采购员名称")
    private String purUserName;

    @ApiModelProperty("供应商companyid")
    private String supCompanyId;

    @ApiModelProperty("供应商公司名称")
    private String supCompanyName;

    @ApiModelProperty("供应商srm代码")
    private String supCompanySrmCode;

    @ApiModelProperty("供应商sap代码")
    private String supCompanySapCode;

    @ApiModelProperty("供应商用户id")
    private String supUserId;

    @ApiModelProperty("供应商用户名称")
    private String supUserName;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("最后更新时间")
    private Date lastUpdateTime;

    @ApiModelProperty("最后修改人")
    private String lastUpdateUser;

    @ApiModelProperty("招标编号")
    private String biddingNo;

    @ApiModelProperty("招标轮次")
    private String biddingRoundsNumber;

    @ApiModelProperty("招标总轮数")
    private String biddingTotalRound;

    @ApiModelProperty("需求类型编码:material(物料),die(模具),device(设备)")
    private String requirementTypeCode;

    @ApiModelProperty("需求类型名称")
    private String requirementTypeName;

    @ApiModelProperty("招标内容行项目号")
    private String biddingContectItemNo;

    @ApiModelProperty("编码")
    private String projectNo;

    @ApiModelProperty("名称")
    private String projectName;

    @ApiModelProperty("描述")
    private String projectDesc;

    @ApiModelProperty("承诺年降率")
    private String promiseReducedRate;

    @ApiModelProperty("用量")
    private Long quantity;

    @ApiModelProperty("目标单价（不含税单价）")
    private BigDecimal unitPrice;

    @ApiModelProperty("目标套价（不含税单价）")
    private BigDecimal amount;



    @ApiModelProperty("报价单价(不含税单价)")
    private String offerUnitPrice;

    @ApiModelProperty("报价套价(不含税单价)")
    private String offerSetPrice;

    @ApiModelProperty("上轮报价单价(不含税单价)")
    private String lastOfferPrice;

    @ApiModelProperty("当前排名")
    private String currentRanking;

    @ApiModelProperty("实报品牌")
    private String factBarnd;

    @ApiModelProperty("实报规格")
    private String factSpec;

    @ApiModelProperty("实报型号")
    private String factModel;

    @ApiModelProperty("是否中标 0:否 1:是")
    private String isBidding;

    @ApiModelProperty("推荐供应商 0：否  1：是")
    private String isGroomMaterial;

    @ApiModelProperty("供应商状态 stranger/potenial/qualified/eliminate")
    private String materialStstus;

    @ApiModelProperty("供应商等级")
    private String materialDevel;

    @ApiModelProperty("招标数量")
    private Long biddingQuantity;

    @JsonSerialize(using = UploadSupportJsonSerializer.class)
    @JsonDeserialize(using = UploadSupportJsonDeserializer.class)
    @ApiModelProperty("图片附件")
    private String pictureAttachment;

    @JsonSerialize(using = UploadSupportJsonSerializer.class)
    @JsonDeserialize(using = UploadSupportJsonDeserializer.class)
    @ApiModelProperty("方案、设计图纸")
    private String designPicAttachment;

    @ApiModelProperty("物料品牌")
    private String materialFeatures;

    @ApiModelProperty("规格")
    private String materialSpec;

    @ApiModelProperty("型号")
    private String materialModel;

    @ApiModelProperty("单位")
    private String unit;

    @ApiModelProperty("交货日期")
    private Date deliveryDate;

    private String modelNo;

    private String modelDesc;

    private String modelName;

    @ApiModelProperty("使用机型")
    private String useModel;

    @ApiModelProperty("所属年份")
    private String beloneYear;

    @ApiModelProperty("模具序号")
    private String modelSerialNumber;

    @ApiModelProperty("模具材料")
    private String modelMaterial;

    @ApiModelProperty("模具寿命")
    private String modelLife;

    @ApiModelProperty("产权状况")
    private String propertyRight;

    @ApiModelProperty("开模归属")
    private String modelSinking;

    @ApiModelProperty("参考价格")
    private BigDecimal referencePrice;

    @ApiModelProperty("标的编码")
    private String targetNo;

    @ApiModelProperty("标的描述")
    private String taregtDesc;

    @ApiModelProperty("标的名称")
    private String targetName;

    @ApiModelProperty("中标份额")
    private String bidShare;

    @ApiModelProperty("实际年降率")
    private String actualDropRate;

    @ApiModelProperty("报价币种")
    private String currency;

    @ApiModelProperty("当前汇率")
    private String currentRate;

    private String biddingHeaderId;

    private String matterId;

    private String modelId;

    private String otherId;

    @ApiModelProperty("保证金是否缴纳 0:否 1:是")
    private String isPayMoney;
    
    @ApiModelProperty("价格单位")
    private Integer priceUnit;

    public String getIsPayMoney() {
        return isPayMoney;
    }

    public void setIsPayMoney(String isPayMoney) {
        this.isPayMoney = isPayMoney;
    }

    private List<BiddingMatterStep> biddingMatterStepList;

    private List<BiddingMatterStepSup> biddingMatterStepSupList;

    public List<BiddingMatterStepSup> getBiddingMatterStepSupList() {
        return biddingMatterStepSupList;
    }

    public void setBiddingMatterStepSupList(List<BiddingMatterStepSup> biddingMatterStepSupList) {
        this.biddingMatterStepSupList = biddingMatterStepSupList;
    }

    public List<BiddingMatterStep> getBiddingMatterStepList() {
        return biddingMatterStepList;
    }

    public void setBiddingMatterStepList(List<BiddingMatterStep> biddingMatterStepList) {
        this.biddingMatterStepList = biddingMatterStepList;
    }

    @ApiModelProperty("0：必须全部投标、1：可以部分投标")
    private String allBidding;

    @ApiModelProperty("每轮报价有效次数")
    private String effectiveNumber;

    @ApiModelProperty("当前轮报价剩余有效次数")
    private String restEffectiveNumber;

    @ApiModelProperty("上轮报价套价(不含税套价)")
    private String lastOfferSetPrice;

    @ApiModelProperty("报价方式 0:阶梯报价,1:常规报价")
    private String quotationMethod;

    @ApiModelProperty("是否阶梯报价")
    private String isStep;

    @ApiModelProperty("供应商临时编码")
    private String supplierTemporaryCode;

    @ApiModelProperty("供应商报价金额")
    private BigDecimal supplierQuotedPrice;
    @ApiModelProperty("临时报价单价(不含税单价)")
    private String tempOfferUnitPrice;

    @ApiModelProperty("临时报价套价(不含税单价)")
    private String tempOfferSetPrice;

    @ApiModelProperty("临时物料编号：招标单号+序号")
    private String tempMaterialNo;

    @ApiModelProperty("是否提交评标   0：否    1：是")
    private String isSubmitBid;
    
    @ApiModelProperty("税率")
    private BigDecimal taxRate;

    @ApiModelProperty("税码")
    private String taxCode;

    @ApiModelProperty("价格有效期从")
    private Date priceEffectiveFrom;

    @ApiModelProperty("价格有效期到")
    private Date priceEffectiveTo;

    @ApiModelProperty("物料成本分析清单ID")
    private String costAnalysisId;

    @ApiModelProperty("成本分析清单对象")
    private InquirySupOrder inquirySupOrder;
    
    @JsonSerialize(using=DetailSerialzer.class)
	@ApiModelProperty(position=24,value="物料成本清单",dataType="button")
	private IOrderItemDetail orderItemDetail;
    
    @ApiModelProperty(position=9, value="成本分析清单",dataType="button")
	private IMouldDetail mouldDetail;
    
    public IMouldDetail getMouldDetail() {
		return mouldDetail;
	}

	public void setMouldDetail(IMouldDetail mouldDetail) {
		this.mouldDetail = mouldDetail;
	}

	public IOrderItemDetail getOrderItemDetail() {
		return orderItemDetail;
	}

	public void setOrderItemDetail(IOrderItemDetail orderItemDetail) {
		this.orderItemDetail = orderItemDetail;
	}

	public InquirySupOrder getInquirySupOrder() {
		return inquirySupOrder;
	}

	public void setInquirySupOrder(InquirySupOrder inquirySupOrder) {
		this.inquirySupOrder = inquirySupOrder;
	}

	private static final long serialVersionUID = 1L;



    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getPurCompanyId() {
        return purCompanyId;
    }

    public void setPurCompanyId(String purCompanyId) {
        this.purCompanyId = purCompanyId == null ? null : purCompanyId.trim();
    }

    public String getPurCompanyName() {
        return purCompanyName;
    }

    public void setPurCompanyName(String purCompanyName) {
        this.purCompanyName = purCompanyName == null ? null : purCompanyName.trim();
    }

    public String getPurCompanySrmCode() {
        return purCompanySrmCode;
    }

    public void setPurCompanySrmCode(String purCompanySrmCode) {
        this.purCompanySrmCode = purCompanySrmCode == null ? null : purCompanySrmCode.trim();
    }

    public String getPurCompanySapCode() {
        return purCompanySapCode;
    }

    public void setPurCompanySapCode(String purCompanySapCode) {
        this.purCompanySapCode = purCompanySapCode == null ? null : purCompanySapCode.trim();
    }

    public String getPurUserId() {
        return purUserId;
    }

    public void setPurUserId(String purUserId) {
        this.purUserId = purUserId == null ? null : purUserId.trim();
    }

    public String getPurUserName() {
        return purUserName;
    }

    public void setPurUserName(String purUserName) {
        this.purUserName = purUserName == null ? null : purUserName.trim();
    }

    public String getSupCompanyId() {
        return supCompanyId;
    }

    public void setSupCompanyId(String supCompanyId) {
        this.supCompanyId = supCompanyId == null ? null : supCompanyId.trim();
    }

    public String getSupCompanyName() {
        return supCompanyName;
    }

    public void setSupCompanyName(String supCompanyName) {
        this.supCompanyName = supCompanyName == null ? null : supCompanyName.trim();
    }

    public String getSupCompanySrmCode() {
        return supCompanySrmCode;
    }

    public void setSupCompanySrmCode(String supCompanySrmCode) {
        this.supCompanySrmCode = supCompanySrmCode == null ? null : supCompanySrmCode.trim();
    }

    public String getSupCompanySapCode() {
        return supCompanySapCode;
    }

    public void setSupCompanySapCode(String supCompanySapCode) {
        this.supCompanySapCode = supCompanySapCode == null ? null : supCompanySapCode.trim();
    }

    public String getSupUserId() {
        return supUserId;
    }

    public void setSupUserId(String supUserId) {
        this.supUserId = supUserId == null ? null : supUserId.trim();
    }

    public String getSupUserName() {
        return supUserName;
    }

    public void setSupUserName(String supUserName) {
        this.supUserName = supUserName == null ? null : supUserName.trim();
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getLastUpdateTime() {
        return lastUpdateTime;
    }

    public void setLastUpdateTime(Date lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public String getLastUpdateUser() {
        return lastUpdateUser;
    }

    public void setLastUpdateUser(String lastUpdateUser) {
        this.lastUpdateUser = lastUpdateUser == null ? null : lastUpdateUser.trim();
    }

    public String getBiddingNo() {
        return biddingNo;
    }

    public void setBiddingNo(String biddingNo) {
        this.biddingNo = biddingNo == null ? null : biddingNo.trim();
    }

    public String getBiddingRoundsNumber() {
        return biddingRoundsNumber;
    }

    public void setBiddingRoundsNumber(String biddingRoundsNumber) {
        this.biddingRoundsNumber = biddingRoundsNumber == null ? null : biddingRoundsNumber.trim();
    }

    public String getBiddingTotalRound() {
        return biddingTotalRound;
    }

    public void setBiddingTotalRound(String biddingTotalRound) {
        this.biddingTotalRound = biddingTotalRound == null ? null : biddingTotalRound.trim();
    }

    public String getRequirementTypeCode() {
        return requirementTypeCode;
    }

    public void setRequirementTypeCode(String requirementTypeCode) {
        this.requirementTypeCode = requirementTypeCode == null ? null : requirementTypeCode.trim();
    }

    public String getRequirementTypeName() {
        return requirementTypeName;
    }

    public void setRequirementTypeName(String requirementTypeName) {
        this.requirementTypeName = requirementTypeName == null ? null : requirementTypeName.trim();
    }

    public String getBiddingContectItemNo() {
        return biddingContectItemNo;
    }

    public void setBiddingContectItemNo(String biddingContectItemNo) {
        this.biddingContectItemNo = biddingContectItemNo == null ? null : biddingContectItemNo.trim();
    }

    public String getProjectNo() {
        return projectNo;
    }

    public void setProjectNo(String projectNo) {
        this.projectNo = projectNo == null ? null : projectNo.trim();
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName == null ? null : projectName.trim();
    }

    public String getProjectDesc() {
        return projectDesc;
    }

    public void setProjectDesc(String projectDesc) {
        this.projectDesc = projectDesc == null ? null : projectDesc.trim();
    }

    public String getPromiseReducedRate() {
        return promiseReducedRate;
    }

    public void setPromiseReducedRate(String promiseReducedRate) {
        this.promiseReducedRate = promiseReducedRate == null ? null : promiseReducedRate.trim();
    }

    public Long getQuantity() {
        return quantity;
    }

    public void setQuantity(Long quantity) {
        this.quantity = quantity;
    }

    public BigDecimal getUnitPrice() {
        return unitPrice;
    }

    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public String getOfferUnitPrice() {
        return offerUnitPrice;
    }

    public void setOfferUnitPrice(String offerUnitPrice) {
        this.offerUnitPrice = offerUnitPrice == null ? null : offerUnitPrice.trim();
    }

    public String getOfferSetPrice() {
        return offerSetPrice;
    }

    public void setOfferSetPrice(String offerSetPrice) {
        this.offerSetPrice = offerSetPrice == null ? null : offerSetPrice.trim();
    }

    public String getLastOfferPrice() {
        return lastOfferPrice;
    }

    public void setLastOfferPrice(String lastOfferPrice) {
        this.lastOfferPrice = lastOfferPrice == null ? null : lastOfferPrice.trim();
    }

    public String getCurrentRanking() {
        return currentRanking;
    }

    public void setCurrentRanking(String currentRanking) {
        this.currentRanking = currentRanking == null ? null : currentRanking.trim();
    }

    public String getFactBarnd() {
        return factBarnd;
    }

    public void setFactBarnd(String factBarnd) {
        this.factBarnd = factBarnd == null ? null : factBarnd.trim();
    }

    public String getFactSpec() {
        return factSpec;
    }

    public void setFactSpec(String factSpec) {
        this.factSpec = factSpec == null ? null : factSpec.trim();
    }

    public String getFactModel() {
        return factModel;
    }

    public void setFactModel(String factModel) {
        this.factModel = factModel == null ? null : factModel.trim();
    }

    public String getIsBidding() {
        return isBidding;
    }

    public void setIsBidding(String isBidding) {
        this.isBidding = isBidding == null ? null : isBidding.trim();
    }

    public String getIsGroomMaterial() {
        return isGroomMaterial;
    }

    public void setIsGroomMaterial(String isGroomMaterial) {
        this.isGroomMaterial = isGroomMaterial == null ? null : isGroomMaterial.trim();
    }

    public String getMaterialStstus() {
        return materialStstus;
    }

    public void setMaterialStstus(String materialStstus) {
        this.materialStstus = materialStstus == null ? null : materialStstus.trim();
    }

    public String getMaterialDevel() {
        return materialDevel;
    }

    public void setMaterialDevel(String materialDevel) {
        this.materialDevel = materialDevel == null ? null : materialDevel.trim();
    }

    public Long getBiddingQuantity() {
        return biddingQuantity;
    }

    public void setBiddingQuantity(Long biddingQuantity) {
        this.biddingQuantity = biddingQuantity;
    }

    public String getPictureAttachment() {
        return pictureAttachment;
    }

    public void setPictureAttachment(String pictureAttachment) {
        this.pictureAttachment = pictureAttachment == null ? null : pictureAttachment.trim();
    }

    public String getDesignPicAttachment() {
        return designPicAttachment;
    }

    public void setDesignPicAttachment(String designPicAttachment) {
        this.designPicAttachment = designPicAttachment == null ? null : designPicAttachment.trim();
    }

    public String getMaterialFeatures() {
        return materialFeatures;
    }

    public void setMaterialFeatures(String materialFeatures) {
        this.materialFeatures = materialFeatures == null ? null : materialFeatures.trim();
    }

    public String getMaterialSpec() {
        return materialSpec;
    }

    public void setMaterialSpec(String materialSpec) {
        this.materialSpec = materialSpec == null ? null : materialSpec.trim();
    }

    public String getMaterialModel() {
        return materialModel;
    }

    public void setMaterialModel(String materialModel) {
        this.materialModel = materialModel == null ? null : materialModel.trim();
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit == null ? null : unit.trim();
    }

    public Date getDeliveryDate() {
        return deliveryDate;
    }

    public void setDeliveryDate(Date deliveryDate) {
        this.deliveryDate = deliveryDate;
    }

    public String getModelNo() {
        return modelNo;
    }

    public void setModelNo(String modelNo) {
        this.modelNo = modelNo == null ? null : modelNo.trim();
    }

    public String getModelDesc() {
        return modelDesc;
    }

    public void setModelDesc(String modelDesc) {
        this.modelDesc = modelDesc == null ? null : modelDesc.trim();
    }

    public String getModelName() {
        return modelName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName == null ? null : modelName.trim();
    }

    public String getUseModel() {
        return useModel;
    }

    public void setUseModel(String useModel) {
        this.useModel = useModel == null ? null : useModel.trim();
    }

    public String getBeloneYear() {
        return beloneYear;
    }

    public void setBeloneYear(String beloneYear) {
        this.beloneYear = beloneYear == null ? null : beloneYear.trim();
    }

    public String getModelSerialNumber() {
        return modelSerialNumber;
    }

    public void setModelSerialNumber(String modelSerialNumber) {
        this.modelSerialNumber = modelSerialNumber == null ? null : modelSerialNumber.trim();
    }

    public String getModelMaterial() {
        return modelMaterial;
    }

    public void setModelMaterial(String modelMaterial) {
        this.modelMaterial = modelMaterial == null ? null : modelMaterial.trim();
    }

    public String getModelLife() {
        return modelLife;
    }

    public void setModelLife(String modelLife) {
        this.modelLife = modelLife == null ? null : modelLife.trim();
    }

    public String getPropertyRight() {
        return propertyRight;
    }

    public void setPropertyRight(String propertyRight) {
        this.propertyRight = propertyRight == null ? null : propertyRight.trim();
    }

    public String getModelSinking() {
        return modelSinking;
    }

    public void setModelSinking(String modelSinking) {
        this.modelSinking = modelSinking == null ? null : modelSinking.trim();
    }

    public BigDecimal getReferencePrice() {
        return referencePrice;
    }

    public void setReferencePrice(BigDecimal referencePrice) {
        this.referencePrice = referencePrice;
    }

    public String getTargetNo() {
        return targetNo;
    }

    public void setTargetNo(String targetNo) {
        this.targetNo = targetNo == null ? null : targetNo.trim();
    }

    public String getTaregtDesc() {
        return taregtDesc;
    }

    public void setTaregtDesc(String taregtDesc) {
        this.taregtDesc = taregtDesc == null ? null : taregtDesc.trim();
    }

    public String getTargetName() {
        return targetName;
    }

    public void setTargetName(String targetName) {
        this.targetName = targetName == null ? null : targetName.trim();
    }

    public String getBidShare() {
        return bidShare;
    }

    public void setBidShare(String bidShare) {
        this.bidShare = bidShare == null ? null : bidShare.trim();
    }

    public String getActualDropRate() {
        return actualDropRate;
    }

    public void setActualDropRate(String actualDropRate) {
        this.actualDropRate = actualDropRate == null ? null : actualDropRate.trim();
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency == null ? null : currency.trim();
    }

    public String getCurrentRate() {
        return currentRate;
    }

    public void setCurrentRate(String currentRate) {
        this.currentRate = currentRate == null ? null : currentRate.trim();
    }

    public String getBiddingHeaderId() {
        return biddingHeaderId;
    }

    public void setBiddingHeaderId(String biddingHeaderId) {
        this.biddingHeaderId = biddingHeaderId == null ? null : biddingHeaderId.trim();
    }

    public String getMatterId() {
        return matterId;
    }

    public void setMatterId(String matterId) {
        this.matterId = matterId == null ? null : matterId.trim();
    }

    public String getModelId() {
        return modelId;
    }

    public void setModelId(String modelId) {
        this.modelId = modelId == null ? null : modelId.trim();
    }

    public String getOtherId() {
        return otherId;
    }

    public void setOtherId(String otherId) {
        this.otherId = otherId == null ? null : otherId.trim();
    }

    public String getAllBidding() {
        return allBidding;
    }

    public void setAllBidding(String allBidding) {
        this.allBidding = allBidding == null ? null : allBidding.trim();
    }

    public String getEffectiveNumber() {
        return effectiveNumber;
    }

    public void setEffectiveNumber(String effectiveNumber) {
        this.effectiveNumber = effectiveNumber == null ? null : effectiveNumber.trim();
    }

    public String getRestEffectiveNumber() {
        return restEffectiveNumber;
    }

    public void setRestEffectiveNumber(String restEffectiveNumber) {
        this.restEffectiveNumber = restEffectiveNumber == null ? null : restEffectiveNumber.trim();
    }

    public String getLastOfferSetPrice() {
        return lastOfferSetPrice;
    }

    public void setLastOfferSetPrice(String lastOfferSetPrice) {
        this.lastOfferSetPrice = lastOfferSetPrice == null ? null : lastOfferSetPrice.trim();
    }

    public String getQuotationMethod() {
        return quotationMethod;
    }

    public void setQuotationMethod(String quotationMethod) {
        this.quotationMethod = quotationMethod == null ? null : quotationMethod.trim();
    }

    public String getIsStep() {
        return isStep;
    }

    public void setIsStep(String isStep) {
        this.isStep = isStep == null ? null : isStep.trim();
    }

    public String getSupplierTemporaryCode() {
        return supplierTemporaryCode;
    }

    public void setSupplierTemporaryCode(String supplierTemporaryCode) {
        this.supplierTemporaryCode = supplierTemporaryCode == null ? null : supplierTemporaryCode.trim();
    }
    public BigDecimal getSupplierQuotedPrice() {
        return supplierQuotedPrice;
    }

    public void setSupplierQuotedPrice(BigDecimal supplierQuotedPrice) {
        this.supplierQuotedPrice = supplierQuotedPrice;
    }
    public String getTempOfferUnitPrice() {
        return tempOfferUnitPrice;
    }

    public void setTempOfferUnitPrice(String tempOfferUnitPrice) {
        this.tempOfferUnitPrice = tempOfferUnitPrice == null ? null : tempOfferUnitPrice.trim();
    }

    public String getTempOfferSetPrice() {
        return tempOfferSetPrice;
    }

    public void setTempOfferSetPrice(String tempOfferSetPrice) {
        this.tempOfferSetPrice = tempOfferSetPrice == null ? null : tempOfferSetPrice.trim();
    }

    public String getTempMaterialNo() {
        return tempMaterialNo;
    }

    public void setTempMaterialNo(String tempMaterialNo) {
        this.tempMaterialNo = tempMaterialNo == null ? null : tempMaterialNo.trim();
    }

    public String getIsSubmitBid() {
        return isSubmitBid;
    }

    public void setIsSubmitBid(String isSubmitBid) {
        this.isSubmitBid = isSubmitBid == null ? null : isSubmitBid.trim();
    }

    public String getCostAnalysisId() {
        return costAnalysisId;
    }

    public void setCostAnalysisId(String costAnalysisId) {
        this.costAnalysisId = costAnalysisId == null ? null : costAnalysisId.trim();
    }
    
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public String getTaxCode() {
        return taxCode;
    }

    public void setTaxCode(String taxCode) {
        this.taxCode = taxCode == null ? null : taxCode.trim();
    }

    public Date getPriceEffectiveFrom() {
        return priceEffectiveFrom;
    }

    public void setPriceEffectiveFrom(Date priceEffectiveFrom) {
        this.priceEffectiveFrom = priceEffectiveFrom;
    }

    public Date getPriceEffectiveTo() {
        return priceEffectiveTo;
    }

    public void setPriceEffectiveTo(Date priceEffectiveTo) {
        this.priceEffectiveTo = priceEffectiveTo;
    }

	public Integer getPriceUnit() {
		return priceUnit;
	}

	public void setPriceUnit(Integer priceUnit) {
		this.priceUnit = priceUnit;
	}
    
}