package com.els.base.bidding.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@ApiModel(value="招投标-在线竞价")
public class BiddingOnline implements Serializable {
    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("企业id")
    private String purCompanyId;

    @ApiModelProperty("采购商SRM编码")
    private String purCompanySrmCode;

    @ApiModelProperty("企业名称")
    private String purCompanyName;

    @ApiModelProperty("采购员id")
    private String purUserId;

    @ApiModelProperty("采购员名称")
    private String purUserName;

    @ApiModelProperty("供应商companyid")
    private String supCompanyId;

    @ApiModelProperty("供应商公司名称")
    private String supCompanyName;

    @ApiModelProperty("供应商SRM编码")
    private String supCompanySrmCode;

    @ApiModelProperty("供应商用户id")
    private String supUserId;

    @ApiModelProperty("供应商用户名称")
    private String supUserName;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("更新时间")
    private Date updateTime;

    @ApiModelProperty("修改人")
    private String updateUser;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("招标编号")
    private String biddingNo;

    @ApiModelProperty("招标id")
    private String biddingId;

    @ApiModelProperty("招标轮次")
    private String biddingRoundsNumber;

    @ApiModelProperty("报价时间")
    private Date offerTime;

    @ApiModelProperty("未税单价")
    private BigDecimal untaxedUnitPrice;

    @ApiModelProperty("未税总价")
    private BigDecimal untaxedTotalPrice;

    @ApiModelProperty("含税单价")
    private BigDecimal taxedUnitPrice;

    @ApiModelProperty("含税总价")
    private BigDecimal taxedTotalPrice;

    @ApiModelProperty("税率")
    private BigDecimal taxRate;

    @ApiModelProperty("税码")
    private String taxCode;

    @ApiModelProperty("币种")
    private String currency;

    @ApiModelProperty("报价状态（0无效竞价，1有效竞价，2中标）")
    private String quotationState;
    
    @ApiModelProperty("价格有效期从")
    private Date priceEffectiveFrom;

    @ApiModelProperty("价格有效期到")
    private Date priceEffectiveTo;
    
    @ApiModelProperty("物料编码")
    private String materialCode;

    @ApiModelProperty("价格单位")
    private Integer priceUnit;

    @ApiModelProperty("降价幅度")
    private BigDecimal priceCutPercentage;

    @ApiModelProperty("幅度单位")
    private String amplitudeUnit;

    @ApiModelProperty("前一次不含税报价")
    private BigDecimal beforeUntaxedPrice;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getPurCompanyId() {
        return purCompanyId;
    }

    public void setPurCompanyId(String purCompanyId) {
        this.purCompanyId = purCompanyId == null ? null : purCompanyId.trim();
    }

    public String getPurCompanySrmCode() {
        return purCompanySrmCode;
    }

    public void setPurCompanySrmCode(String purCompanySrmCode) {
        this.purCompanySrmCode = purCompanySrmCode == null ? null : purCompanySrmCode.trim();
    }

    public String getPurCompanyName() {
        return purCompanyName;
    }

    public void setPurCompanyName(String purCompanyName) {
        this.purCompanyName = purCompanyName == null ? null : purCompanyName.trim();
    }

    public String getPurUserId() {
        return purUserId;
    }

    public void setPurUserId(String purUserId) {
        this.purUserId = purUserId == null ? null : purUserId.trim();
    }

    public String getPurUserName() {
        return purUserName;
    }

    public void setPurUserName(String purUserName) {
        this.purUserName = purUserName == null ? null : purUserName.trim();
    }

    public String getSupCompanyId() {
        return supCompanyId;
    }

    public void setSupCompanyId(String supCompanyId) {
        this.supCompanyId = supCompanyId == null ? null : supCompanyId.trim();
    }

    public String getSupCompanyName() {
        return supCompanyName;
    }

    public void setSupCompanyName(String supCompanyName) {
        this.supCompanyName = supCompanyName == null ? null : supCompanyName.trim();
    }

    public String getSupCompanySrmCode() {
        return supCompanySrmCode;
    }

    public void setSupCompanySrmCode(String supCompanySrmCode) {
        this.supCompanySrmCode = supCompanySrmCode == null ? null : supCompanySrmCode.trim();
    }

    public String getSupUserId() {
        return supUserId;
    }

    public void setSupUserId(String supUserId) {
        this.supUserId = supUserId == null ? null : supUserId.trim();
    }

    public String getSupUserName() {
        return supUserName;
    }

    public void setSupUserName(String supUserName) {
        this.supUserName = supUserName == null ? null : supUserName.trim();
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getUpdateUser() {
        return updateUser;
    }

    public void setUpdateUser(String updateUser) {
        this.updateUser = updateUser == null ? null : updateUser.trim();
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark == null ? null : remark.trim();
    }

    public String getBiddingNo() {
        return biddingNo;
    }

    public void setBiddingNo(String biddingNo) {
        this.biddingNo = biddingNo == null ? null : biddingNo.trim();
    }

    public String getBiddingId() {
        return biddingId;
    }

    public void setBiddingId(String biddingId) {
        this.biddingId = biddingId == null ? null : biddingId.trim();
    }

    public String getBiddingRoundsNumber() {
        return biddingRoundsNumber;
    }

    public void setBiddingRoundsNumber(String biddingRoundsNumber) {
        this.biddingRoundsNumber = biddingRoundsNumber == null ? null : biddingRoundsNumber.trim();
    }

    public Date getOfferTime() {
        return offerTime;
    }

    public void setOfferTime(Date offerTime) {
        this.offerTime = offerTime;
    }

    public BigDecimal getUntaxedUnitPrice() {
        return untaxedUnitPrice;
    }

    public void setUntaxedUnitPrice(BigDecimal untaxedUnitPrice) {
        this.untaxedUnitPrice = untaxedUnitPrice;
    }

    public BigDecimal getUntaxedTotalPrice() {
        return untaxedTotalPrice;
    }

    public void setUntaxedTotalPrice(BigDecimal untaxedTotalPrice) {
        this.untaxedTotalPrice = untaxedTotalPrice;
    }

    public BigDecimal getTaxedUnitPrice() {
        return taxedUnitPrice;
    }

    public void setTaxedUnitPrice(BigDecimal taxedUnitPrice) {
        this.taxedUnitPrice = taxedUnitPrice;
    }

    public BigDecimal getTaxedTotalPrice() {
        return taxedTotalPrice;
    }

    public void setTaxedTotalPrice(BigDecimal taxedTotalPrice) {
        this.taxedTotalPrice = taxedTotalPrice;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public String getTaxCode() {
        return taxCode;
    }

    public void setTaxCode(String taxCode) {
        this.taxCode = taxCode == null ? null : taxCode.trim();
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency == null ? null : currency.trim();
    }

    public String getQuotationState() {
        return quotationState;
    }

    public void setQuotationState(String quotationState) {
        this.quotationState = quotationState == null ? null : quotationState.trim();
    }
    
    public Date getPriceEffectiveFrom() {
        return priceEffectiveFrom;
    }

    public void setPriceEffectiveFrom(Date priceEffectiveFrom) {
        this.priceEffectiveFrom = priceEffectiveFrom;
    }

    public Date getPriceEffectiveTo() {
        return priceEffectiveTo;
    }

    public void setPriceEffectiveTo(Date priceEffectiveTo) {
        this.priceEffectiveTo = priceEffectiveTo;
    }
    
    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode == null ? null : materialCode.trim();
    }

    public Integer getPriceUnit() {
        return priceUnit;
    }

    public void setPriceUnit(Integer priceUnit) {
        this.priceUnit = priceUnit;
    }

    public BigDecimal getPriceCutPercentage() {
        return priceCutPercentage;
    }

    public void setPriceCutPercentage(BigDecimal priceCutPercentage) {
        this.priceCutPercentage = priceCutPercentage;
    }

    public String getAmplitudeUnit() {
        return amplitudeUnit;
    }

    public void setAmplitudeUnit(String amplitudeUnit) {
        this.amplitudeUnit = amplitudeUnit == null ? null : amplitudeUnit.trim();
    }

    public BigDecimal getBeforeUntaxedPrice() {
        return beforeUntaxedPrice;
    }

    public void setBeforeUntaxedPrice(BigDecimal beforeUntaxedPrice) {
        this.beforeUntaxedPrice = beforeUntaxedPrice;
    }
}