package com.els.base.bidding.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@ApiModel(value="招投标-招标计划")
public class BiddingPlan implements Serializable {
    @ApiModelProperty("id")
    private String id;

    @ApiModelProperty("项目id")
    private String projectId;

    @ApiModelProperty("企业id")
    private String purCompanyId;

    @ApiModelProperty("企业名称")
    private String purCompanyName;

    @ApiModelProperty("采购员id")
    private String purUserId;

    @ApiModelProperty("采购员名称")
    private String purUserName;

    @ApiModelProperty("供应商companyid")
    private String supCompanyId;

    @ApiModelProperty("供应商公司名称")
    private String supCompanyName;

    @ApiModelProperty("供应商用户id")
    private String supUserId;

    @ApiModelProperty("供应商用户名称")
    private String supUserName;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("最后更新时间")
    private Date lastUpdateTime;

    @ApiModelProperty("最后修改人")
    private String lastUpdateUser;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("招标编号")
    private String biddingNo;

    @ApiModelProperty("招标id")
    private String biddingId;

    @ApiModelProperty("招标轮次")
    private String biddingRoundsNumber;

    @ApiModelProperty("招标类型： 0：邀请招标，1：公开招标，2：在线竞价")
    private String biddingType;

    @ApiModelProperty("招标总轮数")
    private String biddingTotalRound;

    @ApiModelProperty("开标前是否可以查看投标内容：0：保密,1：公开")
    private String biddingSecret;

    @ApiModelProperty("招标状态 : 未开始  1 : 招标进行中  2 : 未开标  3 : 评标中  4 ：本轮完成  5 ：招标中止")
    private String biddingStatus;

    @ApiModelProperty("投标开始日期")
    private Date biddingBeginDate;

    @ApiModelProperty("投标开始时间")
    private Date biddingBeginTime;

    @ApiModelProperty("投标截止日期")
    private Date biddingEndDate;

    @ApiModelProperty("投标截止时间")
    private Date biddingEndTime;

    @ApiModelProperty("开标日期")
    private Date biddingOpenDate;

    @ApiModelProperty("开标时间")
    private Date biddingOpenTime;

    @ApiModelProperty("开标地址")
    private String biddingAddress;

    @ApiModelProperty("发送低靠: 0：否、1：是")
    private String sendLowBack;

    @ApiModelProperty("低靠百分比")
    private String lowBackPerc;

    @ApiModelProperty("发送排名 0：否、1：是")
    private String sendRankings;

    @ApiModelProperty("供应商srm代码")
    private String supCompanySrmCode;

    @ApiModelProperty("供应商sap代码")
    private String supCompanySapCode;

    @ApiModelProperty("公司sap代码")
    private String purCompanySapCode;

    @ApiModelProperty("公司代码")
    private String purCompanySrmCode;

    @ApiModelProperty("应标截止时间")
    private Date biddingDeadline;

    @ApiModelProperty("总轮次（在线竞价）")
    private Integer totalRound;

    @ApiModelProperty("每轮持续时间（在线竞价）")
    private Integer eachRoundTime;

    @ApiModelProperty("每轮间隔时间（在线竞价）")
    private Integer eachRoundIntervalTime;

    @ApiModelProperty("最大延时次数（在线竞价）")
    private Integer maximumTimeDelay;

    @ApiModelProperty("应标期限（在线竞价）")
    private Integer deadline;

    @ApiModelProperty("降价幅度（在线竞价）")
    private BigDecimal priceCutPercentage;

    @ApiModelProperty("幅度单位（在线竞价）")
    private String amplitudeUnit;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId == null ? null : projectId.trim();
    }

    public String getPurCompanyId() {
        return purCompanyId;
    }

    public void setPurCompanyId(String purCompanyId) {
        this.purCompanyId = purCompanyId == null ? null : purCompanyId.trim();
    }

    public String getPurCompanyName() {
        return purCompanyName;
    }

    public void setPurCompanyName(String purCompanyName) {
        this.purCompanyName = purCompanyName == null ? null : purCompanyName.trim();
    }

    public String getPurUserId() {
        return purUserId;
    }

    public void setPurUserId(String purUserId) {
        this.purUserId = purUserId == null ? null : purUserId.trim();
    }

    public String getPurUserName() {
        return purUserName;
    }

    public void setPurUserName(String purUserName) {
        this.purUserName = purUserName == null ? null : purUserName.trim();
    }

    public String getSupCompanyId() {
        return supCompanyId;
    }

    public void setSupCompanyId(String supCompanyId) {
        this.supCompanyId = supCompanyId == null ? null : supCompanyId.trim();
    }

    public String getSupCompanyName() {
        return supCompanyName;
    }

    public void setSupCompanyName(String supCompanyName) {
        this.supCompanyName = supCompanyName == null ? null : supCompanyName.trim();
    }

    public String getSupUserId() {
        return supUserId;
    }

    public void setSupUserId(String supUserId) {
        this.supUserId = supUserId == null ? null : supUserId.trim();
    }

    public String getSupUserName() {
        return supUserName;
    }

    public void setSupUserName(String supUserName) {
        this.supUserName = supUserName == null ? null : supUserName.trim();
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getLastUpdateTime() {
        return lastUpdateTime;
    }

    public void setLastUpdateTime(Date lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public String getLastUpdateUser() {
        return lastUpdateUser;
    }

    public void setLastUpdateUser(String lastUpdateUser) {
        this.lastUpdateUser = lastUpdateUser == null ? null : lastUpdateUser.trim();
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark == null ? null : remark.trim();
    }

    public String getBiddingNo() {
        return biddingNo;
    }

    public void setBiddingNo(String biddingNo) {
        this.biddingNo = biddingNo == null ? null : biddingNo.trim();
    }

    public String getBiddingId() {
        return biddingId;
    }

    public void setBiddingId(String biddingId) {
        this.biddingId = biddingId == null ? null : biddingId.trim();
    }

    public String getBiddingRoundsNumber() {
        return biddingRoundsNumber;
    }

    public void setBiddingRoundsNumber(String biddingRoundsNumber) {
        this.biddingRoundsNumber = biddingRoundsNumber == null ? null : biddingRoundsNumber.trim();
    }

    public String getBiddingType() {
        return biddingType;
    }

    public void setBiddingType(String biddingType) {
        this.biddingType = biddingType == null ? null : biddingType.trim();
    }

    public String getBiddingTotalRound() {
        return biddingTotalRound;
    }

    public void setBiddingTotalRound(String biddingTotalRound) {
        this.biddingTotalRound = biddingTotalRound == null ? null : biddingTotalRound.trim();
    }

    public String getBiddingSecret() {
        return biddingSecret;
    }

    public void setBiddingSecret(String biddingSecret) {
        this.biddingSecret = biddingSecret == null ? null : biddingSecret.trim();
    }

    public String getBiddingStatus() {
        return biddingStatus;
    }

    public void setBiddingStatus(String biddingStatus) {
        this.biddingStatus = biddingStatus == null ? null : biddingStatus.trim();
    }

    public Date getBiddingBeginDate() {
        return biddingBeginDate;
    }

    public void setBiddingBeginDate(Date biddingBeginDate) {
        this.biddingBeginDate = biddingBeginDate;
    }

    public Date getBiddingBeginTime() {
        return biddingBeginTime;
    }

    public void setBiddingBeginTime(Date biddingBeginTime) {
        this.biddingBeginTime = biddingBeginTime;
    }

    public Date getBiddingEndDate() {
        return biddingEndDate;
    }

    public void setBiddingEndDate(Date biddingEndDate) {
        this.biddingEndDate = biddingEndDate;
    }

    public Date getBiddingEndTime() {
        return biddingEndTime;
    }

    public void setBiddingEndTime(Date biddingEndTime) {
        this.biddingEndTime = biddingEndTime;
    }

    public Date getBiddingOpenDate() {
        return biddingOpenDate;
    }

    public void setBiddingOpenDate(Date biddingOpenDate) {
        this.biddingOpenDate = biddingOpenDate;
    }

    public Date getBiddingOpenTime() {
        return biddingOpenTime;
    }

    public void setBiddingOpenTime(Date biddingOpenTime) {
        this.biddingOpenTime = biddingOpenTime;
    }

    public String getBiddingAddress() {
        return biddingAddress;
    }

    public void setBiddingAddress(String biddingAddress) {
        this.biddingAddress = biddingAddress == null ? null : biddingAddress.trim();
    }

    public String getSendLowBack() {
        return sendLowBack;
    }

    public void setSendLowBack(String sendLowBack) {
        this.sendLowBack = sendLowBack == null ? null : sendLowBack.trim();
    }

    public String getLowBackPerc() {
        return lowBackPerc;
    }

    public void setLowBackPerc(String lowBackPerc) {
        this.lowBackPerc = lowBackPerc == null ? null : lowBackPerc.trim();
    }

    public String getSendRankings() {
        return sendRankings;
    }

    public void setSendRankings(String sendRankings) {
        this.sendRankings = sendRankings == null ? null : sendRankings.trim();
    }

    public String getSupCompanySrmCode() {
        return supCompanySrmCode;
    }

    public void setSupCompanySrmCode(String supCompanySrmCode) {
        this.supCompanySrmCode = supCompanySrmCode == null ? null : supCompanySrmCode.trim();
    }

    public String getSupCompanySapCode() {
        return supCompanySapCode;
    }

    public void setSupCompanySapCode(String supCompanySapCode) {
        this.supCompanySapCode = supCompanySapCode == null ? null : supCompanySapCode.trim();
    }

    public String getPurCompanySapCode() {
        return purCompanySapCode;
    }

    public void setPurCompanySapCode(String purCompanySapCode) {
        this.purCompanySapCode = purCompanySapCode == null ? null : purCompanySapCode.trim();
    }

    public String getPurCompanySrmCode() {
        return purCompanySrmCode;
    }

    public void setPurCompanySrmCode(String purCompanySrmCode) {
        this.purCompanySrmCode = purCompanySrmCode == null ? null : purCompanySrmCode.trim();
    }

    public Date getBiddingDeadline() {
        return biddingDeadline;
    }

    public void setBiddingDeadline(Date biddingDeadline) {
        this.biddingDeadline = biddingDeadline;
    }

    public Integer getTotalRound() {
        return totalRound;
    }

    public void setTotalRound(Integer totalRound) {
        this.totalRound = totalRound;
    }

    public Integer getEachRoundTime() {
        return eachRoundTime;
    }

    public void setEachRoundTime(Integer eachRoundTime) {
        this.eachRoundTime = eachRoundTime;
    }

    public Integer getEachRoundIntervalTime() {
        return eachRoundIntervalTime;
    }

    public void setEachRoundIntervalTime(Integer eachRoundIntervalTime) {
        this.eachRoundIntervalTime = eachRoundIntervalTime;
    }

    public Integer getMaximumTimeDelay() {
        return maximumTimeDelay;
    }

    public void setMaximumTimeDelay(Integer maximumTimeDelay) {
        this.maximumTimeDelay = maximumTimeDelay;
    }

    public Integer getDeadline() {
        return deadline;
    }

    public void setDeadline(Integer deadline) {
        this.deadline = deadline;
    }

    public BigDecimal getPriceCutPercentage() {
        return priceCutPercentage;
    }

    public void setPriceCutPercentage(BigDecimal priceCutPercentage) {
        this.priceCutPercentage = priceCutPercentage;
    }

    public String getAmplitudeUnit() {
        return amplitudeUnit;
    }

    public void setAmplitudeUnit(String amplitudeUnit) {
        this.amplitudeUnit = amplitudeUnit == null ? null : amplitudeUnit.trim();
    }
}