package com.els.base.bidding.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;

@ApiModel(value="招投标-基本信息-采购方招投标人员权限")
public class BiddingPower implements Serializable {
    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("采购员公司ID")
    private String purCompanyId;

    @ApiModelProperty("客户编号")
    private String purCompanyCode;

    @ApiModelProperty("客户名称")
    private String purCompanyName;

    @ApiModelProperty("采购员ID")
    private String purUserId;

    @ApiModelProperty("采购负责人")
    private String purUserName;

    @ApiModelProperty("招标编号")
    private String biddingHeaderId;

    @ApiModelProperty("招标编号")
    private String biddingNo;

    @ApiModelProperty("招标组成员")
    private String biddingTendererMembers;

    @ApiModelProperty("招标组成员权限：0-不公开价格，1-招标单公开，2-招标单保密")
    private String biddingTendererPower;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("最后更新时间")
    private Date lastUpdateTime;

    @ApiModelProperty("最后修改人")
    private String lastUpdateUser;

    @ApiModelProperty("招标组成员id")
    private String biddingTendererMemberIds;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getPurCompanyId() {
        return purCompanyId;
    }

    public void setPurCompanyId(String purCompanyId) {
        this.purCompanyId = purCompanyId == null ? null : purCompanyId.trim();
    }

    public String getPurCompanyCode() {
        return purCompanyCode;
    }

    public void setPurCompanyCode(String purCompanyCode) {
        this.purCompanyCode = purCompanyCode == null ? null : purCompanyCode.trim();
    }

    public String getPurCompanyName() {
        return purCompanyName;
    }

    public void setPurCompanyName(String purCompanyName) {
        this.purCompanyName = purCompanyName == null ? null : purCompanyName.trim();
    }

    public String getPurUserId() {
        return purUserId;
    }

    public void setPurUserId(String purUserId) {
        this.purUserId = purUserId == null ? null : purUserId.trim();
    }

    public String getPurUserName() {
        return purUserName;
    }

    public void setPurUserName(String purUserName) {
        this.purUserName = purUserName == null ? null : purUserName.trim();
    }

    public String getBiddingHeaderId() {
        return biddingHeaderId;
    }

    public void setBiddingHeaderId(String biddingHeaderId) {
        this.biddingHeaderId = biddingHeaderId == null ? null : biddingHeaderId.trim();
    }

    public String getBiddingNo() {
        return biddingNo;
    }

    public void setBiddingNo(String biddingNo) {
        this.biddingNo = biddingNo == null ? null : biddingNo.trim();
    }

    public String getBiddingTendererMembers() {
        return biddingTendererMembers;
    }

    public void setBiddingTendererMembers(String biddingTendererMembers) {
        this.biddingTendererMembers = biddingTendererMembers == null ? null : biddingTendererMembers.trim();
    }

    public String getBiddingTendererPower() {
        return biddingTendererPower;
    }

    public void setBiddingTendererPower(String biddingTendererPower) {
        this.biddingTendererPower = biddingTendererPower == null ? null : biddingTendererPower.trim();
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getLastUpdateTime() {
        return lastUpdateTime;
    }

    public void setLastUpdateTime(Date lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public String getLastUpdateUser() {
        return lastUpdateUser;
    }

    public void setLastUpdateUser(String lastUpdateUser) {
        this.lastUpdateUser = lastUpdateUser == null ? null : lastUpdateUser.trim();
    }

    public String getBiddingTendererMemberIds() {
        return biddingTendererMemberIds;
    }

    public void setBiddingTendererMemberIds(String biddingTendererMemberIds) {
        this.biddingTendererMemberIds = biddingTendererMemberIds == null ? null : biddingTendererMemberIds.trim();
    }
}