package com.els.base.bidding.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;

@ApiModel(value="招投标在线答疑")
public class BiddingQuestion implements Serializable {
    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("供应商ID")
    private String supCompanyId;

    @ApiModelProperty("供应商SRM编码")
    private String supCompanySrmCode;

    @ApiModelProperty("供应商SAP编码")
    private String supCompanySapCode;

    @ApiModelProperty("供应商全称")
    private String supCompanyFullName;

    @ApiModelProperty("供应商简称")
    private String supCompanyName;

    @ApiModelProperty("供应商临时编码")
    private String supCompanyTempCode;

    @ApiModelProperty("招投标ID")
    private String biddingId;

    @ApiModelProperty("招投标单号")
    private String biddingNo;

    @ApiModelProperty("采购答复者ID")
    private String purUserId;

    @ApiModelProperty("采购答复者名称")
    private String purUserName;

    @ApiModelProperty("供应商提问者ID")
    private String supUserId;

    @ApiModelProperty("供应商提问者名称")
    private String supUserName;

    @ApiModelProperty("问题内容")
    private String questionContent;

    @ApiModelProperty("答复内容")
    private String answerContent;

    @ApiModelProperty("答复时间")
    private Date answerTime;

    @ApiModelProperty("问题类型(0=私有,1=公开)")
    private Integer questionType;

    @ApiModelProperty("供应商是否查看问题(0=未查看,1=已查看)")
    private Integer isSupCheck;

    @ApiModelProperty("采购方是否答复问题(0=未回复,1=已回复)")
    private Integer isPurAnswer;

    @ApiModelProperty("是否删除(0=已删除,1=未删除)")
    private Integer isEnable;

    @ApiModelProperty("创建时间(提问日期)")
    private Date createTime;

    @ApiModelProperty("修改时间(修改时间)")
    private Date updateTime;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getSupCompanyId() {
        return supCompanyId;
    }

    public void setSupCompanyId(String supCompanyId) {
        this.supCompanyId = supCompanyId == null ? null : supCompanyId.trim();
    }

    public String getSupCompanySrmCode() {
        return supCompanySrmCode;
    }

    public void setSupCompanySrmCode(String supCompanySrmCode) {
        this.supCompanySrmCode = supCompanySrmCode == null ? null : supCompanySrmCode.trim();
    }

    public String getSupCompanySapCode() {
        return supCompanySapCode;
    }

    public void setSupCompanySapCode(String supCompanySapCode) {
        this.supCompanySapCode = supCompanySapCode == null ? null : supCompanySapCode.trim();
    }

    public String getSupCompanyFullName() {
        return supCompanyFullName;
    }

    public void setSupCompanyFullName(String supCompanyFullName) {
        this.supCompanyFullName = supCompanyFullName == null ? null : supCompanyFullName.trim();
    }

    public String getSupCompanyName() {
        return supCompanyName;
    }

    public void setSupCompanyName(String supCompanyName) {
        this.supCompanyName = supCompanyName == null ? null : supCompanyName.trim();
    }

    public String getSupCompanyTempCode() {
        return supCompanyTempCode;
    }

    public void setSupCompanyTempCode(String supCompanyTempCode) {
        this.supCompanyTempCode = supCompanyTempCode == null ? null : supCompanyTempCode.trim();
    }

    public String getBiddingId() {
        return biddingId;
    }

    public void setBiddingId(String biddingId) {
        this.biddingId = biddingId == null ? null : biddingId.trim();
    }

    public String getBiddingNo() {
        return biddingNo;
    }

    public void setBiddingNo(String biddingNo) {
        this.biddingNo = biddingNo == null ? null : biddingNo.trim();
    }

    public String getPurUserId() {
        return purUserId;
    }

    public void setPurUserId(String purUserId) {
        this.purUserId = purUserId == null ? null : purUserId.trim();
    }

    public String getPurUserName() {
        return purUserName;
    }

    public void setPurUserName(String purUserName) {
        this.purUserName = purUserName == null ? null : purUserName.trim();
    }

    public String getSupUserId() {
        return supUserId;
    }

    public void setSupUserId(String supUserId) {
        this.supUserId = supUserId == null ? null : supUserId.trim();
    }

    public String getSupUserName() {
        return supUserName;
    }

    public void setSupUserName(String supUserName) {
        this.supUserName = supUserName == null ? null : supUserName.trim();
    }

    public String getQuestionContent() {
        return questionContent;
    }

    public void setQuestionContent(String questionContent) {
        this.questionContent = questionContent == null ? null : questionContent.trim();
    }

    public String getAnswerContent() {
        return answerContent;
    }

    public void setAnswerContent(String answerContent) {
        this.answerContent = answerContent == null ? null : answerContent.trim();
    }

    public Date getAnswerTime() {
        return answerTime;
    }

    public void setAnswerTime(Date answerTime) {
        this.answerTime = answerTime;
    }

    public Integer getQuestionType() {
        return questionType;
    }

    public void setQuestionType(Integer questionType) {
        this.questionType = questionType;
    }

    public Integer getIsSupCheck() {
        return isSupCheck;
    }

    public void setIsSupCheck(Integer isSupCheck) {
        this.isSupCheck = isSupCheck;
    }

    public Integer getIsPurAnswer() {
        return isPurAnswer;
    }

    public void setIsPurAnswer(Integer isPurAnswer) {
        this.isPurAnswer = isPurAnswer;
    }

    public Integer getIsEnable() {
        return isEnable;
    }

    public void setIsEnable(Integer isEnable) {
        this.isEnable = isEnable;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }
}