package com.els.base.bidding.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;

import com.els.base.file.utils.UploadSupportJsonDeserializer;
import com.els.base.file.utils.UploadSupportJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
@ApiModel(value="招投标-招标意向供应商列表")
public class BiddingSupplier implements Serializable {
    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("采购员公司ID")
    private String purCompanyId;

    @ApiModelProperty("客户编号")
    private String purCompanyCode;

    @ApiModelProperty("客户名称")
    private String purCompanyName;

    @ApiModelProperty("采购员ID")
    private String purUserId;

    @ApiModelProperty("采购负责人")
    private String purUserName;

    @ApiModelProperty("招标编号")
    private String biddingHeaderId;

    @ApiModelProperty("招标编号")
    private String biddingNo;

    @ApiModelProperty("应标：0：未应标，1：已应标，2：不应标")
    private String supParticipate;

    @ApiModelProperty("招标文件：0：已领取，1：未领取")
    private String supGetdoc;

    @ApiModelProperty("投标情况：0：未投标，1：已投标")
    private String supBidding;

    @ApiModelProperty("供应商企业ID")
    private String supCompanyId;

    @ApiModelProperty("供应商SRM编码")
    private String supCompanySrmCode;

    @ApiModelProperty("供应商SAP编码")
    private String supCompanySapCode;

    @ApiModelProperty("供应商企业名称")
    private String supCompanyName;

    @ApiModelProperty("销售方负责人")
    private String supUserName;

    @ApiModelProperty("供应商负责人ID")
    private String supUserId;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("最后更新时间")
    private Date lastUpdateTime;

    @ApiModelProperty("最后修改人")
    private String lastUpdateUser;

    @ApiModelProperty("供应商状态 0:合格供应商,1:陌生供应商,2:潜在供应商")
    private String supplierStatus;

    @ApiModelProperty("保证金是否缴纳 0:否 1:是")
    private String isPayMoney;

    @ApiModelProperty("伙伴角色:陌生供应商、潜在供应商、合格供应商、淘汰供应商")
    private String partnerRoleName;

    @ApiModelProperty("伙伴角色编码:stranger/potenial/qualified/eliminate")
    private String partnerRoleCode;

    @ApiModelProperty("供应商临时编码")
    private String supplierTemporaryCode;

    @JsonSerialize(using=UploadSupportJsonSerializer.class)
    @JsonDeserialize(using=UploadSupportJsonDeserializer.class)
    @ApiModelProperty("银行水单附件")
    private String bankAttachment;

    @ApiModelProperty("0 ：未发布 、1 ：已发布  、2 ：招投标进行中 、3 ：投标已结束、  4 评标中、 5 已评标 、6 已定标  、7 已作废 、 8 已结案  、 9 未应标   、10 待应标  、11 已应标  、12 拒绝应标、 13 部分应标  、14 全部应标")
    private String supBiddingStatus;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getPurCompanyId() {
        return purCompanyId;
    }

    public void setPurCompanyId(String purCompanyId) {
        this.purCompanyId = purCompanyId == null ? null : purCompanyId.trim();
    }

    public String getPurCompanyCode() {
        return purCompanyCode;
    }

    public void setPurCompanyCode(String purCompanyCode) {
        this.purCompanyCode = purCompanyCode == null ? null : purCompanyCode.trim();
    }

    public String getPurCompanyName() {
        return purCompanyName;
    }

    public void setPurCompanyName(String purCompanyName) {
        this.purCompanyName = purCompanyName == null ? null : purCompanyName.trim();
    }

    public String getPurUserId() {
        return purUserId;
    }

    public void setPurUserId(String purUserId) {
        this.purUserId = purUserId == null ? null : purUserId.trim();
    }

    public String getPurUserName() {
        return purUserName;
    }

    public void setPurUserName(String purUserName) {
        this.purUserName = purUserName == null ? null : purUserName.trim();
    }

    public String getBiddingHeaderId() {
        return biddingHeaderId;
    }

    public void setBiddingHeaderId(String biddingHeaderId) {
        this.biddingHeaderId = biddingHeaderId == null ? null : biddingHeaderId.trim();
    }

    public String getBiddingNo() {
        return biddingNo;
    }

    public void setBiddingNo(String biddingNo) {
        this.biddingNo = biddingNo == null ? null : biddingNo.trim();
    }

    public String getSupParticipate() {
        return supParticipate;
    }

    public void setSupParticipate(String supParticipate) {
        this.supParticipate = supParticipate == null ? null : supParticipate.trim();
    }

    public String getSupGetdoc() {
        return supGetdoc;
    }

    public void setSupGetdoc(String supGetdoc) {
        this.supGetdoc = supGetdoc == null ? null : supGetdoc.trim();
    }

    public String getSupBidding() {
        return supBidding;
    }

    public void setSupBidding(String supBidding) {
        this.supBidding = supBidding == null ? null : supBidding.trim();
    }

    public String getSupCompanyId() {
        return supCompanyId;
    }

    public void setSupCompanyId(String supCompanyId) {
        this.supCompanyId = supCompanyId == null ? null : supCompanyId.trim();
    }

    public String getSupCompanySrmCode() {
        return supCompanySrmCode;
    }

    public void setSupCompanySrmCode(String supCompanySrmCode) {
        this.supCompanySrmCode = supCompanySrmCode == null ? null : supCompanySrmCode.trim();
    }

    public String getSupCompanySapCode() {
        return supCompanySapCode;
    }

    public void setSupCompanySapCode(String supCompanySapCode) {
        this.supCompanySapCode = supCompanySapCode == null ? null : supCompanySapCode.trim();
    }

    public String getSupCompanyName() {
        return supCompanyName;
    }

    public void setSupCompanyName(String supCompanyName) {
        this.supCompanyName = supCompanyName == null ? null : supCompanyName.trim();
    }

    public String getSupUserName() {
        return supUserName;
    }

    public void setSupUserName(String supUserName) {
        this.supUserName = supUserName == null ? null : supUserName.trim();
    }

    public String getSupUserId() {
        return supUserId;
    }

    public void setSupUserId(String supUserId) {
        this.supUserId = supUserId == null ? null : supUserId.trim();
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getLastUpdateTime() {
        return lastUpdateTime;
    }

    public void setLastUpdateTime(Date lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public String getLastUpdateUser() {
        return lastUpdateUser;
    }

    public void setLastUpdateUser(String lastUpdateUser) {
        this.lastUpdateUser = lastUpdateUser == null ? null : lastUpdateUser.trim();
    }

    public String getSupplierStatus() {
        return supplierStatus;
    }

    public void setSupplierStatus(String supplierStatus) {
        this.supplierStatus = supplierStatus == null ? null : supplierStatus.trim();
    }

    public String getIsPayMoney() {
        return isPayMoney;
    }

    public void setIsPayMoney(String isPayMoney) {
        this.isPayMoney = isPayMoney == null ? null : isPayMoney.trim();
    }

    public String getPartnerRoleName() {
        return partnerRoleName;
    }

    public void setPartnerRoleName(String partnerRoleName) {
        this.partnerRoleName = partnerRoleName == null ? null : partnerRoleName.trim();
    }

    public String getPartnerRoleCode() {
        return partnerRoleCode;
    }

    public void setPartnerRoleCode(String partnerRoleCode) {
        this.partnerRoleCode = partnerRoleCode == null ? null : partnerRoleCode.trim();
    }

    public String getSupplierTemporaryCode() {
        return supplierTemporaryCode;
    }

    public void setSupplierTemporaryCode(String supplierTemporaryCode) {
        this.supplierTemporaryCode = supplierTemporaryCode == null ? null : supplierTemporaryCode.trim();
    }

    public String getBankAttachment() {
        return bankAttachment;
    }

    public void setBankAttachment(String bankAttachment) {
        this.bankAttachment = bankAttachment;
    }

    public String getSupBiddingStatus() {
        return supBiddingStatus;
    }

    public void setSupBiddingStatus(String supBiddingStatus) {
        this.supBiddingStatus = supBiddingStatus == null ? null : supBiddingStatus.trim();
    }
}