package com.els.base.bidding.entity.vo;

import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import com.els.base.auth.entity.User;
import com.els.base.bidding.entity.BiddingBond;
import com.els.base.bidding.entity.BiddingContactInfo;
import com.els.base.bidding.entity.BiddingContent;
import com.els.base.bidding.entity.BiddingFile;
import com.els.base.bidding.entity.BiddingFileSupplier;
import com.els.base.bidding.entity.BiddingHeader;
import com.els.base.bidding.entity.BiddingOnline;
import com.els.base.bidding.entity.BiddingPlan;
import com.els.base.bidding.entity.BiddingSupplier;
import com.els.base.company.entity.Company;

/**
 * BiddingBaseVo
 * 
 * @date 2018年1月22日 下午2:16:20
 * @version 1.0
 */
public class BiddingBaseVo implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("招投标-基本信息")
    private BiddingHeader biddingHeader;

    @ApiModelProperty("招投标-招标计划")
    private List<BiddingPlan> biddingPlanList = new ArrayList<BiddingPlan>();

    @ApiModelProperty("联系信息")
    private List<BiddingContactInfo> biddingContactInfoList = new ArrayList<BiddingContactInfo>();

    @ApiModelProperty("保证金")
    private BiddingBond biddingBond;

    @ApiModelProperty("招标内容")
    private BiddingContent biddingContent;
    
    @ApiModelProperty("在线竞价")
    private List<BiddingOnline> biddingOnlineList;
    
    @ApiModelProperty("在线竞价供应商报价排名")
    private BiddingOfferRankingVO offerRankingVO;

    @ApiModelProperty("招投标-招标意向供应商列表")
    private List<BiddingSupplier> biddingSupplierList = new ArrayList<BiddingSupplier>();

    @ApiModelProperty("招投标文件")
    private List<BiddingFile> biddingFiles = new ArrayList<BiddingFile>();

    @ApiModelProperty("供应商招投标文件")
    private List<BiddingFileSupplier> biddingFileSupplier = new ArrayList<BiddingFileSupplier>();

    @ApiModelProperty("报价操作类型：保存报价save或发送报价send(投标)")
    private String handleType;
    
    

	public String getHandleType() {
		return handleType;
	}

	public void setHandleType(String handleType) {
		this.handleType = handleType;
	}

	public List<BiddingFileSupplier> getBiddingFileSupplier() {
        return biddingFileSupplier;
    }

    public void setBiddingFileSupplier(List<BiddingFileSupplier> biddingFileSupplier) {
        this.biddingFileSupplier = biddingFileSupplier;
    }

    public List<BiddingFile> getBiddingFiles() {
        return biddingFiles;
    }

    public void setBiddingFiles(List<BiddingFile> biddingFiles) {
        this.biddingFiles = biddingFiles;
    }

    private Company company;

    private User user;

    private List<String> roleList;

    @ApiModelProperty("保证金是否缴纳 0:否 1:是")
    private String isPayMoney;

    public String getIsPayMoney() {
        return isPayMoney;
    }

    public void setIsPayMoney(String isPayMoney) {
        this.isPayMoney = isPayMoney;
    }

    public List<String> getRoleList() {
        return roleList;
    }

    public void setRoleList(List<String> roleList) {
        this.roleList = roleList;
    }

    public Company getCompany() {
        return company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public User getUser() {
        return user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public BiddingHeader getBiddingHeader() {
        return biddingHeader;
    }

    public void setBiddingHeader(BiddingHeader biddingHeader) {
        this.biddingHeader = biddingHeader;
    }

    public List<BiddingPlan> getBiddingPlanList() {
        return biddingPlanList;
    }

    public void setBiddingPlanList(List<BiddingPlan> biddingPlanList) {
        this.biddingPlanList = biddingPlanList;
    }

    public List<BiddingContactInfo> getBiddingContactInfoList() {
        return biddingContactInfoList;
    }

    public BiddingBond getBiddingBond() {
        return biddingBond;
    }

    public void setBiddingBond(BiddingBond biddingBond) {
        this.biddingBond = biddingBond;
    }

    public void setBiddingContactInfoList(List<BiddingContactInfo> biddingContactInfoList) {
        this.biddingContactInfoList = biddingContactInfoList;
    }

    public BiddingContent getBiddingContent() {
        return biddingContent;
    }

    public void setBiddingContent(BiddingContent biddingContent) {
        this.biddingContent = biddingContent;
    }

    public List<BiddingSupplier> getBiddingSupplierList() {
        return biddingSupplierList;
    }

    public void setBiddingSupplierList(List<BiddingSupplier> biddingSupplierList) {
        this.biddingSupplierList = biddingSupplierList;
    }

	public List<BiddingOnline> getBiddingOnlineList() {
		return biddingOnlineList;
	}

	public void setBiddingOnlineList(List<BiddingOnline> biddingOnlineList) {
		this.biddingOnlineList = biddingOnlineList;
	}

	public BiddingOfferRankingVO getOfferRankingVO() {
		return offerRankingVO;
	}

	public void setOfferRankingVO(BiddingOfferRankingVO offerRankingVO) {
		this.offerRankingVO = offerRankingVO;
	}
    

}
