package com.els.base.bidding.entity.vo;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import io.swagger.annotations.ApiModelProperty;
/**
 * 招投标供应商报价写入sap的字段
 * @author lenovo
 *
 */
public class BiddingPriceToSapVO implements Serializable {

    @ApiModelProperty("信息类别")
    private String informationCategory;
    
    @ApiModelProperty("采购组")
    private String purchasingGroup;

    @ApiModelProperty("采购组织")
    private String purchaseOrganization;
    
    @ApiModelProperty("供应商sap编码")
    private String supCompanySapCode;
    
    @ApiModelProperty("物料编码")
    private String materialCode;
    
    @ApiModelProperty("计划交货时间")
    private Integer plannedDeliveryTime;
    
    @ApiModelProperty("不含税单价")
    private BigDecimal untaxedUnitPrice;

    @ApiModelProperty("税码")
    private String taxCode;

    @ApiModelProperty("币种")
    private String currency;
    
    @ApiModelProperty("价格单位")
    private Integer priceUnit;
    
    @ApiModelProperty("价格有效期从")
    private Date priceEffectiveFrom;

    @ApiModelProperty("价格有效期到")
    private Date priceEffectiveTo;
    
    @ApiModelProperty("招标单号")
    private String biddingNo;
    
    private static final long serialVersionUID = 1L;

	public String getInformationCategory() {
		return informationCategory;
	}

	public void setInformationCategory(String informationCategory) {
		this.informationCategory = informationCategory;
	}

	public String getPurchasingGroup() {
		return purchasingGroup;
	}

	public void setPurchasingGroup(String purchasingGroup) {
		this.purchasingGroup = purchasingGroup;
	}

	public String getPurchaseOrganization() {
		return purchaseOrganization;
	}

	public void setPurchaseOrganization(String purchaseOrganization) {
		this.purchaseOrganization = purchaseOrganization;
	}

	public String getSupCompanySapCode() {
		return supCompanySapCode;
	}

	public void setSupCompanySapCode(String supCompanySapCode) {
		this.supCompanySapCode = supCompanySapCode;
	}

	public String getMaterialCode() {
		return materialCode;
	}

	public void setMaterialCode(String materialCode) {
		this.materialCode = materialCode;
	}

	public Integer getPlannedDeliveryTime() {
		return plannedDeliveryTime;
	}

	public void setPlannedDeliveryTime(Integer plannedDeliveryTime) {
		this.plannedDeliveryTime = plannedDeliveryTime;
	}

	public String getTaxCode() {
		return taxCode;
	}

	public void setTaxCode(String taxCode) {
		this.taxCode = taxCode;
	}

	public String getCurrency() {
		return currency;
	}

	public void setCurrency(String currency) {
		this.currency = currency;
	}

	public Date getPriceEffectiveFrom() {
		return priceEffectiveFrom;
	}

	public void setPriceEffectiveFrom(Date priceEffectiveFrom) {
		this.priceEffectiveFrom = priceEffectiveFrom;
	}

	public Date getPriceEffectiveTo() {
		return priceEffectiveTo;
	}

	public void setPriceEffectiveTo(Date priceEffectiveTo) {
		this.priceEffectiveTo = priceEffectiveTo;
	}

	public BigDecimal getUntaxedUnitPrice() {
		return untaxedUnitPrice;
	}

	public void setUntaxedUnitPrice(BigDecimal untaxedUnitPrice) {
		this.untaxedUnitPrice = untaxedUnitPrice;
	}

	public Integer getPriceUnit() {
		return priceUnit;
	}

	public void setPriceUnit(Integer priceUnit) {
		this.priceUnit = priceUnit;
	}

	public String getBiddingNo() {
		return biddingNo;
	}

	public void setBiddingNo(String biddingNo) {
		this.biddingNo = biddingNo;
	}
	
}
