package com.els.base.bidding.enums;

/**
 * TenderStatusEumn 招标状态
 * 
 * @date 2018年3月6日 下午3:59:19
 * @version 1.0
 */
public enum TenderStatusEumn {
    /**
     * 采购方状态[
                             新建招投标保存,点击“发布前审批”按钮,“发送前审批”驳回后：未发布 
         “发布前审批”完毕后：已发布 
                            供应商点击“应标”后,到了应标截止日期：部分应标／ 全部应标
                            供应商未操作应标和拒绝应标；未应标
                            到达投标开始时间后：招投标进行中
                            到达投标结束时间后：投标已结束
                            到达开标时间后,定标前审批驳回后：评标中
                            点击【提交评标】后,点击【定标前审批】后：已评标
                            定标前审批通过后： 已定标
                            点击【结案】后： 已结案
                            作废：已作废
                            ]
     */
    
    /**
     * 供应商状态[
                                供应商初始状态：未应标
                                供应商点击“应标”后：已应标
                                供应商点击“拒绝应标”后：拒绝应标
                                供应商未操作应标和拒绝应标；待应标
                                到了应标截止日期：已应标/ 拒绝应标
                                到达投标开始时间后：招投标进行中
                                到达投标结束时间后：投标已结束
                                到达开标时间后：评标中
                                点击【提交评标】后：已评标
                                点击【定标前审批】后：已评标
                                定标前审批通过后：已定标
                                定标前审批驳回后：评标中
                                点击【结案】后：已结案
                                作废：已作废]
     */
    
    /**
     * 0 未发布 1 已发布  2 招投标进行中 3 投标已结束  4 评标中 5 已评标 6 已定标  7 已作废  8 已结案
     * 9 未应标   10 待应标  11 已应标  12 拒绝应标 13 部分应标  14 全部应标 15 全部拒绝应标
     * 
     */
	/**0:未发布**/
    NOTPUBLISH("0", "未发布"),//有存到数据库的状态
    /**1:已发布**/
    PUBLISH("1", "已发布"),//有存到数据库的状态
    /**2:投标中**/
    BIDDING("2", "投标中"),
    /**3:投标结束**/
    BIDDINGEND("3", "投标结束"),
    /**4:评标中**/
    INBID("4", "评标中"),//有存到数据库的状态，定标审批驳回会更新 已评标 的供应商招标状态为 评标中
    /**5:已评标**/
    BIDOVER("5", "已评标"),//有存到数据库的状态
    /**6:已定标**/
    ISSCALING("6", "已定标"),//有存到数据库的状态
    /**7:已作废**/
    ISCANCEL("7", "已作废"),//有存到数据库的状态
    /**8:已结案**/
    ISFINISH("8", "已结案"),//有存到数据库的状态
    /**9:未应标(目前没有用)**/
    NOTBID("9", "未应标"),//目前没有用
    /**10:未应标**/
    WAITBID("10", "未应标"),//有存到数据库的状态
    /**11:已应标**/
    ISBID("11", "已应标"),//有存到数据库的状态
    /**12:拒绝应标**/
    REFUSEBID("12", "拒绝应标"),//有存到数据库的状态
    /**13:部分应标**/
    PARTBID("13", "部分应标"),//有存到数据库的状态，应标或拒绝应标，会更新 采购方 的招标状态为 部分应标
    /**14:全部应标**/
    ALLBID("14", "全部应标"),//有存到数据库的状态，应标或拒绝应标，会更新 采购方 的招标状态为 全部应标
    /**15:全部拒绝应标**/
    ALLREFUSEBID("15", "全部拒绝应标"),//有存到数据库的状态，应标或拒绝应标，会更新 采购方 的招标状态为 全部拒绝应标
    /**16:过期终止**/
	OVERTIME("16", "过期终止");
    
    TenderStatusEumn(String value, String desc) {
        this.value = value;
        this.desc = desc;
    }
    
    private final String value;

    private final String desc;

    public String getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }
    
}
