package com.els.base.bidding.service;

import java.util.List;

import com.els.base.auth.entity.User;
import com.els.base.bidding.entity.BiddingHeader;
import com.els.base.bidding.entity.BiddingHeaderExample;
import com.els.base.bidding.entity.BiddingSupplier;
import com.els.base.bidding.entity.vo.BiddingBaseVo;
import com.els.base.bidding.entity.vo.ManagementPage;
import com.els.base.company.entity.Company;
import com.els.base.core.service.BaseService;

public interface BiddingHeaderService extends BaseService<BiddingHeader, BiddingHeaderExample, String> {

    void saveBiddingInfo(BiddingBaseVo biddingBaseVo);

    List<ManagementPage> transform(List<BiddingHeader> queryResult, User user, List<String> roleCodeList);

    List<ManagementPage> transformSup(List<BiddingHeader> queryResult, User user, List<String> roleCodeList,
            Company company);

    // 采购方查询
    BiddingBaseVo queryDocument(String biddingNo, Company company, User user, List<String> roleCodeList);

    // 供应商方查询
    BiddingBaseVo queryDocumentSup(String biddingNo, String biddingCurrentRound, Company company, User user,
            List<String> roleCodeList);

    void toVoidDocument(String biddingNo);

    void deleteDocumentByBiddingNo(String biddingHeaderId);

    void sendToApprove(List<String> bidingNoList);

    void finisnBidding(String biddingNo);

    void editStatus(BiddingHeader biddingHeader, BiddingHeaderExample example);
    void customModifyObj(BiddingHeader biddingHeader);

    void insertIntoOffer(String biddingHeaderId, List<BiddingSupplier> biddingSupplierListSave) throws InstantiationException, IllegalAccessException;

    void addBiddingSupplier(BiddingSupplier biddingSupplier, BiddingHeader biddingHeader, Company purCompany,
            User purUser);

    List<ManagementPage> screenDataByBiddingStatus(List<ManagementPage> list, List<String> biddingStatusList);

}
