package com.els.base.bidding.service;

import java.util.List;

import com.els.base.auth.entity.User;
import com.els.base.bidding.entity.BiddingOffer;
import com.els.base.bidding.entity.BiddingOfferExample;
import com.els.base.bidding.entity.vo.BiddingBaseVo;
import com.els.base.bidding.entity.vo.SaveBidInfoVo;
import com.els.base.bidding.entity.vo.TemporaryCodeReducedRate;
import com.els.base.company.entity.Company;
import com.els.base.core.service.BaseService;

public interface BiddingOfferService extends BaseService<BiddingOffer, BiddingOfferExample, String> {

    void saveUnitPrice(BiddingBaseVo biddingBaseVo) throws InstantiationException, IllegalAccessException;

    List<BiddingOffer> findBidInfo(String biddingNo, String type, String isBidding, String currentRound);

    void save(SaveBidInfoVo saveBidInfoVo, String saveOrSubmit);

    void deleteByBiddingNo(String biddingNo);

    void deleteBySupCompanyId(String biddingNo, String supCompanyId);

    List<BiddingOffer> findBidInfoSup(String biddingNo, String type, String isBidding, String currentRound,
            User user, Company company);

    List<TemporaryCodeReducedRate> findBidSupplier(String biddingNo, String type, String currentRound);
}