package com.els.base.bidding.service;

import java.util.List;

import com.els.base.auth.entity.User;
import com.els.base.bidding.entity.BiddingOnline;
import com.els.base.bidding.entity.BiddingOnlineExample;
import com.els.base.company.entity.Company;
import com.els.base.core.service.BaseService;

public interface BiddingOnlineService extends BaseService<BiddingOnline, BiddingOnlineExample, String> {
	/**
	 * 在线竞价供应商报价信息保存
	 * @param currentCompany
	 * @param loginUser
	 * @param biddingOnline
	 */
	public void insert(Company supCompany, User loginUser, BiddingOnline biddingOnline);
	
	/**
	 * 采购商批量作废供应商报价
	 * @param ids
	 */
	public void batchInvalidationById(List<String> ids);
	
	/**
	 * 采购商中标操作供应商报价
	 * @param ids
	 */
	public void winTheBiddingById(String id);
	
	/**
	 * 采购商撤销中标供应商报价
	 * @param ids
	 */
	public void noWinTheBiddingById(String id);
	
	/**
	 * 采购商查询供应商报价排名
	 * @param biddingNo
	 * @param purCompanyId
	 * @return
	 */
	public List<BiddingOnline> queryAllObj(BiddingOnlineExample example);
	
	/**
	 * 采购商提交评标结果
	 * @param list
	 */
	public void submitResult(List<BiddingOnline> list);
}