package com.els.base.bidding.service;

import java.util.List;

import com.els.base.auth.entity.User;
import com.els.base.bidding.entity.BiddingQuestion;
import com.els.base.bidding.entity.BiddingQuestionExample;
import com.els.base.company.entity.Company;
import com.els.base.core.service.BaseService;

public interface BiddingQuestionService extends BaseService<BiddingQuestion, BiddingQuestionExample, String> {
	/**
	 * 供应商创建问题
	 * @param question
	 * @param supCompany
	 * @param supUser
	 */
	public void createBiddingQuestion(BiddingQuestion question,Company supCompany,User supUser);
	
	/**
	 * 批量删除问题
	 * @param ids
	 */
	public void deleteQuestion(List<String> ids);
	
	/**
	 * 通过id来查看详情：如果采购商已回复,要改为已查看状态。如果未回复,不需要修改
	 * @param id
	 */
	public BiddingQuestion findDetailById(String id,Company supCompany);
	
	/**
	 * 供应商修改问题
	 * @param question
	 */
	public void editQuestionForSup(BiddingQuestion question);
	
	
	/**
	 * 采购方尚未回复的问题和采购方已回复但是供应商还未查看的问题的数量之和
	 * @return
	 */
	public int countSupplierQuestionInfo(String biddingNo,Company supCompany);
	
	/**
	 * 采购方尚未回复的所有供应商的所有问题的数量之和
	 * @param biddingNo
	 * @return
	 */
	public int countPurQuestionInfo(String biddingNo);
	
	/**
	 * 采购方答复供应商方问题
	 */
	public void answerSupQuestion(BiddingQuestion question,User purUser);
}