package com.els.base.bidding.service.impl;

import java.util.Date;
import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import com.els.base.bidding.dao.BiddingBondMapper;
import com.els.base.bidding.entity.BiddingBond;
import com.els.base.bidding.entity.BiddingBondExample;
import com.els.base.bidding.service.BiddingBondService;
import com.els.base.core.entity.PageView;

@Service("defaultBiddingBondService")
public class BiddingBondServiceImpl implements BiddingBondService {
    @Resource
    protected BiddingBondMapper biddingBondMapper;

    @CacheEvict(value = { "biddingBond" }, allEntries = true)
    @Override
    public void addObj(BiddingBond t) {
        t.setCreateTime(new Date());
        this.biddingBondMapper.insertSelective(t);
    }

    @CacheEvict(value = { "biddingBond" }, allEntries = true)
    @Override
    public void deleteObjById(String id) {
        this.biddingBondMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value = { "biddingBond" }, allEntries = true)
    @Override
    public void modifyObj(BiddingBond t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.biddingBondMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value = "biddingBond", keyGenerator = "redisKeyGenerator")
    @Override
    public BiddingBond queryObjById(String id) {
        return this.biddingBondMapper.selectByPrimaryKey(id);
    }

//    @Cacheable(value = "biddingBond", keyGenerator = "redisKeyGenerator")
    @Override
    public List<BiddingBond> queryAllObjByExample(BiddingBondExample example) {
        return this.biddingBondMapper.selectByExample(example);
    }

    @Cacheable(value = "biddingBond", keyGenerator = "redisKeyGenerator")
    @Override
    public PageView<BiddingBond> queryObjByPage(BiddingBondExample example) {
        PageView<BiddingBond> pageView = example.getPageView();
        pageView.setQueryResult(this.biddingBondMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    public void deleteByBiddingNo(String biddingNo) {
        BiddingBondExample biddingBondExample = new BiddingBondExample();
        biddingBondExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List<BiddingBond> biddingBondList = this.biddingBondMapper.selectByExample(biddingBondExample);
        for (int i = 0; CollectionUtils.isNotEmpty(biddingBondList) && i < biddingBondList.size(); i++) {
            this.biddingBondMapper.deleteByPrimaryKey(biddingBondList.get(i).getId());
        }
    }
    
 
    @CacheEvict(value = { "biddingBond" }, allEntries = true)
    @Override
    public void modifyObjSup(BiddingBond biddingBond,BiddingBondExample biddingBondExample) {
        this.biddingBondMapper.updateByExampleSelective(biddingBond,biddingBondExample);
    }
    
}