package com.els.base.bidding.service.impl;

import java.util.Date;
import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import com.els.base.bidding.dao.BiddingContactInfoMapper;
import com.els.base.bidding.entity.BiddingContactInfo;
import com.els.base.bidding.entity.BiddingContactInfoExample;
import com.els.base.bidding.service.BiddingContactInfoService;
import com.els.base.core.entity.PageView;

@Service("defaultBiddingContactInfoService")
public class BiddingContactInfoServiceImpl implements BiddingContactInfoService {
    @Resource
    protected BiddingContactInfoMapper biddingContactInfoMapper;

    @CacheEvict(value = { "biddingContactInfo" }, allEntries = true)
    @Override
    public void addObj(BiddingContactInfo t) {
        t.setCreateTime(new Date());
        this.biddingContactInfoMapper.insertSelective(t);
    }

    @CacheEvict(value = { "biddingContactInfo" }, allEntries = true)
    @Override
    public void deleteObjById(String id) {
        this.biddingContactInfoMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value = { "biddingContactInfo" }, allEntries = true)
    @Override
    public void modifyObj(BiddingContactInfo t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.biddingContactInfoMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value = "biddingContactInfo", keyGenerator = "redisKeyGenerator")
    @Override
    public BiddingContactInfo queryObjById(String id) {
        return this.biddingContactInfoMapper.selectByPrimaryKey(id);
    }

//    @Cacheable(value = "biddingContactInfo", keyGenerator = "redisKeyGenerator")
    @Override
    public List<BiddingContactInfo> queryAllObjByExample(BiddingContactInfoExample example) {
        return this.biddingContactInfoMapper.selectByExample(example);
    }

    @Cacheable(value = "biddingContactInfo", keyGenerator = "redisKeyGenerator")
    @Override
    public PageView<BiddingContactInfo> queryObjByPage(BiddingContactInfoExample example) {
        PageView<BiddingContactInfo> pageView = example.getPageView();
        pageView.setQueryResult(this.biddingContactInfoMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    public void deleteByBiddingNo(String biddingNo) {
        BiddingContactInfoExample biddingContactInfoExample = new BiddingContactInfoExample();
        biddingContactInfoExample.createCriteria().andBiddingNoEqualTo(biddingNo);
        List<BiddingContactInfo> biddingContactInfoList = this.biddingContactInfoMapper
                .selectByExample(biddingContactInfoExample);
        for (int i = 0; CollectionUtils.isNotEmpty(biddingContactInfoList)
                && i < biddingContactInfoList.size(); i++) {
            this.biddingContactInfoMapper.deleteByPrimaryKey(biddingContactInfoList.get(i).getId());
        }

    }
}